/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.ibatis.ognl.NoSuchPropertyException;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.PropertyAccessor;
import org.apache.ibatis.ognl.enhance.ExpressionCompiler;
import org.apache.ibatis.ognl.enhance.UnsupportedCompilationException;

public class ObjectPropertyAccessor
implements PropertyAccessor {
    public Object getPossibleProperty(Map context2, Object target, String name) throws OgnlException {
        Object result2;
        OgnlContext ognlContext = (OgnlContext)context2;
        try {
            result2 = OgnlRuntime.getMethodValue(ognlContext, target, name, true);
            if (result2 == OgnlRuntime.NotFound) {
                result2 = OgnlRuntime.getFieldValue(ognlContext, target, name, true);
            }
        }
        catch (IntrospectionException ex) {
            throw new OgnlException(name, ex);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException(name, ex);
        }
        return result2;
    }

    public Object setPossibleProperty(Map context2, Object target, String name, Object value) throws OgnlException {
        Object result2 = null;
        OgnlContext ognlContext = (OgnlContext)context2;
        try {
            Method m;
            if (!OgnlRuntime.setMethodValue(ognlContext, target, name, value, true)) {
                Object object = result2 = OgnlRuntime.setFieldValue(ognlContext, target, name, value) ? null : OgnlRuntime.NotFound;
            }
            if (result2 == OgnlRuntime.NotFound && (m = OgnlRuntime.getWriteMethod(target.getClass(), name)) != null) {
                result2 = m.invoke(target, value);
            }
        }
        catch (IntrospectionException ex) {
            throw new OgnlException(name, ex);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException(name, ex);
        }
        return result2;
    }

    public boolean hasGetProperty(OgnlContext context2, Object target, Object oname) throws OgnlException {
        try {
            return OgnlRuntime.hasGetProperty(context2, target, oname);
        }
        catch (IntrospectionException ex) {
            throw new OgnlException("checking if " + target + " has gettable property " + oname, ex);
        }
    }

    public boolean hasGetProperty(Map context2, Object target, Object oname) throws OgnlException {
        return this.hasGetProperty((OgnlContext)context2, target, oname);
    }

    public boolean hasSetProperty(OgnlContext context2, Object target, Object oname) throws OgnlException {
        try {
            return OgnlRuntime.hasSetProperty(context2, target, oname);
        }
        catch (IntrospectionException ex) {
            throw new OgnlException("checking if " + target + " has settable property " + oname, ex);
        }
    }

    public boolean hasSetProperty(Map context2, Object target, Object oname) throws OgnlException {
        return this.hasSetProperty((OgnlContext)context2, target, oname);
    }

    @Override
    public Object getProperty(Map context2, Object target, Object oname) throws OgnlException {
        Object result2 = null;
        String name = oname.toString();
        result2 = this.getPossibleProperty(context2, target, name);
        if (result2 == OgnlRuntime.NotFound) {
            throw new NoSuchPropertyException(target, name);
        }
        return result2;
    }

    @Override
    public void setProperty(Map context2, Object target, Object oname, Object value) throws OgnlException {
        String name = oname.toString();
        Object result2 = this.setPossibleProperty(context2, target, name, value);
        if (result2 == OgnlRuntime.NotFound) {
            throw new NoSuchPropertyException(target, name);
        }
    }

    public Class getPropertyClass(OgnlContext context2, Object target, Object index) {
        try {
            Method m = OgnlRuntime.getReadMethod(target.getClass(), index.toString());
            if (m == null) {
                if (String.class.isAssignableFrom(index.getClass()) && !target.getClass().isArray()) {
                    String indexStr = (String)index;
                    String key = indexStr.indexOf(34) >= 0 ? indexStr.replaceAll("\"", "") : indexStr;
                    try {
                        Field f = target.getClass().getField(key);
                        if (f != null) {
                            return f.getType();
                        }
                    }
                    catch (NoSuchFieldException e) {
                        return null;
                    }
                }
                return null;
            }
            return m.getReturnType();
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
    }

    @Override
    public String getSourceAccessor(OgnlContext context2, Object target, Object index) {
        try {
            String indexStr = index.toString();
            String methodName = indexStr.indexOf(34) >= 0 ? indexStr.replaceAll("\"", "") : indexStr;
            Method m = OgnlRuntime.getReadMethod(target.getClass(), methodName);
            if (m == null && context2.getCurrentObject() != null) {
                String currentObjectStr = context2.getCurrentObject().toString();
                m = OgnlRuntime.getReadMethod(target.getClass(), currentObjectStr.indexOf(34) >= 0 ? currentObjectStr.replaceAll("\"", "") : currentObjectStr);
            }
            if (m == null) {
                try {
                    Field f;
                    if (String.class.isAssignableFrom(index.getClass()) && !target.getClass().isArray() && (f = target.getClass().getField(methodName)) != null) {
                        context2.setCurrentType(f.getType());
                        context2.setCurrentAccessor(f.getDeclaringClass());
                        return "." + f.getName();
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                return "";
            }
            context2.setCurrentType(m.getReturnType());
            context2.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
            return "." + m.getName() + "()";
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
    }

    @Override
    public String getSourceSetter(OgnlContext context2, Object target, Object index) {
        try {
            String conversion2;
            String indexStr = index.toString();
            String methodName = indexStr.indexOf(34) >= 0 ? indexStr.replaceAll("\"", "") : indexStr;
            Method m = OgnlRuntime.getWriteMethod(target.getClass(), methodName);
            if (m == null && context2.getCurrentObject() != null && context2.getCurrentObject().toString() != null) {
                String currentObjectStr = context2.getCurrentObject().toString();
                m = OgnlRuntime.getWriteMethod(target.getClass(), currentObjectStr.indexOf(34) >= 0 ? currentObjectStr.replaceAll("\"", "") : currentObjectStr);
            }
            if (m == null || m.getParameterTypes() == null || m.getParameterTypes().length <= 0) {
                throw new UnsupportedCompilationException("Unable to determine setting expression on " + context2.getCurrentObject() + " with index of " + index);
            }
            Class<?> parm = m.getParameterTypes()[0];
            if (m.getParameterTypes().length > 1) {
                throw new UnsupportedCompilationException("Object property accessors can only support single parameter setters.");
            }
            if (parm.isPrimitive()) {
                Class wrapClass = OgnlRuntime.getPrimitiveWrapperClass(parm);
                conversion2 = OgnlRuntime.getCompiler().createLocalReference(context2, "((" + wrapClass.getName() + ")ognl.OgnlOps#convertValue($3," + wrapClass.getName() + ".class, true))." + OgnlRuntime.getNumericValueGetter(wrapClass), parm);
            } else {
                conversion2 = parm.isArray() ? OgnlRuntime.getCompiler().createLocalReference(context2, "(" + ExpressionCompiler.getCastString(parm) + ")ognl.OgnlOps#toArray($3," + parm.getComponentType().getName() + ".class)", parm) : OgnlRuntime.getCompiler().createLocalReference(context2, "(" + parm.getName() + ")ognl.OgnlOps#convertValue($3," + parm.getName() + ".class)", parm);
            }
            context2.setCurrentType(m.getReturnType());
            context2.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
            return "." + m.getName() + "(" + conversion2 + ")";
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
    }
}

