/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import org.apache.ibatis.ognl.ASTConst;
import org.apache.ibatis.ognl.ExpressionNode;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.NodeType;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.enhance.ExpressionCompiler;

public abstract class NumericExpression
extends ExpressionNode
implements NodeType {
    protected Class _getterClass;

    public NumericExpression(int id) {
        super(id);
    }

    public NumericExpression(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    public Class getGetterClass() {
        if (this._getterClass != null) {
            return this._getterClass;
        }
        return Double.TYPE;
    }

    @Override
    public Class getSetterClass() {
        return null;
    }

    @Override
    public String toGetSourceString(OgnlContext context2, Object target) {
        Object value = null;
        String result2 = "";
        try {
            value = this.getValueBody(context2, target);
            if (value != null) {
                this._getterClass = value.getClass();
            }
            for (int i = 0; i < this._children.length; ++i) {
                if (i > 0) {
                    result2 = result2 + " " + this.getExpressionOperator(i) + " ";
                }
                String str = OgnlRuntime.getChildSource(context2, target, this._children[i]);
                result2 = result2 + this.coerceToNumeric(str, context2, this._children[i]);
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return result2;
    }

    public String coerceToNumeric(String source, OgnlContext context2, Node child) {
        String ret = source;
        Object value = context2.getCurrentObject();
        if (ASTConst.class.isInstance(child) && value != null) {
            return value.toString();
        }
        if (context2.getCurrentType() != null && !context2.getCurrentType().isPrimitive() && context2.getCurrentObject() != null && Number.class.isInstance(context2.getCurrentObject())) {
            ret = "((" + ExpressionCompiler.getCastString(context2.getCurrentObject().getClass()) + ")" + ret + ")";
            ret = ret + "." + OgnlRuntime.getNumericValueGetter(context2.getCurrentObject().getClass());
        } else if (context2.getCurrentType() != null && context2.getCurrentType().isPrimitive() && (ASTConst.class.isInstance(child) || NumericExpression.class.isInstance(child))) {
            ret = ret + OgnlRuntime.getNumericLiteral(context2.getCurrentType());
        } else if (context2.getCurrentType() != null && String.class.isAssignableFrom(context2.getCurrentType())) {
            ret = "Double.parseDouble(" + ret + ")";
            context2.setCurrentType(Double.TYPE);
        }
        if (NumericExpression.class.isInstance(child)) {
            ret = "(" + ret + ")";
        }
        return ret;
    }
}

