/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.lang.reflect.Array;
import java.util.Map;
import org.apache.ibatis.ognl.DynamicSubscript;
import org.apache.ibatis.ognl.NoSuchPropertyException;
import org.apache.ibatis.ognl.ObjectPropertyAccessor;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.PropertyAccessor;
import org.apache.ibatis.ognl.TypeConverter;

public class ArrayPropertyAccessor
extends ObjectPropertyAccessor
implements PropertyAccessor {
    @Override
    public Object getProperty(Map context2, Object target, Object name) throws OgnlException {
        Object result2 = null;
        if (name instanceof String) {
            result2 = name.equals("length") ? new Integer(Array.getLength(target)) : super.getProperty(context2, target, name);
        } else {
            Object index = name;
            if (index instanceof DynamicSubscript) {
                int len = Array.getLength(target);
                switch (((DynamicSubscript)index).getFlag()) {
                    case 3: {
                        result2 = Array.newInstance(target.getClass().getComponentType(), len);
                        System.arraycopy(target, 0, result2, 0, len);
                        break;
                    }
                    case 0: {
                        index = new Integer(len > 0 ? 0 : -1);
                        break;
                    }
                    case 1: {
                        index = new Integer(len > 0 ? len / 2 : -1);
                        break;
                    }
                    case 2: {
                        index = new Integer(len > 0 ? len - 1 : -1);
                    }
                }
            }
            if (result2 == null) {
                if (index instanceof Number) {
                    int i = ((Number)index).intValue();
                    result2 = i >= 0 ? Array.get(target, i) : null;
                } else {
                    throw new NoSuchPropertyException(target, index);
                }
            }
        }
        return result2;
    }

    @Override
    public void setProperty(Map context2, Object target, Object name, Object value) throws OgnlException {
        Object index = name;
        boolean isNumber = index instanceof Number;
        if (isNumber || index instanceof DynamicSubscript) {
            TypeConverter converter = ((OgnlContext)context2).getTypeConverter();
            Object convertedValue = converter.convertValue(context2, target, null, name.toString(), value, target.getClass().getComponentType());
            if (isNumber) {
                int i = ((Number)index).intValue();
                if (i >= 0) {
                    Array.set(target, i, convertedValue);
                }
            } else {
                int len = Array.getLength(target);
                switch (((DynamicSubscript)index).getFlag()) {
                    case 3: {
                        System.arraycopy(target, 0, convertedValue, 0, len);
                        return;
                    }
                    case 0: {
                        index = new Integer(len > 0 ? 0 : -1);
                        break;
                    }
                    case 1: {
                        index = new Integer(len > 0 ? len / 2 : -1);
                        break;
                    }
                    case 2: {
                        index = new Integer(len > 0 ? len - 1 : -1);
                    }
                }
            }
        } else if (name instanceof String) {
            super.setProperty(context2, target, name, value);
        } else {
            throw new NoSuchPropertyException(target, index);
        }
    }

    @Override
    public String getSourceAccessor(OgnlContext context2, Object target, Object index) {
        String indexStr = index.toString();
        if (context2.getCurrentType() != null && !context2.getCurrentType().isPrimitive() && Number.class.isAssignableFrom(context2.getCurrentType())) {
            indexStr = indexStr + "." + OgnlRuntime.getNumericValueGetter(context2.getCurrentType());
        } else if (context2.getCurrentObject() != null && Number.class.isAssignableFrom(context2.getCurrentObject().getClass()) && !context2.getCurrentType().isPrimitive()) {
            String toString2 = String.class.isInstance(index) && context2.getCurrentType() != Object.class ? "" : ".toString()";
            indexStr = "org.apache.ibatis.ognl.OgnlOps#getIntValue(" + indexStr + toString2 + ")";
        }
        context2.setCurrentAccessor(target.getClass());
        context2.setCurrentType(target.getClass().getComponentType());
        return "[" + indexStr + "]";
    }

    @Override
    public String getSourceSetter(OgnlContext context2, Object target, Object index) {
        String indexStr = index.toString();
        if (context2.getCurrentType() != null && !context2.getCurrentType().isPrimitive() && Number.class.isAssignableFrom(context2.getCurrentType())) {
            indexStr = indexStr + "." + OgnlRuntime.getNumericValueGetter(context2.getCurrentType());
        } else if (context2.getCurrentObject() != null && Number.class.isAssignableFrom(context2.getCurrentObject().getClass()) && !context2.getCurrentType().isPrimitive()) {
            String toString2 = String.class.isInstance(index) && context2.getCurrentType() != Object.class ? "" : ".toString()";
            indexStr = "org.apache.ibatis.ognl.OgnlOps#getIntValue(" + indexStr + toString2 + ")";
        }
        Class<?> type2 = target.getClass().isArray() ? target.getClass().getComponentType() : target.getClass();
        context2.setCurrentAccessor(target.getClass());
        context2.setCurrentType(target.getClass().getComponentType());
        if (type2.isPrimitive()) {
            Class wrapClass = OgnlRuntime.getPrimitiveWrapperClass(type2);
            return "[" + indexStr + "]=((" + wrapClass.getName() + ")ognl.OgnlOps.convertValue($3," + wrapClass.getName() + ".class, true))." + OgnlRuntime.getNumericValueGetter(wrapClass);
        }
        return "[" + indexStr + "]=ognl.OgnlOps.convertValue($3," + type2.getName() + ".class)";
    }
}

