/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import org.apache.ibatis.ognl.NumericExpression;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;

public class ASTUnsignedShiftRight
extends NumericExpression {
    public ASTUnsignedShiftRight(int id) {
        super(id);
    }

    public ASTUnsignedShiftRight(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    protected Object getValueBody(OgnlContext context2, Object source) throws OgnlException {
        Object v1 = this._children[0].getValue(context2, source);
        Object v2 = this._children[1].getValue(context2, source);
        return OgnlOps.unsignedShiftRight(v1, v2);
    }

    @Override
    public String getExpressionOperator(int index) {
        return ">>>";
    }

    @Override
    public String toGetSourceString(OgnlContext context2, Object target) {
        String result2 = "";
        try {
            String child1 = OgnlRuntime.getChildSource(context2, target, this._children[0]);
            child1 = this.coerceToNumeric(child1, context2, this._children[0]);
            String child2 = OgnlRuntime.getChildSource(context2, target, this._children[1]);
            child2 = this.coerceToNumeric(child2, context2, this._children[1]);
            Object v1 = this._children[0].getValue(context2, target);
            int type2 = OgnlOps.getNumericType(v1);
            if (type2 <= 4) {
                child1 = "(int)" + child1;
                child2 = "(int)" + child2;
            }
            result2 = child1 + " >>> " + child2;
            context2.setCurrentType(Integer.TYPE);
            context2.setCurrentObject(this.getValueBody(context2, target));
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return result2;
    }
}

