/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.ibatis.ognl.ASTChain;
import org.apache.ibatis.ognl.ASTConst;
import org.apache.ibatis.ognl.DynamicSubscript;
import org.apache.ibatis.ognl.NoSuchPropertyException;
import org.apache.ibatis.ognl.NodeType;
import org.apache.ibatis.ognl.ObjectIndexedPropertyDescriptor;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.PropertyAccessor;
import org.apache.ibatis.ognl.SimpleNode;
import org.apache.ibatis.ognl.enhance.ExpressionCompiler;
import org.apache.ibatis.ognl.enhance.UnsupportedCompilationException;

public class ASTProperty
extends SimpleNode
implements NodeType {
    private boolean _indexedAccess = false;
    private Class _getterClass;
    private Class _setterClass;

    public ASTProperty(int id) {
        super(id);
    }

    public void setIndexedAccess(boolean value) {
        this._indexedAccess = value;
    }

    public boolean isIndexedAccess() {
        return this._indexedAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexedPropertyType(OgnlContext context2, Object source) throws OgnlException {
        Class type2 = context2.getCurrentType();
        Class prevType = context2.getPreviousType();
        try {
            Object property2;
            if (!this.isIndexedAccess() && (property2 = this.getProperty(context2, source)) instanceof String) {
                int n = OgnlRuntime.getIndexedPropertyType(context2, source == null ? null : OgnlRuntime.getCompiler().getInterfaceClass(source.getClass()), (String)property2);
                return n;
            }
            int n = OgnlRuntime.INDEXED_PROPERTY_NONE;
            return n;
        }
        finally {
            context2.setCurrentObject(source);
            context2.setCurrentType(type2);
            context2.setPreviousType(prevType);
        }
    }

    public Object getProperty(OgnlContext context2, Object source) throws OgnlException {
        return this._children[0].getValue(context2, context2.getRoot());
    }

    @Override
    protected Object getValueBody(OgnlContext context2, Object source) throws OgnlException {
        Object property2 = this.getProperty(context2, source);
        Object result2 = OgnlRuntime.getProperty(context2, source, property2);
        if (result2 == null) {
            result2 = OgnlRuntime.getNullHandler(OgnlRuntime.getTargetClass(source)).nullPropertyValue(context2, source, property2);
        }
        return result2;
    }

    @Override
    protected void setValueBody(OgnlContext context2, Object target, Object value) throws OgnlException {
        OgnlRuntime.setProperty(context2, target, this.getProperty(context2, target), value);
    }

    @Override
    public boolean isNodeSimpleProperty(OgnlContext context2) throws OgnlException {
        return this._children != null && this._children.length == 1 && ((SimpleNode)this._children[0]).isConstant(context2);
    }

    @Override
    public Class getGetterClass() {
        return this._getterClass;
    }

    @Override
    public Class getSetterClass() {
        return this._setterClass;
    }

    @Override
    public String toString() {
        String result2 = this.isIndexedAccess() ? "[" + this._children[0] + "]" : ((ASTConst)this._children[0]).getValue().toString();
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toGetSourceString(OgnlContext context2, Object target) {
        if (context2.getCurrentObject() == null) {
            throw new UnsupportedCompilationException("Current target is null.");
        }
        String result2 = "";
        Method m = null;
        try {
            PropertyDescriptor pd;
            if (this.isIndexedAccess()) {
                String cast;
                Object value = this._children[0].getValue(context2, context2.getRoot());
                if (value == null || DynamicSubscript.class.isAssignableFrom(value.getClass())) {
                    throw new UnsupportedCompilationException("Value passed as indexed property was null or not supported.");
                }
                String srcString = this._children[0].toGetSourceString(context2, context2.getRoot());
                srcString = ExpressionCompiler.getRootExpression(this._children[0], context2.getRoot(), context2) + srcString;
                if (ASTChain.class.isInstance(this._children[0]) && (cast = (String)context2.remove("_preCast")) != null) {
                    srcString = cast + srcString;
                }
                if (ASTConst.class.isInstance(this._children[0]) && String.class.isInstance(context2.getCurrentObject())) {
                    srcString = "\"" + srcString + "\"";
                }
                if (context2.get("_indexedMethod") != null) {
                    m = (Method)context2.remove("_indexedMethod");
                    this._getterClass = m.getReturnType();
                    Object indexedValue = OgnlRuntime.callMethod(context2, target, m.getName(), new Object[]{value});
                    context2.setCurrentType(this._getterClass);
                    context2.setCurrentObject(indexedValue);
                    context2.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
                    return "." + m.getName() + "(" + srcString + ")";
                }
                PropertyAccessor p = OgnlRuntime.getPropertyAccessor(target.getClass());
                Object currObj2 = context2.getCurrentObject();
                Class currType = context2.getCurrentType();
                Class prevType = context2.getPreviousType();
                Object indexVal = p.getProperty(context2, target, value);
                context2.setCurrentObject(currObj2);
                context2.setCurrentType(currType);
                context2.setPreviousType(prevType);
                if (ASTConst.class.isInstance(this._children[0]) && Number.class.isInstance(context2.getCurrentObject())) {
                    context2.setCurrentType(OgnlRuntime.getPrimitiveWrapperClass(context2.getCurrentObject().getClass()));
                }
                result2 = p.getSourceAccessor(context2, target, srcString);
                this._getterClass = context2.getCurrentType();
                context2.setCurrentObject(indexVal);
                return result2;
            }
            String name = ((ASTConst)this._children[0]).getValue().toString();
            if (!Iterator.class.isAssignableFrom(context2.getCurrentObject().getClass()) || Iterator.class.isAssignableFrom(context2.getCurrentObject().getClass()) && name.indexOf("next") < 0) {
                Object currObj = target;
                try {
                    target = this.getValue(context2, context2.getCurrentObject());
                }
                catch (NoSuchPropertyException e) {
                    try {
                        target = this.getValue(context2, context2.getRoot());
                    }
                    catch (NoSuchPropertyException currObj2) {
                        // empty catch block
                    }
                }
                finally {
                    context2.setCurrentObject(currObj);
                }
            }
            if ((pd = OgnlRuntime.getPropertyDescriptor(context2.getCurrentObject().getClass(), name)) != null && pd.getReadMethod() != null && !context2.getMemberAccess().isAccessible(context2, context2.getCurrentObject(), pd.getReadMethod(), name)) {
                throw new UnsupportedCompilationException("Member access forbidden for property " + name + " on class " + context2.getCurrentObject().getClass());
            }
            if (this.getIndexedPropertyType(context2, context2.getCurrentObject()) > 0 && pd != null) {
                if (pd instanceof IndexedPropertyDescriptor) {
                    m = ((IndexedPropertyDescriptor)pd).getIndexedReadMethod();
                } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                    m = ((ObjectIndexedPropertyDescriptor)pd).getIndexedReadMethod();
                } else {
                    throw new OgnlException("property '" + name + "' is not an indexed property");
                }
                if (this._parent == null) {
                    m = OgnlRuntime.getReadMethod(context2.getCurrentObject().getClass(), name);
                    result2 = m.getName() + "()";
                    this._getterClass = m.getReturnType();
                } else {
                    context2.put("_indexedMethod", m);
                }
            } else {
                PropertyAccessor pa = OgnlRuntime.getPropertyAccessor(context2.getCurrentObject().getClass());
                if (context2.getCurrentObject().getClass().isArray()) {
                    if (pd == null) {
                        pd = OgnlRuntime.getProperty(context2.getCurrentObject().getClass(), name);
                        if (pd != null && pd.getReadMethod() != null) {
                            m = pd.getReadMethod();
                            result2 = pd.getName();
                        } else {
                            this._getterClass = Integer.TYPE;
                            context2.setCurrentAccessor(context2.getCurrentObject().getClass());
                            context2.setCurrentType(Integer.TYPE);
                            result2 = "." + name;
                        }
                    }
                } else if (pd != null && pd.getReadMethod() != null) {
                    m = pd.getReadMethod();
                    result2 = "." + m.getName() + "()";
                } else if (pa != null) {
                    Object currObj = context2.getCurrentObject();
                    Class currType = context2.getCurrentType();
                    Class prevType = context2.getPreviousType();
                    String srcString = this._children[0].toGetSourceString(context2, context2.getRoot());
                    if (ASTConst.class.isInstance(this._children[0]) && String.class.isInstance(context2.getCurrentObject())) {
                        srcString = "\"" + srcString + "\"";
                    }
                    context2.setCurrentObject(currObj);
                    context2.setCurrentType(currType);
                    context2.setPreviousType(prevType);
                    result2 = pa.getSourceAccessor(context2, context2.getCurrentObject(), srcString);
                    this._getterClass = context2.getCurrentType();
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        if (m != null) {
            this._getterClass = m.getReturnType();
            context2.setCurrentType(m.getReturnType());
            context2.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
        }
        context2.setCurrentObject(target);
        return result2;
    }

    Method getIndexedWriteMethod(PropertyDescriptor pd) {
        if (IndexedPropertyDescriptor.class.isInstance(pd)) {
            return ((IndexedPropertyDescriptor)pd).getIndexedWriteMethod();
        }
        if (ObjectIndexedPropertyDescriptor.class.isInstance(pd)) {
            return ((ObjectIndexedPropertyDescriptor)pd).getIndexedWriteMethod();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toSetSourceString(OgnlContext context2, Object target) {
        String result2 = "";
        Method m = null;
        if (context2.getCurrentObject() == null) {
            throw new UnsupportedCompilationException("Current target is null.");
        }
        try {
            PropertyDescriptor pd;
            if (this.isIndexedAccess()) {
                String cast;
                Object value = this._children[0].getValue(context2, context2.getRoot());
                if (value == null) {
                    throw new UnsupportedCompilationException("Value passed as indexed property is null, can't enhance statement to bytecode.");
                }
                String srcString = this._children[0].toGetSourceString(context2, context2.getRoot());
                srcString = ExpressionCompiler.getRootExpression(this._children[0], context2.getRoot(), context2) + srcString;
                if (ASTChain.class.isInstance(this._children[0]) && (cast = (String)context2.remove("_preCast")) != null) {
                    srcString = cast + srcString;
                }
                if (ASTConst.class.isInstance(this._children[0]) && String.class.isInstance(context2.getCurrentObject())) {
                    srcString = "\"" + srcString + "\"";
                }
                if (context2.get("_indexedMethod") != null) {
                    m = (Method)context2.remove("_indexedMethod");
                    PropertyDescriptor pd2 = (PropertyDescriptor)context2.remove("_indexedDescriptor");
                    boolean lastChild = this.lastChild(context2);
                    if (lastChild && (m = this.getIndexedWriteMethod(pd2)) == null) {
                        throw new UnsupportedCompilationException("Indexed property has no corresponding write method.");
                    }
                    this._setterClass = m.getParameterTypes()[0];
                    Object indexedValue = null;
                    if (!lastChild) {
                        indexedValue = OgnlRuntime.callMethod(context2, target, m.getName(), new Object[]{value});
                    }
                    context2.setCurrentType(this._setterClass);
                    context2.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
                    if (!lastChild) {
                        context2.setCurrentObject(indexedValue);
                        return "." + m.getName() + "(" + srcString + ")";
                    }
                    return "." + m.getName() + "(" + srcString + ", $3)";
                }
                PropertyAccessor p = OgnlRuntime.getPropertyAccessor(target.getClass());
                Object currObj2 = context2.getCurrentObject();
                Class currType = context2.getCurrentType();
                Class prevType = context2.getPreviousType();
                Object indexVal = p.getProperty(context2, target, value);
                context2.setCurrentObject(currObj2);
                context2.setCurrentType(currType);
                context2.setPreviousType(prevType);
                if (ASTConst.class.isInstance(this._children[0]) && Number.class.isInstance(context2.getCurrentObject())) {
                    context2.setCurrentType(OgnlRuntime.getPrimitiveWrapperClass(context2.getCurrentObject().getClass()));
                }
                result2 = this.lastChild(context2) ? p.getSourceSetter(context2, target, srcString) : p.getSourceAccessor(context2, target, srcString);
                this._getterClass = context2.getCurrentType();
                context2.setCurrentObject(indexVal);
                return result2;
            }
            String name = ((ASTConst)this._children[0]).getValue().toString();
            if (!Iterator.class.isAssignableFrom(context2.getCurrentObject().getClass()) || Iterator.class.isAssignableFrom(context2.getCurrentObject().getClass()) && name.indexOf("next") < 0) {
                Object currObj = target;
                try {
                    target = this.getValue(context2, context2.getCurrentObject());
                }
                catch (NoSuchPropertyException e) {
                    try {
                        target = this.getValue(context2, context2.getRoot());
                    }
                    catch (NoSuchPropertyException currObj2) {
                        // empty catch block
                    }
                }
                finally {
                    context2.setCurrentObject(currObj);
                }
            }
            if ((pd = OgnlRuntime.getPropertyDescriptor(OgnlRuntime.getCompiler().getInterfaceClass(context2.getCurrentObject().getClass()), name)) != null) {
                Method pdMethod;
                Method method = pdMethod = this.lastChild(context2) ? pd.getWriteMethod() : pd.getReadMethod();
                if (pdMethod != null && !context2.getMemberAccess().isAccessible(context2, context2.getCurrentObject(), pdMethod, name)) {
                    throw new UnsupportedCompilationException("Member access forbidden for property " + name + " on class " + context2.getCurrentObject().getClass());
                }
            }
            if (pd != null && this.getIndexedPropertyType(context2, context2.getCurrentObject()) > 0) {
                if (pd instanceof IndexedPropertyDescriptor) {
                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                    m = this.lastChild(context2) ? ipd.getIndexedWriteMethod() : ipd.getIndexedReadMethod();
                } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                    ObjectIndexedPropertyDescriptor opd = (ObjectIndexedPropertyDescriptor)pd;
                    m = this.lastChild(context2) ? opd.getIndexedWriteMethod() : opd.getIndexedReadMethod();
                } else {
                    throw new OgnlException("property '" + name + "' is not an indexed property");
                }
                if (this._parent == null) {
                    m = OgnlRuntime.getWriteMethod(context2.getCurrentObject().getClass(), name);
                    Class<?> parm = m.getParameterTypes()[0];
                    String cast = parm.isArray() ? ExpressionCompiler.getCastString(parm) : parm.getName();
                    result2 = m.getName() + "((" + cast + ")$3)";
                    this._setterClass = parm;
                } else {
                    context2.put("_indexedMethod", m);
                    context2.put("_indexedDescriptor", pd);
                }
            } else {
                PropertyAccessor pa = OgnlRuntime.getPropertyAccessor(context2.getCurrentObject().getClass());
                if (target != null) {
                    this._setterClass = target.getClass();
                }
                if (this._parent != null && pd != null && pa == null) {
                    m = pd.getReadMethod();
                    result2 = m.getName() + "()";
                } else if (context2.getCurrentObject().getClass().isArray()) {
                    result2 = "";
                } else if (pa != null) {
                    Object currObj = context2.getCurrentObject();
                    String srcString = this._children[0].toGetSourceString(context2, context2.getRoot());
                    if (ASTConst.class.isInstance(this._children[0]) && String.class.isInstance(context2.getCurrentObject())) {
                        srcString = "\"" + srcString + "\"";
                    }
                    context2.setCurrentObject(currObj);
                    result2 = !this.lastChild(context2) ? pa.getSourceAccessor(context2, context2.getCurrentObject(), srcString) : pa.getSourceSetter(context2, context2.getCurrentObject(), srcString);
                    this._getterClass = context2.getCurrentType();
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        context2.setCurrentObject(target);
        if (m != null) {
            context2.setCurrentType(m.getReturnType());
            context2.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
        }
        return result2;
    }
}

