/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.ognl.ASTKeyValue;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.SimpleNode;
import org.apache.ibatis.ognl.enhance.UnsupportedCompilationException;

public class ASTMap
extends SimpleNode {
    private static Class DEFAULT_MAP_CLASS;
    private String className;

    public ASTMap(int id) {
        super(id);
    }

    public ASTMap(OgnlParser p, int id) {
        super(p, id);
    }

    protected void setClassName(String value) {
        this.className = value;
    }

    @Override
    protected Object getValueBody(OgnlContext context2, Object source) throws OgnlException {
        Map answer;
        if (this.className == null) {
            try {
                answer = (Map)DEFAULT_MAP_CLASS.newInstance();
            }
            catch (Exception ex) {
                throw new OgnlException("Default Map class '" + DEFAULT_MAP_CLASS.getName() + "' instantiation error", ex);
            }
        }
        try {
            answer = (Map)OgnlRuntime.classForName(context2, this.className).newInstance();
        }
        catch (Exception ex) {
            throw new OgnlException("Map implementor '" + this.className + "' not found", ex);
        }
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ASTKeyValue kv = (ASTKeyValue)this._children[i];
            Node k = kv.getKey();
            Node v = kv.getValue();
            answer.put(k.getValue(context2, source), v == null ? null : v.getValue(context2, source));
        }
        return answer;
    }

    @Override
    public String toString() {
        String result2 = "#";
        if (this.className != null) {
            result2 = result2 + "@" + this.className + "@";
        }
        result2 = result2 + "{ ";
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            ASTKeyValue kv = (ASTKeyValue)this._children[i];
            if (i > 0) {
                result2 = result2 + ", ";
            }
            result2 = result2 + kv.getKey() + " : " + kv.getValue();
        }
        return result2 + " }";
    }

    @Override
    public String toGetSourceString(OgnlContext context2, Object target) {
        throw new UnsupportedCompilationException("Map expressions not supported as native java yet.");
    }

    @Override
    public String toSetSourceString(OgnlContext context2, Object target) {
        throw new UnsupportedCompilationException("Map expressions not supported as native java yet.");
    }

    static {
        try {
            DEFAULT_MAP_CLASS = Class.forName("java.util.LinkedHashMap");
        }
        catch (ClassNotFoundException ex) {
            DEFAULT_MAP_CLASS = HashMap.class;
        }
    }
}

