/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.mapping;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.builder.InitializingObject;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheException;
import org.apache.ibatis.cache.decorators.BlockingCache;
import org.apache.ibatis.cache.decorators.LoggingCache;
import org.apache.ibatis.cache.decorators.LruCache;
import org.apache.ibatis.cache.decorators.ScheduledCache;
import org.apache.ibatis.cache.decorators.SerializedCache;
import org.apache.ibatis.cache.decorators.SynchronizedCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

public class CacheBuilder {
    private final String id;
    private Class<? extends Cache> implementation;
    private final List<Class<? extends Cache>> decorators;
    private Integer size;
    private Long clearInterval;
    private boolean readWrite;
    private Properties properties;
    private boolean blocking;

    public CacheBuilder(String id) {
        this.id = id;
        this.decorators = new ArrayList<Class<? extends Cache>>();
    }

    public CacheBuilder implementation(Class<? extends Cache> implementation) {
        this.implementation = implementation;
        return this;
    }

    public CacheBuilder addDecorator(Class<? extends Cache> decorator) {
        if (decorator != null) {
            this.decorators.add(decorator);
        }
        return this;
    }

    public CacheBuilder size(Integer size2) {
        this.size = size2;
        return this;
    }

    public CacheBuilder clearInterval(Long clearInterval) {
        this.clearInterval = clearInterval;
        return this;
    }

    public CacheBuilder readWrite(boolean readWrite) {
        this.readWrite = readWrite;
        return this;
    }

    public CacheBuilder blocking(boolean blocking) {
        this.blocking = blocking;
        return this;
    }

    public CacheBuilder properties(Properties properties2) {
        this.properties = properties2;
        return this;
    }

    public Cache build() {
        this.setDefaultImplementations();
        Cache cache2 = this.newBaseCacheInstance(this.implementation, this.id);
        this.setCacheProperties(cache2);
        if (PerpetualCache.class.equals(cache2.getClass())) {
            for (Class<? extends Cache> decorator : this.decorators) {
                cache2 = this.newCacheDecoratorInstance(decorator, cache2);
                this.setCacheProperties(cache2);
            }
            cache2 = this.setStandardDecorators(cache2);
        } else if (!LoggingCache.class.isAssignableFrom(cache2.getClass())) {
            cache2 = new LoggingCache(cache2);
        }
        return cache2;
    }

    private void setDefaultImplementations() {
        if (this.implementation == null) {
            this.implementation = PerpetualCache.class;
            if (this.decorators.isEmpty()) {
                this.decorators.add(LruCache.class);
            }
        }
    }

    private Cache setStandardDecorators(Cache cache2) {
        try {
            MetaObject metaCache = SystemMetaObject.forObject(cache2);
            if (this.size != null && metaCache.hasSetter("size")) {
                metaCache.setValue("size", this.size);
            }
            if (this.clearInterval != null) {
                cache2 = new ScheduledCache(cache2);
                ((ScheduledCache)cache2).setClearInterval(this.clearInterval);
            }
            if (this.readWrite) {
                cache2 = new SerializedCache(cache2);
            }
            cache2 = new LoggingCache(cache2);
            cache2 = new SynchronizedCache(cache2);
            if (this.blocking) {
                cache2 = new BlockingCache(cache2);
            }
            return cache2;
        }
        catch (Exception e) {
            throw new CacheException("Error building standard cache decorators.  Cause: " + e, e);
        }
    }

    private void setCacheProperties(Cache cache2) {
        if (this.properties != null) {
            MetaObject metaCache = SystemMetaObject.forObject(cache2);
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!metaCache.hasSetter(name)) continue;
                Class<?> type2 = metaCache.getSetterType(name);
                if (String.class == type2) {
                    metaCache.setValue(name, value);
                    continue;
                }
                if (Integer.TYPE == type2 || Integer.class == type2) {
                    metaCache.setValue(name, Integer.valueOf(value));
                    continue;
                }
                if (Long.TYPE == type2 || Long.class == type2) {
                    metaCache.setValue(name, Long.valueOf(value));
                    continue;
                }
                if (Short.TYPE == type2 || Short.class == type2) {
                    metaCache.setValue(name, Short.valueOf(value));
                    continue;
                }
                if (Byte.TYPE == type2 || Byte.class == type2) {
                    metaCache.setValue(name, Byte.valueOf(value));
                    continue;
                }
                if (Float.TYPE == type2 || Float.class == type2) {
                    metaCache.setValue(name, Float.valueOf(value));
                    continue;
                }
                if (Boolean.TYPE == type2 || Boolean.class == type2) {
                    metaCache.setValue(name, Boolean.valueOf(value));
                    continue;
                }
                if (Double.TYPE == type2 || Double.class == type2) {
                    metaCache.setValue(name, Double.valueOf(value));
                    continue;
                }
                throw new CacheException("Unsupported property type for cache: '" + name + "' of type " + type2);
            }
        }
        if (InitializingObject.class.isAssignableFrom(cache2.getClass())) {
            try {
                ((InitializingObject)((Object)cache2)).initialize();
            }
            catch (Exception e) {
                throw new CacheException("Failed cache initialization for '" + cache2.getId() + "' on '" + cache2.getClass().getName() + "'", e);
            }
        }
    }

    private Cache newBaseCacheInstance(Class<? extends Cache> cacheClass, String id) {
        Constructor<? extends Cache> cacheConstructor = this.getBaseCacheConstructor(cacheClass);
        try {
            return cacheConstructor.newInstance(id);
        }
        catch (Exception e) {
            throw new CacheException("Could not instantiate cache implementation (" + cacheClass + "). Cause: " + e, e);
        }
    }

    private Constructor<? extends Cache> getBaseCacheConstructor(Class<? extends Cache> cacheClass) {
        try {
            return cacheClass.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new CacheException("Invalid base cache implementation (" + cacheClass + ").  Base cache implementations must have a constructor that takes a String id as a parameter.  Cause: " + e, e);
        }
    }

    private Cache newCacheDecoratorInstance(Class<? extends Cache> cacheClass, Cache base) {
        Constructor<? extends Cache> cacheConstructor = this.getCacheDecoratorConstructor(cacheClass);
        try {
            return cacheConstructor.newInstance(base);
        }
        catch (Exception e) {
            throw new CacheException("Could not instantiate cache decorator (" + cacheClass + "). Cause: " + e, e);
        }
    }

    private Constructor<? extends Cache> getCacheDecoratorConstructor(Class<? extends Cache> cacheClass) {
        try {
            return cacheClass.getConstructor(Cache.class);
        }
        catch (Exception e) {
            throw new CacheException("Invalid cache decorator (" + cacheClass + ").  Cache decorators must have a constructor that takes a Cache instance as a parameter.  Cause: " + e, e);
        }
    }
}

