/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSQL<T> {
    private static final String AND = ") \nAND (";
    private static final String OR = ") \nOR (";
    private final SQLStatement sql = new SQLStatement();

    public abstract T getSelf();

    public T UPDATE(String table) {
        this.sql().statementType = SQLStatement.StatementType.UPDATE;
        this.sql().tables.add(table);
        return this.getSelf();
    }

    public T SET(String sets) {
        this.sql().sets.add(sets);
        return this.getSelf();
    }

    public T SET(String ... sets) {
        this.sql().sets.addAll(Arrays.asList(sets));
        return this.getSelf();
    }

    public T INSERT_INTO(String tableName) {
        this.sql().statementType = SQLStatement.StatementType.INSERT;
        this.sql().tables.add(tableName);
        return this.getSelf();
    }

    public T VALUES(String columns, String values2) {
        this.INTO_COLUMNS(columns);
        this.INTO_VALUES(values2);
        return this.getSelf();
    }

    public T INTO_COLUMNS(String ... columns) {
        this.sql().columns.addAll(Arrays.asList(columns));
        return this.getSelf();
    }

    public T INTO_VALUES(String ... values2) {
        List<String> list = this.sql().valuesList.get(this.sql().valuesList.size() - 1);
        Collections.addAll(list, values2);
        return this.getSelf();
    }

    public T SELECT(String columns) {
        this.sql().statementType = SQLStatement.StatementType.SELECT;
        this.sql().select.add(columns);
        return this.getSelf();
    }

    public T SELECT(String ... columns) {
        this.sql().statementType = SQLStatement.StatementType.SELECT;
        this.sql().select.addAll(Arrays.asList(columns));
        return this.getSelf();
    }

    public T SELECT_DISTINCT(String columns) {
        this.sql().distinct = true;
        this.SELECT(columns);
        return this.getSelf();
    }

    public T SELECT_DISTINCT(String ... columns) {
        this.sql().distinct = true;
        this.SELECT(columns);
        return this.getSelf();
    }

    public T DELETE_FROM(String table) {
        this.sql().statementType = SQLStatement.StatementType.DELETE;
        this.sql().tables.add(table);
        return this.getSelf();
    }

    public T FROM(String table) {
        this.sql().tables.add(table);
        return this.getSelf();
    }

    public T FROM(String ... tables) {
        this.sql().tables.addAll(Arrays.asList(tables));
        return this.getSelf();
    }

    public T JOIN(String join) {
        this.sql().join.add(join);
        return this.getSelf();
    }

    public T JOIN(String ... joins) {
        this.sql().join.addAll(Arrays.asList(joins));
        return this.getSelf();
    }

    public T INNER_JOIN(String join) {
        this.sql().innerJoin.add(join);
        return this.getSelf();
    }

    public T INNER_JOIN(String ... joins) {
        this.sql().innerJoin.addAll(Arrays.asList(joins));
        return this.getSelf();
    }

    public T LEFT_OUTER_JOIN(String join) {
        this.sql().leftOuterJoin.add(join);
        return this.getSelf();
    }

    public T LEFT_OUTER_JOIN(String ... joins) {
        this.sql().leftOuterJoin.addAll(Arrays.asList(joins));
        return this.getSelf();
    }

    public T RIGHT_OUTER_JOIN(String join) {
        this.sql().rightOuterJoin.add(join);
        return this.getSelf();
    }

    public T RIGHT_OUTER_JOIN(String ... joins) {
        this.sql().rightOuterJoin.addAll(Arrays.asList(joins));
        return this.getSelf();
    }

    public T OUTER_JOIN(String join) {
        this.sql().outerJoin.add(join);
        return this.getSelf();
    }

    public T OUTER_JOIN(String ... joins) {
        this.sql().outerJoin.addAll(Arrays.asList(joins));
        return this.getSelf();
    }

    public T WHERE(String conditions) {
        this.sql().where.add(conditions);
        this.sql().lastList = this.sql().where;
        return this.getSelf();
    }

    public T WHERE(String ... conditions) {
        this.sql().where.addAll(Arrays.asList(conditions));
        this.sql().lastList = this.sql().where;
        return this.getSelf();
    }

    public T OR() {
        this.sql().lastList.add(OR);
        return this.getSelf();
    }

    public T AND() {
        this.sql().lastList.add(AND);
        return this.getSelf();
    }

    public T GROUP_BY(String columns) {
        this.sql().groupBy.add(columns);
        return this.getSelf();
    }

    public T GROUP_BY(String ... columns) {
        this.sql().groupBy.addAll(Arrays.asList(columns));
        return this.getSelf();
    }

    public T HAVING(String conditions) {
        this.sql().having.add(conditions);
        this.sql().lastList = this.sql().having;
        return this.getSelf();
    }

    public T HAVING(String ... conditions) {
        this.sql().having.addAll(Arrays.asList(conditions));
        this.sql().lastList = this.sql().having;
        return this.getSelf();
    }

    public T ORDER_BY(String columns) {
        this.sql().orderBy.add(columns);
        return this.getSelf();
    }

    public T ORDER_BY(String ... columns) {
        this.sql().orderBy.addAll(Arrays.asList(columns));
        return this.getSelf();
    }

    public T LIMIT(String variable) {
        this.sql().limit = variable;
        this.sql().limitingRowsStrategy = SQLStatement.LimitingRowsStrategy.OFFSET_LIMIT;
        return this.getSelf();
    }

    public T LIMIT(int value) {
        return this.LIMIT(String.valueOf(value));
    }

    public T OFFSET(String variable) {
        this.sql().offset = variable;
        this.sql().limitingRowsStrategy = SQLStatement.LimitingRowsStrategy.OFFSET_LIMIT;
        return this.getSelf();
    }

    public T OFFSET(long value) {
        return this.OFFSET(String.valueOf(value));
    }

    public T FETCH_FIRST_ROWS_ONLY(String variable) {
        this.sql().limit = variable;
        this.sql().limitingRowsStrategy = SQLStatement.LimitingRowsStrategy.ISO;
        return this.getSelf();
    }

    public T FETCH_FIRST_ROWS_ONLY(int value) {
        return this.FETCH_FIRST_ROWS_ONLY(String.valueOf(value));
    }

    public T OFFSET_ROWS(String variable) {
        this.sql().offset = variable;
        this.sql().limitingRowsStrategy = SQLStatement.LimitingRowsStrategy.ISO;
        return this.getSelf();
    }

    public T OFFSET_ROWS(long value) {
        return this.OFFSET_ROWS(String.valueOf(value));
    }

    public T ADD_ROW() {
        this.sql().valuesList.add(new ArrayList());
        return this.getSelf();
    }

    private SQLStatement sql() {
        return this.sql;
    }

    public <A extends Appendable> A usingAppender(A a) {
        this.sql().sql(a);
        return a;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.sql().sql(sb);
        return sb.toString();
    }

    private static class SQLStatement {
        StatementType statementType;
        List<String> sets = new ArrayList<String>();
        List<String> select = new ArrayList<String>();
        List<String> tables = new ArrayList<String>();
        List<String> join = new ArrayList<String>();
        List<String> innerJoin = new ArrayList<String>();
        List<String> outerJoin = new ArrayList<String>();
        List<String> leftOuterJoin = new ArrayList<String>();
        List<String> rightOuterJoin = new ArrayList<String>();
        List<String> where = new ArrayList<String>();
        List<String> having = new ArrayList<String>();
        List<String> groupBy = new ArrayList<String>();
        List<String> orderBy = new ArrayList<String>();
        List<String> lastList = new ArrayList<String>();
        List<String> columns = new ArrayList<String>();
        List<List<String>> valuesList = new ArrayList<List<String>>();
        boolean distinct;
        String offset;
        String limit;
        LimitingRowsStrategy limitingRowsStrategy = LimitingRowsStrategy.NOP;

        public SQLStatement() {
            this.valuesList.add(new ArrayList());
        }

        private void sqlClause(SafeAppendable builder2, String keyword, List<String> parts, String open, String close2, String conjunction) {
            if (!parts.isEmpty()) {
                if (!builder2.isEmpty()) {
                    builder2.append("\n");
                }
                builder2.append(keyword);
                builder2.append(" ");
                builder2.append(open);
                String last2 = "________";
                int n = parts.size();
                for (int i = 0; i < n; ++i) {
                    String part2 = parts.get(i);
                    if (!(i <= 0 || part2.equals(AbstractSQL.AND) || part2.equals(AbstractSQL.OR) || last2.equals(AbstractSQL.AND) || last2.equals(AbstractSQL.OR))) {
                        builder2.append(conjunction);
                    }
                    builder2.append(part2);
                    last2 = part2;
                }
                builder2.append(close2);
            }
        }

        private String selectSQL(SafeAppendable builder2) {
            if (this.distinct) {
                this.sqlClause(builder2, "SELECT DISTINCT", this.select, "", "", ", ");
            } else {
                this.sqlClause(builder2, "SELECT", this.select, "", "", ", ");
            }
            this.sqlClause(builder2, "FROM", this.tables, "", "", ", ");
            this.joins(builder2);
            this.sqlClause(builder2, "WHERE", this.where, "(", ")", " AND ");
            this.sqlClause(builder2, "GROUP BY", this.groupBy, "", "", ", ");
            this.sqlClause(builder2, "HAVING", this.having, "(", ")", " AND ");
            this.sqlClause(builder2, "ORDER BY", this.orderBy, "", "", ", ");
            this.limitingRowsStrategy.appendClause(builder2, this.offset, this.limit);
            return builder2.toString();
        }

        private void joins(SafeAppendable builder2) {
            this.sqlClause(builder2, "JOIN", this.join, "", "", "\nJOIN ");
            this.sqlClause(builder2, "INNER JOIN", this.innerJoin, "", "", "\nINNER JOIN ");
            this.sqlClause(builder2, "OUTER JOIN", this.outerJoin, "", "", "\nOUTER JOIN ");
            this.sqlClause(builder2, "LEFT OUTER JOIN", this.leftOuterJoin, "", "", "\nLEFT OUTER JOIN ");
            this.sqlClause(builder2, "RIGHT OUTER JOIN", this.rightOuterJoin, "", "", "\nRIGHT OUTER JOIN ");
        }

        private String insertSQL(SafeAppendable builder2) {
            this.sqlClause(builder2, "INSERT INTO", this.tables, "", "", "");
            this.sqlClause(builder2, "", this.columns, "(", ")", ", ");
            for (int i = 0; i < this.valuesList.size(); ++i) {
                this.sqlClause(builder2, i > 0 ? "," : "VALUES", this.valuesList.get(i), "(", ")", ", ");
            }
            return builder2.toString();
        }

        private String deleteSQL(SafeAppendable builder2) {
            this.sqlClause(builder2, "DELETE FROM", this.tables, "", "", "");
            this.sqlClause(builder2, "WHERE", this.where, "(", ")", " AND ");
            this.limitingRowsStrategy.appendClause(builder2, null, this.limit);
            return builder2.toString();
        }

        private String updateSQL(SafeAppendable builder2) {
            this.sqlClause(builder2, "UPDATE", this.tables, "", "", "");
            this.joins(builder2);
            this.sqlClause(builder2, "SET", this.sets, "", "", ", ");
            this.sqlClause(builder2, "WHERE", this.where, "(", ")", " AND ");
            this.limitingRowsStrategy.appendClause(builder2, null, this.limit);
            return builder2.toString();
        }

        public String sql(Appendable a) {
            String answer;
            SafeAppendable builder2 = new SafeAppendable(a);
            if (this.statementType == null) {
                return null;
            }
            switch (this.statementType) {
                case DELETE: {
                    answer = this.deleteSQL(builder2);
                    break;
                }
                case INSERT: {
                    answer = this.insertSQL(builder2);
                    break;
                }
                case SELECT: {
                    answer = this.selectSQL(builder2);
                    break;
                }
                case UPDATE: {
                    answer = this.updateSQL(builder2);
                    break;
                }
                default: {
                    answer = null;
                }
            }
            return answer;
        }

        private static enum LimitingRowsStrategy {
            NOP{

                @Override
                protected void appendClause(SafeAppendable builder2, String offset, String limit) {
                }
            }
            ,
            ISO{

                @Override
                protected void appendClause(SafeAppendable builder2, String offset, String limit) {
                    if (offset != null) {
                        builder2.append(" OFFSET ").append(offset).append(" ROWS");
                    }
                    if (limit != null) {
                        builder2.append(" FETCH FIRST ").append(limit).append(" ROWS ONLY");
                    }
                }
            }
            ,
            OFFSET_LIMIT{

                @Override
                protected void appendClause(SafeAppendable builder2, String offset, String limit) {
                    if (limit != null) {
                        builder2.append(" LIMIT ").append(limit);
                    }
                    if (offset != null) {
                        builder2.append(" OFFSET ").append(offset);
                    }
                }
            };


            protected abstract void appendClause(SafeAppendable var1, String var2, String var3);
        }

        public static enum StatementType {
            DELETE,
            INSERT,
            SELECT,
            UPDATE;

        }
    }

    private static class SafeAppendable {
        private final Appendable appendable;
        private boolean empty = true;

        public SafeAppendable(Appendable a) {
            this.appendable = a;
        }

        public SafeAppendable append(CharSequence s) {
            try {
                if (this.empty && s.length() > 0) {
                    this.empty = false;
                }
                this.appendable.append(s);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }
}

