/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.javassist.tools.reflect;

import java.io.PrintStream;
import org.apache.ibatis.javassist.ClassPool;
import org.apache.ibatis.javassist.CtClass;
import org.apache.ibatis.javassist.tools.reflect.CompiledClass;
import org.apache.ibatis.javassist.tools.reflect.Reflection;

public class Compiler {
    public static void main(String[] args2) throws Exception {
        if (args2.length == 0) {
            Compiler.help(System.err);
            return;
        }
        CompiledClass[] entries2 = new CompiledClass[args2.length];
        int n = Compiler.parse(args2, entries2);
        if (n < 1) {
            System.err.println("bad parameter.");
            return;
        }
        Compiler.processClasses(entries2, n);
    }

    private static void processClasses(CompiledClass[] entries2, int n) throws Exception {
        int i;
        Reflection implementor = new Reflection();
        ClassPool pool = ClassPool.getDefault();
        implementor.start(pool);
        for (i = 0; i < n; ++i) {
            CtClass c = pool.get(entries2[i].classname);
            if (entries2[i].metaobject != null || entries2[i].classobject != null) {
                String metaobj = entries2[i].metaobject == null ? "org.apache.ibatis.javassist.tools.reflect.Metaobject" : entries2[i].metaobject;
                String classobj = entries2[i].classobject == null ? "org.apache.ibatis.javassist.tools.reflect.ClassMetaobject" : entries2[i].classobject;
                if (!implementor.makeReflective(c, pool.get(metaobj), pool.get(classobj))) {
                    System.err.println("Warning: " + c.getName() + " is reflective.  It was not changed.");
                }
                System.err.println(c.getName() + ": " + metaobj + ", " + classobj);
                continue;
            }
            System.err.println(c.getName() + ": not reflective");
        }
        for (i = 0; i < n; ++i) {
            implementor.onLoad(pool, entries2[i].classname);
            pool.get(entries2[i].classname).writeFile();
        }
    }

    private static int parse(String[] args2, CompiledClass[] result2) {
        int n = -1;
        for (int i = 0; i < args2.length; ++i) {
            String a = args2[i];
            if (a.equals("-m")) {
                if (n < 0 || i + 1 > args2.length) {
                    return -1;
                }
                result2[n].metaobject = args2[++i];
                continue;
            }
            if (a.equals("-c")) {
                if (n < 0 || i + 1 > args2.length) {
                    return -1;
                }
                result2[n].classobject = args2[++i];
                continue;
            }
            if (a.charAt(0) == '-') {
                return -1;
            }
            CompiledClass cc = new CompiledClass();
            cc.classname = a;
            cc.metaobject = null;
            cc.classobject = null;
            result2[++n] = cc;
        }
        return n + 1;
    }

    private static void help(PrintStream out2) {
        out2.println("Usage: java javassist.tools.reflect.Compiler");
        out2.println("            (<class> [-m <metaobject>] [-c <class metaobject>])+");
    }
}

