/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.javassist.bytecode.stackmap;

import java.util.ArrayList;
import org.apache.ibatis.javassist.ClassPool;
import org.apache.ibatis.javassist.NotFoundException;
import org.apache.ibatis.javassist.bytecode.BadBytecode;
import org.apache.ibatis.javassist.bytecode.ByteArray;
import org.apache.ibatis.javassist.bytecode.CodeAttribute;
import org.apache.ibatis.javassist.bytecode.ConstPool;
import org.apache.ibatis.javassist.bytecode.MethodInfo;
import org.apache.ibatis.javassist.bytecode.StackMap;
import org.apache.ibatis.javassist.bytecode.StackMapTable;
import org.apache.ibatis.javassist.bytecode.stackmap.BasicBlock;
import org.apache.ibatis.javassist.bytecode.stackmap.Tracer;
import org.apache.ibatis.javassist.bytecode.stackmap.TypeData;
import org.apache.ibatis.javassist.bytecode.stackmap.TypedBlock;

public class MapMaker
extends Tracer {
    public static StackMapTable make(ClassPool classes2, MethodInfo minfo) throws BadBytecode {
        TypedBlock[] blocks;
        CodeAttribute ca = minfo.getCodeAttribute();
        if (ca == null) {
            return null;
        }
        try {
            blocks = TypedBlock.makeBlocks(minfo, ca, true);
        }
        catch (BasicBlock.JsrBytecode e) {
            return null;
        }
        if (blocks == null) {
            return null;
        }
        MapMaker mm = new MapMaker(classes2, minfo, ca);
        try {
            mm.make(blocks, ca.getCode());
        }
        catch (BadBytecode bb) {
            throw new BadBytecode(minfo, (Throwable)bb);
        }
        return mm.toStackMap(blocks);
    }

    public static StackMap make2(ClassPool classes2, MethodInfo minfo) throws BadBytecode {
        TypedBlock[] blocks;
        CodeAttribute ca = minfo.getCodeAttribute();
        if (ca == null) {
            return null;
        }
        try {
            blocks = TypedBlock.makeBlocks(minfo, ca, true);
        }
        catch (BasicBlock.JsrBytecode e) {
            return null;
        }
        if (blocks == null) {
            return null;
        }
        MapMaker mm = new MapMaker(classes2, minfo, ca);
        try {
            mm.make(blocks, ca.getCode());
        }
        catch (BadBytecode bb) {
            throw new BadBytecode(minfo, (Throwable)bb);
        }
        return mm.toStackMap2(minfo.getConstPool(), blocks);
    }

    public MapMaker(ClassPool classes2, MethodInfo minfo, CodeAttribute ca) {
        super(classes2, minfo.getConstPool(), ca.getMaxStack(), ca.getMaxLocals(), TypedBlock.getRetType(minfo.getDescriptor()));
    }

    protected MapMaker(MapMaker old) {
        super(old);
    }

    void make(TypedBlock[] blocks, byte[] code) throws BadBytecode {
        this.make(code, blocks[0]);
        this.findDeadCatchers(code, blocks);
        try {
            this.fixTypes(code, blocks);
        }
        catch (NotFoundException e) {
            throw new BadBytecode("failed to resolve types", (Throwable)e);
        }
    }

    private void make(byte[] code, TypedBlock tb) throws BadBytecode {
        int pos;
        MapMaker.copyTypeData(tb.stackTop, tb.stackTypes, this.stackTypes);
        this.stackTop = tb.stackTop;
        MapMaker.copyTypeData(tb.localsTypes.length, tb.localsTypes, this.localsTypes);
        this.traceException(code, tb.toCatch);
        int end2 = pos + tb.length;
        for (pos = tb.position; pos < end2; pos += this.doOpcode(pos, code)) {
            this.traceException(code, tb.toCatch);
        }
        if (tb.exit != null) {
            for (int i = 0; i < tb.exit.length; ++i) {
                TypedBlock e = (TypedBlock)tb.exit[i];
                if (e.alreadySet()) {
                    this.mergeMap(e, true);
                    continue;
                }
                this.recordStackMap(e);
                MapMaker maker = new MapMaker(this);
                maker.make(code, e);
            }
        }
    }

    private void traceException(byte[] code, BasicBlock.Catch handler2) throws BadBytecode {
        while (handler2 != null) {
            TypedBlock tb = (TypedBlock)handler2.body;
            if (tb.alreadySet()) {
                this.mergeMap(tb, false);
                if (tb.stackTop < 1) {
                    throw new BadBytecode("bad catch clause: " + handler2.typeIndex);
                }
                tb.stackTypes[0] = this.merge(this.toExceptionType(handler2.typeIndex), tb.stackTypes[0]);
            } else {
                this.recordStackMap(tb, handler2.typeIndex);
                MapMaker maker = new MapMaker(this);
                maker.make(code, tb);
            }
            handler2 = handler2.next;
        }
    }

    private void mergeMap(TypedBlock dest, boolean mergeStack) throws BadBytecode {
        int i;
        int n = this.localsTypes.length;
        for (i = 0; i < n; ++i) {
            dest.localsTypes[i] = this.merge(MapMaker.validateTypeData(this.localsTypes, n, i), dest.localsTypes[i]);
        }
        if (mergeStack) {
            n = this.stackTop;
            for (i = 0; i < n; ++i) {
                dest.stackTypes[i] = this.merge(this.stackTypes[i], dest.stackTypes[i]);
            }
        }
    }

    private TypeData merge(TypeData src, TypeData target) throws BadBytecode {
        if (src == target) {
            return target;
        }
        if (target instanceof TypeData.ClassName || target instanceof TypeData.BasicType) {
            return target;
        }
        if (target instanceof TypeData.AbsTypeVar) {
            ((TypeData.AbsTypeVar)target).merge(src);
            return target;
        }
        throw new RuntimeException("fatal: this should never happen");
    }

    private void recordStackMap(TypedBlock target) throws BadBytecode {
        TypeData[] tStackTypes = TypeData.make(this.stackTypes.length);
        int st = this.stackTop;
        MapMaker.recordTypeData(st, this.stackTypes, tStackTypes);
        this.recordStackMap0(target, st, tStackTypes);
    }

    private void recordStackMap(TypedBlock target, int exceptionType) throws BadBytecode {
        TypeData[] tStackTypes = TypeData.make(this.stackTypes.length);
        tStackTypes[0] = this.toExceptionType(exceptionType).join();
        this.recordStackMap0(target, 1, tStackTypes);
    }

    private TypeData.ClassName toExceptionType(int exceptionType) {
        String type2 = exceptionType == 0 ? "java.lang.Throwable" : this.cpool.getClassInfo(exceptionType);
        return new TypeData.ClassName(type2);
    }

    private void recordStackMap0(TypedBlock target, int st, TypeData[] tStackTypes) throws BadBytecode {
        int n = this.localsTypes.length;
        TypeData[] tLocalsTypes = TypeData.make(n);
        int k = MapMaker.recordTypeData(n, this.localsTypes, tLocalsTypes);
        target.setStackMap(st, tStackTypes, k, tLocalsTypes);
    }

    protected static int recordTypeData(int n, TypeData[] srcTypes, TypeData[] destTypes) {
        int k = -1;
        for (int i = 0; i < n; ++i) {
            TypeData t = MapMaker.validateTypeData(srcTypes, n, i);
            destTypes[i] = t.join();
            if (t == TOP) continue;
            k = i + 1;
        }
        return k + 1;
    }

    protected static void copyTypeData(int n, TypeData[] srcTypes, TypeData[] destTypes) {
        for (int i = 0; i < n; ++i) {
            destTypes[i] = srcTypes[i];
        }
    }

    private static TypeData validateTypeData(TypeData[] data2, int length, int index) {
        TypeData td = data2[index];
        if (td.is2WordType() && index + 1 < length && data2[index + 1] != TOP) {
            return TOP;
        }
        return td;
    }

    private void findDeadCatchers(byte[] code, TypedBlock[] blocks) throws BadBytecode {
        for (TypedBlock block2 : blocks) {
            TypedBlock tb;
            if (block2.alreadySet()) continue;
            this.fixDeadcode(code, block2);
            BasicBlock.Catch handler2 = block2.toCatch;
            if (handler2 == null || (tb = (TypedBlock)handler2.body).alreadySet()) continue;
            this.recordStackMap(tb, handler2.typeIndex);
            this.fixDeadcode(code, tb);
            tb.incoming = 1;
        }
    }

    private void fixDeadcode(byte[] code, TypedBlock block2) throws BadBytecode {
        int pos = block2.position;
        int len = block2.length - 3;
        if (len < 0) {
            if (len == -1) {
                code[pos] = 0;
            }
            code[pos + block2.length - 1] = -65;
            block2.incoming = 1;
            this.recordStackMap(block2, 0);
            return;
        }
        block2.incoming = 0;
        for (int k = 0; k < len; ++k) {
            code[pos + k] = 0;
        }
        code[pos + len] = -89;
        ByteArray.write16bit(-len, code, pos + len + 1);
    }

    private void fixTypes(byte[] code, TypedBlock[] blocks) throws NotFoundException, BadBytecode {
        ArrayList<TypeData> preOrder = new ArrayList<TypeData>();
        int len = blocks.length;
        int index = 0;
        for (int i = 0; i < len; ++i) {
            int j;
            TypedBlock block2 = blocks[i];
            if (!block2.alreadySet()) continue;
            int n = block2.localsTypes.length;
            for (j = 0; j < n; ++j) {
                index = block2.localsTypes[j].dfs(preOrder, index, this.classPool);
            }
            n = block2.stackTop;
            for (j = 0; j < n; ++j) {
                index = block2.stackTypes[j].dfs(preOrder, index, this.classPool);
            }
        }
    }

    public StackMapTable toStackMap(TypedBlock[] blocks) {
        StackMapTable.Writer writer2 = new StackMapTable.Writer(32);
        int n = blocks.length;
        TypedBlock prev = blocks[0];
        int offsetDelta = prev.length;
        if (prev.incoming > 0) {
            writer2.sameFrame(0);
            --offsetDelta;
        }
        for (int i = 1; i < n; ++i) {
            TypedBlock bb = blocks[i];
            if (this.isTarget(bb, blocks[i - 1])) {
                bb.resetNumLocals();
                int diffL = MapMaker.stackMapDiff(prev.numLocals, prev.localsTypes, bb.numLocals, bb.localsTypes);
                this.toStackMapBody(writer2, bb, diffL, offsetDelta, prev);
                offsetDelta = bb.length - 1;
                prev = bb;
                continue;
            }
            if (bb.incoming == 0) {
                writer2.sameFrame(offsetDelta);
                offsetDelta = bb.length - 1;
                continue;
            }
            offsetDelta += bb.length;
        }
        return writer2.toStackMapTable(this.cpool);
    }

    private boolean isTarget(TypedBlock cur, TypedBlock prev) {
        int in = cur.incoming;
        if (in > 1) {
            return true;
        }
        if (in < 1) {
            return false;
        }
        return prev.stop;
    }

    private void toStackMapBody(StackMapTable.Writer writer2, TypedBlock bb, int diffL, int offsetDelta, TypedBlock prev) {
        int stackTop = bb.stackTop;
        if (stackTop == 0) {
            if (diffL == 0) {
                writer2.sameFrame(offsetDelta);
                return;
            }
            if (0 > diffL && diffL >= -3) {
                writer2.chopFrame(offsetDelta, -diffL);
                return;
            }
            if (0 < diffL && diffL <= 3) {
                int[] data2 = new int[diffL];
                int[] tags = this.fillStackMap(bb.numLocals - prev.numLocals, prev.numLocals, data2, bb.localsTypes);
                writer2.appendFrame(offsetDelta, tags, data2);
                return;
            }
        } else {
            TypeData td;
            if (stackTop == 1 && diffL == 0) {
                TypeData td2 = bb.stackTypes[0];
                writer2.sameLocals(offsetDelta, td2.getTypeTag(), td2.getTypeData(this.cpool));
                return;
            }
            if (stackTop == 2 && diffL == 0 && (td = bb.stackTypes[0]).is2WordType()) {
                writer2.sameLocals(offsetDelta, td.getTypeTag(), td.getTypeData(this.cpool));
                return;
            }
        }
        int[] sdata = new int[stackTop];
        int[] stags = this.fillStackMap(stackTop, 0, sdata, bb.stackTypes);
        int[] ldata = new int[bb.numLocals];
        int[] ltags = this.fillStackMap(bb.numLocals, 0, ldata, bb.localsTypes);
        writer2.fullFrame(offsetDelta, ltags, ldata, stags, sdata);
    }

    private int[] fillStackMap(int num, int offset, int[] data2, TypeData[] types) {
        int realNum = MapMaker.diffSize(types, offset, offset + num);
        ConstPool cp = this.cpool;
        int[] tags = new int[realNum];
        int j = 0;
        for (int i = 0; i < num; ++i) {
            TypeData td = types[offset + i];
            tags[j] = td.getTypeTag();
            data2[j] = td.getTypeData(cp);
            if (td.is2WordType()) {
                ++i;
            }
            ++j;
        }
        return tags;
    }

    private static int stackMapDiff(int oldTdLen, TypeData[] oldTd, int newTdLen, TypeData[] newTd) {
        int diff = newTdLen - oldTdLen;
        int len = diff > 0 ? oldTdLen : newTdLen;
        if (MapMaker.stackMapEq(oldTd, newTd, len)) {
            if (diff > 0) {
                return MapMaker.diffSize(newTd, len, newTdLen);
            }
            return -MapMaker.diffSize(oldTd, len, oldTdLen);
        }
        return -100;
    }

    private static boolean stackMapEq(TypeData[] oldTd, TypeData[] newTd, int len) {
        for (int i = 0; i < len; ++i) {
            if (oldTd[i].eq(newTd[i])) continue;
            return false;
        }
        return true;
    }

    private static int diffSize(TypeData[] types, int offset, int len) {
        int num = 0;
        while (offset < len) {
            TypeData td = types[offset++];
            ++num;
            if (!td.is2WordType()) continue;
            ++offset;
        }
        return num;
    }

    public StackMap toStackMap2(ConstPool cp, TypedBlock[] blocks) {
        int i;
        StackMap.Writer writer2 = new StackMap.Writer();
        int n = blocks.length;
        boolean[] effective = new boolean[n];
        TypedBlock prev = blocks[0];
        effective[0] = prev.incoming > 0;
        int num = effective[0] ? 1 : 0;
        for (i = 1; i < n; ++i) {
            TypedBlock bb = blocks[i];
            effective[i] = this.isTarget(bb, blocks[i - 1]);
            if (!effective[i]) continue;
            bb.resetNumLocals();
            prev = bb;
            ++num;
        }
        if (num == 0) {
            return null;
        }
        writer2.write16bit(num);
        for (i = 0; i < n; ++i) {
            if (!effective[i]) continue;
            this.writeStackFrame(writer2, cp, blocks[i].position, blocks[i]);
        }
        return writer2.toStackMap(cp);
    }

    private void writeStackFrame(StackMap.Writer writer2, ConstPool cp, int offset, TypedBlock tb) {
        writer2.write16bit(offset);
        this.writeVerifyTypeInfo(writer2, cp, tb.localsTypes, tb.numLocals);
        this.writeVerifyTypeInfo(writer2, cp, tb.stackTypes, tb.stackTop);
    }

    private void writeVerifyTypeInfo(StackMap.Writer writer2, ConstPool cp, TypeData[] types, int num) {
        TypeData td;
        int i;
        int numDWord = 0;
        for (i = 0; i < num; ++i) {
            td = types[i];
            if (td == null || !td.is2WordType()) continue;
            ++numDWord;
            ++i;
        }
        writer2.write16bit(num - numDWord);
        for (i = 0; i < num; ++i) {
            td = types[i];
            writer2.writeVerifyTypeInfo(td.getTypeTag(), td.getTypeData(cp));
            if (!td.is2WordType()) continue;
            ++i;
        }
    }
}

