/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.javassist.bytecode.analysis;

import java.io.PrintStream;
import org.apache.ibatis.javassist.CtClass;
import org.apache.ibatis.javassist.CtMethod;
import org.apache.ibatis.javassist.Modifier;
import org.apache.ibatis.javassist.NotFoundException;
import org.apache.ibatis.javassist.bytecode.BadBytecode;
import org.apache.ibatis.javassist.bytecode.CodeAttribute;
import org.apache.ibatis.javassist.bytecode.CodeIterator;
import org.apache.ibatis.javassist.bytecode.ConstPool;
import org.apache.ibatis.javassist.bytecode.Descriptor;
import org.apache.ibatis.javassist.bytecode.InstructionPrinter;
import org.apache.ibatis.javassist.bytecode.MethodInfo;
import org.apache.ibatis.javassist.bytecode.analysis.Analyzer;
import org.apache.ibatis.javassist.bytecode.analysis.Frame;
import org.apache.ibatis.javassist.bytecode.analysis.Type;

public final class FramePrinter {
    private final PrintStream stream;

    public FramePrinter(PrintStream stream) {
        this.stream = stream;
    }

    public static void print(CtClass clazz, PrintStream stream) {
        new FramePrinter(stream).print(clazz);
    }

    public void print(CtClass clazz) {
        CtMethod[] methods2 = clazz.getDeclaredMethods();
        for (int i = 0; i < methods2.length; ++i) {
            this.print(methods2[i]);
        }
    }

    private String getMethodString(CtMethod method) {
        try {
            return Modifier.toString(method.getModifiers()) + " " + method.getReturnType().getName() + " " + method.getName() + Descriptor.toString(method.getSignature()) + ";";
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void print(CtMethod method) {
        Frame[] frames;
        this.stream.println("\n" + this.getMethodString(method));
        MethodInfo info = method.getMethodInfo2();
        ConstPool pool = info.getConstPool();
        CodeAttribute code = info.getCodeAttribute();
        if (code == null) {
            return;
        }
        try {
            frames = new Analyzer().analyze(method.getDeclaringClass(), info);
        }
        catch (BadBytecode e) {
            throw new RuntimeException(e);
        }
        int spacing = String.valueOf(code.getCodeLength()).length();
        CodeIterator iterator2 = code.iterator();
        while (iterator2.hasNext()) {
            int pos;
            try {
                pos = iterator2.next();
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
            this.stream.println(pos + ": " + InstructionPrinter.instructionString(iterator2, pos, pool));
            this.addSpacing(spacing + 3);
            Frame frame = frames[pos];
            if (frame == null) {
                this.stream.println("--DEAD CODE--");
                continue;
            }
            this.printStack(frame);
            this.addSpacing(spacing + 3);
            this.printLocals(frame);
        }
    }

    private void printStack(Frame frame) {
        this.stream.print("stack [");
        int top = frame.getTopIndex();
        for (int i = 0; i <= top; ++i) {
            if (i > 0) {
                this.stream.print(", ");
            }
            Type type2 = frame.getStack(i);
            this.stream.print(type2);
        }
        this.stream.println("]");
    }

    private void printLocals(Frame frame) {
        this.stream.print("locals [");
        int length = frame.localsLength();
        for (int i = 0; i < length; ++i) {
            Type type2;
            if (i > 0) {
                this.stream.print(", ");
            }
            this.stream.print((type2 = frame.getLocal(i)) == null ? "empty" : type2.toString());
        }
        this.stream.println("]");
    }

    private void addSpacing(int count2) {
        while (count2-- > 0) {
            this.stream.print(' ');
        }
    }
}

