/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.ibatis.javassist.bytecode.ConstInfo;
import org.apache.ibatis.javassist.bytecode.ConstPool;
import org.apache.ibatis.javassist.bytecode.Descriptor;

class MethodTypeInfo
extends ConstInfo {
    static final int tag = 16;
    int descriptor;

    public MethodTypeInfo(int desc, int index) {
        super(index);
        this.descriptor = desc;
    }

    public MethodTypeInfo(DataInputStream in, int index) throws IOException {
        super(index);
        this.descriptor = in.readUnsignedShort();
    }

    public int hashCode() {
        return this.descriptor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodTypeInfo) {
            return ((MethodTypeInfo)obj).descriptor == this.descriptor;
        }
        return false;
    }

    @Override
    public int getTag() {
        return 16;
    }

    @Override
    public void renameClass(ConstPool cp, String oldName, String newName, Map<ConstInfo, ConstInfo> cache2) {
        String desc2;
        String desc = cp.getUtf8Info(this.descriptor);
        if (desc != (desc2 = Descriptor.rename(desc, oldName, newName))) {
            if (cache2 == null) {
                this.descriptor = cp.addUtf8Info(desc2);
            } else {
                cache2.remove(this);
                this.descriptor = cp.addUtf8Info(desc2);
                cache2.put(this, this);
            }
        }
    }

    @Override
    public void renameClass(ConstPool cp, Map<String, String> map2, Map<ConstInfo, ConstInfo> cache2) {
        String desc2;
        String desc = cp.getUtf8Info(this.descriptor);
        if (desc != (desc2 = Descriptor.rename(desc, map2))) {
            if (cache2 == null) {
                this.descriptor = cp.addUtf8Info(desc2);
            } else {
                cache2.remove(this);
                this.descriptor = cp.addUtf8Info(desc2);
                cache2.put(this, this);
            }
        }
    }

    @Override
    public int copy(ConstPool src, ConstPool dest, Map<String, String> map2) {
        String desc = src.getUtf8Info(this.descriptor);
        desc = Descriptor.rename(desc, map2);
        return dest.addMethodTypeInfo(dest.addUtf8Info(desc));
    }

    @Override
    public void write(DataOutputStream out2) throws IOException {
        out2.writeByte(16);
        out2.writeShort(this.descriptor);
    }

    @Override
    public void print(PrintWriter out2) {
        out2.print("MethodType #");
        out2.println(this.descriptor);
    }
}

