/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.javassist;

import org.apache.ibatis.javassist.CannotCompileException;
import org.apache.ibatis.javassist.ClassMap;
import org.apache.ibatis.javassist.CtClass;
import org.apache.ibatis.javassist.CtField;
import org.apache.ibatis.javassist.CtMember;
import org.apache.ibatis.javassist.CtMethod;
import org.apache.ibatis.javassist.CtNewWrappedMethod;
import org.apache.ibatis.javassist.Modifier;
import org.apache.ibatis.javassist.NotFoundException;
import org.apache.ibatis.javassist.bytecode.Bytecode;
import org.apache.ibatis.javassist.bytecode.ConstPool;
import org.apache.ibatis.javassist.bytecode.ExceptionsAttribute;
import org.apache.ibatis.javassist.bytecode.FieldInfo;
import org.apache.ibatis.javassist.bytecode.MethodInfo;
import org.apache.ibatis.javassist.compiler.CompileError;
import org.apache.ibatis.javassist.compiler.Javac;

public class CtNewMethod {
    public static CtMethod make(String src, CtClass declaring) throws CannotCompileException {
        return CtNewMethod.make(src, declaring, null, null);
    }

    public static CtMethod make(String src, CtClass declaring, String delegateObj, String delegateMethod) throws CannotCompileException {
        Javac compiler = new Javac(declaring);
        try {
            CtMember obj;
            if (delegateMethod != null) {
                compiler.recordProceed(delegateObj, delegateMethod);
            }
            if ((obj = compiler.compile(src)) instanceof CtMethod) {
                return (CtMethod)obj;
            }
        }
        catch (CompileError e) {
            throw new CannotCompileException(e);
        }
        throw new CannotCompileException("not a method");
    }

    public static CtMethod make(CtClass returnType, String mname, CtClass[] parameters2, CtClass[] exceptions, String body2, CtClass declaring) throws CannotCompileException {
        return CtNewMethod.make(1, returnType, mname, parameters2, exceptions, body2, declaring);
    }

    public static CtMethod make(int modifiers, CtClass returnType, String mname, CtClass[] parameters2, CtClass[] exceptions, String body2, CtClass declaring) throws CannotCompileException {
        try {
            CtMethod cm = new CtMethod(returnType, mname, parameters2, declaring);
            cm.setModifiers(modifiers);
            cm.setExceptionTypes(exceptions);
            cm.setBody(body2);
            return cm;
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    public static CtMethod copy(CtMethod src, CtClass declaring, ClassMap map2) throws CannotCompileException {
        return new CtMethod(src, declaring, map2);
    }

    public static CtMethod copy(CtMethod src, String name, CtClass declaring, ClassMap map2) throws CannotCompileException {
        CtMethod cm = new CtMethod(src, declaring, map2);
        cm.setName(name);
        return cm;
    }

    public static CtMethod abstractMethod(CtClass returnType, String mname, CtClass[] parameters2, CtClass[] exceptions, CtClass declaring) throws NotFoundException {
        CtMethod cm = new CtMethod(returnType, mname, parameters2, declaring);
        cm.setExceptionTypes(exceptions);
        return cm;
    }

    public static CtMethod getter(String methodName, CtField field) throws CannotCompileException {
        FieldInfo finfo = field.getFieldInfo2();
        String fieldType = finfo.getDescriptor();
        String desc = "()" + fieldType;
        ConstPool cp = finfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, methodName, desc);
        minfo.setAccessFlags(1);
        Bytecode code = new Bytecode(cp, 2, 1);
        try {
            String fieldName = finfo.getName();
            if ((finfo.getAccessFlags() & 8) == 0) {
                code.addAload(0);
                code.addGetfield(Bytecode.THIS, fieldName, fieldType);
            } else {
                code.addGetstatic(Bytecode.THIS, fieldName, fieldType);
            }
            code.addReturn(field.getType());
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        minfo.setCodeAttribute(code.toCodeAttribute());
        CtClass cc = field.getDeclaringClass();
        return new CtMethod(minfo, cc);
    }

    public static CtMethod setter(String methodName, CtField field) throws CannotCompileException {
        FieldInfo finfo = field.getFieldInfo2();
        String fieldType = finfo.getDescriptor();
        String desc = "(" + fieldType + ")V";
        ConstPool cp = finfo.getConstPool();
        MethodInfo minfo = new MethodInfo(cp, methodName, desc);
        minfo.setAccessFlags(1);
        Bytecode code = new Bytecode(cp, 3, 3);
        try {
            String fieldName = finfo.getName();
            if ((finfo.getAccessFlags() & 8) == 0) {
                code.addAload(0);
                code.addLoad(1, field.getType());
                code.addPutfield(Bytecode.THIS, fieldName, fieldType);
            } else {
                code.addLoad(1, field.getType());
                code.addPutstatic(Bytecode.THIS, fieldName, fieldType);
            }
            code.addReturn(null);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
        minfo.setCodeAttribute(code.toCodeAttribute());
        CtClass cc = field.getDeclaringClass();
        return new CtMethod(minfo, cc);
    }

    public static CtMethod delegator(CtMethod delegate2, CtClass declaring) throws CannotCompileException {
        try {
            return CtNewMethod.delegator0(delegate2, declaring);
        }
        catch (NotFoundException e) {
            throw new CannotCompileException(e);
        }
    }

    private static CtMethod delegator0(CtMethod delegate2, CtClass declaring) throws CannotCompileException, NotFoundException {
        int s;
        MethodInfo deleInfo = delegate2.getMethodInfo2();
        String methodName = deleInfo.getName();
        String desc = deleInfo.getDescriptor();
        ConstPool cp = declaring.getClassFile2().getConstPool();
        MethodInfo minfo = new MethodInfo(cp, methodName, desc);
        minfo.setAccessFlags(deleInfo.getAccessFlags());
        ExceptionsAttribute eattr = deleInfo.getExceptionsAttribute();
        if (eattr != null) {
            minfo.setExceptionsAttribute((ExceptionsAttribute)eattr.copy(cp, null));
        }
        Bytecode code = new Bytecode(cp, 0, 0);
        boolean isStatic = Modifier.isStatic(delegate2.getModifiers());
        CtClass deleClass = delegate2.getDeclaringClass();
        CtClass[] params2 = delegate2.getParameterTypes();
        if (isStatic) {
            s = code.addLoadParameters(params2, 0);
            code.addInvokestatic(deleClass, methodName, desc);
        } else {
            code.addLoad(0, deleClass);
            s = code.addLoadParameters(params2, 1);
            code.addInvokespecial(deleClass, methodName, desc);
        }
        code.addReturn(delegate2.getReturnType());
        code.setMaxLocals(++s);
        code.setMaxStack(s < 2 ? 2 : s);
        minfo.setCodeAttribute(code.toCodeAttribute());
        return new CtMethod(minfo, declaring);
    }

    public static CtMethod wrapped(CtClass returnType, String mname, CtClass[] parameterTypes, CtClass[] exceptionTypes, CtMethod body2, CtMethod.ConstParameter constParam, CtClass declaring) throws CannotCompileException {
        return CtNewWrappedMethod.wrapped(returnType, mname, parameterTypes, exceptionTypes, body2, constParam, declaring);
    }
}

