/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.io;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class ResolverUtil<T> {
    private static final Log log = LogFactory.getLog(ResolverUtil.class);
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private ClassLoader classloader;

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public ResolverUtil<T> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        IsA test2 = new IsA(parent);
        for (String pkg : packageNames) {
            this.find(test2, pkg);
        }
        return this;
    }

    public ResolverUtil<T> findAnnotated(Class<? extends Annotation> annotation2, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        AnnotatedWith test2 = new AnnotatedWith(annotation2);
        for (String pkg : packageNames) {
            this.find(test2, pkg);
        }
        return this;
    }

    public ResolverUtil<T> find(Test test2, String packageName) {
        String path2 = this.getPackagePath(packageName);
        try {
            List<String> children2 = VFS.getInstance().list(path2);
            for (String child : children2) {
                if (!child.endsWith(".class")) continue;
                this.addIfMatching(test2, child);
            }
        }
        catch (IOException ioe) {
            log.error("Could not read package: " + packageName, ioe);
        }
        return this;
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected void addIfMatching(Test test2, String fqn) {
        try {
            Class<?> type2;
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            if (log.isDebugEnabled()) {
                log.debug("Checking to see if class " + externalName + " matches criteria [" + test2 + "]");
            }
            if (test2.matches(type2 = loader.loadClass(externalName))) {
                this.matches.add(type2);
            }
        }
        catch (Throwable t) {
            log.warn("Could not examine class '" + fqn + "' due to a " + t.getClass().getName() + " with message: " + t.getMessage());
        }
    }

    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;

        public AnnotatedWith(Class<? extends Annotation> annotation2) {
            this.annotation = annotation2;
        }

        @Override
        public boolean matches(Class<?> type2) {
            return type2 != null && type2.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }

    public static class IsA
    implements Test {
        private Class<?> parent;

        public IsA(Class<?> parentType) {
            this.parent = parentType;
        }

        @Override
        public boolean matches(Class<?> type2) {
            return type2 != null && this.parent.isAssignableFrom(type2);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    public static interface Test {
        public boolean matches(Class<?> var1);
    }
}

