/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.statement;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.executor.statement.BaseStatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class SimpleStatementHandler
extends BaseStatementHandler {
    public SimpleStatementHandler(Executor executor, MappedStatement mappedStatement, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        super(executor, mappedStatement, parameter, rowBounds, resultHandler, boundSql);
    }

    @Override
    public int update(Statement statement2) throws SQLException {
        int rows;
        String sql = this.boundSql.getSql();
        Object parameterObject = this.boundSql.getParameterObject();
        KeyGenerator keyGenerator = this.mappedStatement.getKeyGenerator();
        if (keyGenerator instanceof Jdbc3KeyGenerator) {
            statement2.execute(sql, 1);
            rows = statement2.getUpdateCount();
            keyGenerator.processAfter(this.executor, this.mappedStatement, statement2, parameterObject);
        } else if (keyGenerator instanceof SelectKeyGenerator) {
            statement2.execute(sql);
            rows = statement2.getUpdateCount();
            keyGenerator.processAfter(this.executor, this.mappedStatement, statement2, parameterObject);
        } else {
            statement2.execute(sql);
            rows = statement2.getUpdateCount();
        }
        return rows;
    }

    @Override
    public void batch(Statement statement2) throws SQLException {
        String sql = this.boundSql.getSql();
        statement2.addBatch(sql);
    }

    @Override
    public <E> List<E> query(Statement statement2, ResultHandler resultHandler) throws SQLException {
        String sql = this.boundSql.getSql();
        statement2.execute(sql);
        return this.resultSetHandler.handleResultSets(statement2);
    }

    @Override
    public <E> Cursor<E> queryCursor(Statement statement2) throws SQLException {
        String sql = this.boundSql.getSql();
        statement2.execute(sql);
        return this.resultSetHandler.handleCursorResultSets(statement2);
    }

    @Override
    protected Statement instantiateStatement(Connection connection) throws SQLException {
        if (this.mappedStatement.getResultSetType() == ResultSetType.DEFAULT) {
            return connection.createStatement();
        }
        return connection.createStatement(this.mappedStatement.getResultSetType().getValue(), 1007);
    }

    @Override
    public void parameterize(Statement statement2) {
    }
}

