/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.statement;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.CallableStatementHandler;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.SimpleStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class RoutingStatementHandler
implements StatementHandler {
    private final StatementHandler delegate;

    public RoutingStatementHandler(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        switch (ms.getStatementType()) {
            case STATEMENT: {
                this.delegate = new SimpleStatementHandler(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                break;
            }
            case PREPARED: {
                this.delegate = new PreparedStatementHandler(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                break;
            }
            case CALLABLE: {
                this.delegate = new CallableStatementHandler(executor, ms, parameter, rowBounds, resultHandler, boundSql);
                break;
            }
            default: {
                throw new ExecutorException("Unknown statement type: " + (Object)((Object)ms.getStatementType()));
            }
        }
    }

    @Override
    public Statement prepare(Connection connection, Integer transactionTimeout) throws SQLException {
        return this.delegate.prepare(connection, transactionTimeout);
    }

    @Override
    public void parameterize(Statement statement2) throws SQLException {
        this.delegate.parameterize(statement2);
    }

    @Override
    public void batch(Statement statement2) throws SQLException {
        this.delegate.batch(statement2);
    }

    @Override
    public int update(Statement statement2) throws SQLException {
        return this.delegate.update(statement2);
    }

    @Override
    public <E> List<E> query(Statement statement2, ResultHandler resultHandler) throws SQLException {
        return this.delegate.query(statement2, resultHandler);
    }

    @Override
    public <E> Cursor<E> queryCursor(Statement statement2) throws SQLException {
        return this.delegate.queryCursor(statement2);
    }

    @Override
    public BoundSql getBoundSql() {
        return this.delegate.getBoundSql();
    }

    @Override
    public ParameterHandler getParameterHandler() {
        return this.delegate.getParameterHandler();
    }
}

