/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.io.SerialFilterChecker;
import org.apache.ibatis.reflection.factory.ObjectFactory;

public abstract class AbstractSerialStateHolder
implements Externalizable {
    private static final long serialVersionUID = 8940388717901644661L;
    private static final ThreadLocal<ObjectOutputStream> stream = new ThreadLocal();
    private byte[] userBeanBytes = new byte[0];
    private Object userBean;
    private Map<String, ResultLoaderMap.LoadPair> unloadedProperties;
    private ObjectFactory objectFactory;
    private Class<?>[] constructorArgTypes;
    private Object[] constructorArgs;

    public AbstractSerialStateHolder() {
    }

    public AbstractSerialStateHolder(Object userBean, Map<String, ResultLoaderMap.LoadPair> unloadedProperties, ObjectFactory objectFactory, List<Class<?>> constructorArgTypes, List<Object> constructorArgs) {
        this.userBean = userBean;
        this.unloadedProperties = new HashMap<String, ResultLoaderMap.LoadPair>(unloadedProperties);
        this.objectFactory = objectFactory;
        this.constructorArgTypes = constructorArgTypes.toArray(new Class[0]);
        this.constructorArgs = constructorArgs.toArray(new Object[0]);
    }

    @Override
    public final void writeExternal(ObjectOutput out2) throws IOException {
        boolean firstRound = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = stream.get();
        if (os == null) {
            os = new ObjectOutputStream(baos);
            firstRound = true;
            stream.set(os);
        }
        os.writeObject(this.userBean);
        os.writeObject(this.unloadedProperties);
        os.writeObject(this.objectFactory);
        os.writeObject(this.constructorArgTypes);
        os.writeObject(this.constructorArgs);
        byte[] bytes = baos.toByteArray();
        out2.writeObject(bytes);
        if (firstRound) {
            stream.remove();
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object data2 = in.readObject();
        if (data2.getClass().isArray()) {
            this.userBeanBytes = (byte[])data2;
        } else {
            this.userBean = data2;
        }
    }

    protected final Object readResolve() throws ObjectStreamException {
        if (this.userBean != null && this.userBeanBytes.length == 0) {
            return this.userBean;
        }
        SerialFilterChecker.check();
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.userBeanBytes));){
            this.userBean = in.readObject();
            this.unloadedProperties = (Map)in.readObject();
            this.objectFactory = (ObjectFactory)in.readObject();
            this.constructorArgTypes = (Class[])in.readObject();
            this.constructorArgs = (Object[])in.readObject();
        }
        catch (IOException ex) {
            throw (ObjectStreamException)new StreamCorruptedException().initCause(ex);
        }
        catch (ClassNotFoundException ex) {
            throw (ObjectStreamException)new InvalidClassException(ex.getLocalizedMessage()).initCause(ex);
        }
        HashMap<String, ResultLoaderMap.LoadPair> arrayProps = new HashMap<String, ResultLoaderMap.LoadPair>(this.unloadedProperties);
        List<Class<?>> arrayTypes = Arrays.asList(this.constructorArgTypes);
        List<Object> arrayValues = Arrays.asList(this.constructorArgs);
        return this.createDeserializationProxy(this.userBean, arrayProps, this.objectFactory, arrayTypes, arrayValues);
    }

    protected abstract Object createDeserializationProxy(Object var1, Map<String, ResultLoaderMap.LoadPair> var2, ObjectFactory var3, List<Class<?>> var4, List<Object> var5);
}

