/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor;

public class ErrorContext {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final ThreadLocal<ErrorContext> LOCAL = ThreadLocal.withInitial(ErrorContext::new);
    private ErrorContext stored;
    private String resource;
    private String activity;
    private String object;
    private String message;
    private String sql;
    private Throwable cause;

    private ErrorContext() {
    }

    public static ErrorContext instance() {
        return LOCAL.get();
    }

    public ErrorContext store() {
        ErrorContext newContext = new ErrorContext();
        newContext.stored = this;
        LOCAL.set(newContext);
        return LOCAL.get();
    }

    public ErrorContext recall() {
        if (this.stored != null) {
            LOCAL.set(this.stored);
            this.stored = null;
        }
        return LOCAL.get();
    }

    public ErrorContext resource(String resource) {
        this.resource = resource;
        return this;
    }

    public ErrorContext activity(String activity) {
        this.activity = activity;
        return this;
    }

    public ErrorContext object(String object) {
        this.object = object;
        return this;
    }

    public ErrorContext message(String message2) {
        this.message = message2;
        return this;
    }

    public ErrorContext sql(String sql) {
        this.sql = sql;
        return this;
    }

    public ErrorContext cause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    public ErrorContext reset() {
        this.resource = null;
        this.activity = null;
        this.object = null;
        this.message = null;
        this.sql = null;
        this.cause = null;
        LOCAL.remove();
        return this;
    }

    public String toString() {
        StringBuilder description2 = new StringBuilder();
        if (this.message != null) {
            description2.append(LINE_SEPARATOR);
            description2.append("### ");
            description2.append(this.message);
        }
        if (this.resource != null) {
            description2.append(LINE_SEPARATOR);
            description2.append("### The error may exist in ");
            description2.append(this.resource);
        }
        if (this.object != null) {
            description2.append(LINE_SEPARATOR);
            description2.append("### The error may involve ");
            description2.append(this.object);
        }
        if (this.activity != null) {
            description2.append(LINE_SEPARATOR);
            description2.append("### The error occurred while ");
            description2.append(this.activity);
        }
        if (this.sql != null) {
            description2.append(LINE_SEPARATOR);
            description2.append("### SQL: ");
            description2.append(this.sql.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim());
        }
        if (this.cause != null) {
            description2.append(LINE_SEPARATOR);
            description2.append("### Cause: ");
            description2.append(this.cause.toString());
        }
        return description2.toString();
    }
}

