/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.datasource.pooled;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.datasource.pooled.PooledConnection;
import org.apache.ibatis.datasource.pooled.PooledDataSource;

public class PoolState {
    protected PooledDataSource dataSource;
    protected final List<PooledConnection> idleConnections = new ArrayList<PooledConnection>();
    protected final List<PooledConnection> activeConnections = new ArrayList<PooledConnection>();
    protected long requestCount = 0L;
    protected long accumulatedRequestTime = 0L;
    protected long accumulatedCheckoutTime = 0L;
    protected long claimedOverdueConnectionCount = 0L;
    protected long accumulatedCheckoutTimeOfOverdueConnections = 0L;
    protected long accumulatedWaitTime = 0L;
    protected long hadToWaitCount = 0L;
    protected long badConnectionCount = 0L;

    public PoolState(PooledDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public synchronized long getRequestCount() {
        return this.requestCount;
    }

    public synchronized long getAverageRequestTime() {
        return this.requestCount == 0L ? 0L : this.accumulatedRequestTime / this.requestCount;
    }

    public synchronized long getAverageWaitTime() {
        return this.hadToWaitCount == 0L ? 0L : this.accumulatedWaitTime / this.hadToWaitCount;
    }

    public synchronized long getHadToWaitCount() {
        return this.hadToWaitCount;
    }

    public synchronized long getBadConnectionCount() {
        return this.badConnectionCount;
    }

    public synchronized long getClaimedOverdueConnectionCount() {
        return this.claimedOverdueConnectionCount;
    }

    public synchronized long getAverageOverdueCheckoutTime() {
        return this.claimedOverdueConnectionCount == 0L ? 0L : this.accumulatedCheckoutTimeOfOverdueConnections / this.claimedOverdueConnectionCount;
    }

    public synchronized long getAverageCheckoutTime() {
        return this.requestCount == 0L ? 0L : this.accumulatedCheckoutTime / this.requestCount;
    }

    public synchronized int getIdleConnectionCount() {
        return this.idleConnections.size();
    }

    public synchronized int getActiveConnectionCount() {
        return this.activeConnections.size();
    }

    public synchronized String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("\n===CONFIGURATION==============================================");
        builder2.append("\n jdbcDriver                     ").append(this.dataSource.getDriver());
        builder2.append("\n jdbcUrl                        ").append(this.dataSource.getUrl());
        builder2.append("\n jdbcUsername                   ").append(this.dataSource.getUsername());
        builder2.append("\n jdbcPassword                   ").append(this.dataSource.getPassword() == null ? "NULL" : "************");
        builder2.append("\n poolMaxActiveConnections       ").append(this.dataSource.poolMaximumActiveConnections);
        builder2.append("\n poolMaxIdleConnections         ").append(this.dataSource.poolMaximumIdleConnections);
        builder2.append("\n poolMaxCheckoutTime            ").append(this.dataSource.poolMaximumCheckoutTime);
        builder2.append("\n poolTimeToWait                 ").append(this.dataSource.poolTimeToWait);
        builder2.append("\n poolPingEnabled                ").append(this.dataSource.poolPingEnabled);
        builder2.append("\n poolPingQuery                  ").append(this.dataSource.poolPingQuery);
        builder2.append("\n poolPingConnectionsNotUsedFor  ").append(this.dataSource.poolPingConnectionsNotUsedFor);
        builder2.append("\n ---STATUS-----------------------------------------------------");
        builder2.append("\n activeConnections              ").append(this.getActiveConnectionCount());
        builder2.append("\n idleConnections                ").append(this.getIdleConnectionCount());
        builder2.append("\n requestCount                   ").append(this.getRequestCount());
        builder2.append("\n averageRequestTime             ").append(this.getAverageRequestTime());
        builder2.append("\n averageCheckoutTime            ").append(this.getAverageCheckoutTime());
        builder2.append("\n claimedOverdue                 ").append(this.getClaimedOverdueConnectionCount());
        builder2.append("\n averageOverdueCheckoutTime     ").append(this.getAverageOverdueCheckoutTime());
        builder2.append("\n hadToWait                      ").append(this.getHadToWaitCount());
        builder2.append("\n averageWaitTime                ").append(this.getAverageWaitTime());
        builder2.append("\n badConnectionCount             ").append(this.getBadConnectionCount());
        builder2.append("\n===============================================================");
        return builder2.toString();
    }
}

