/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cursor.defaults;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.resultset.DefaultResultSetHandler;
import org.apache.ibatis.executor.resultset.ResultSetWrapper;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class DefaultCursor<T>
implements Cursor<T> {
    private final DefaultResultSetHandler resultSetHandler;
    private final ResultMap resultMap;
    private final ResultSetWrapper rsw;
    private final RowBounds rowBounds;
    protected final ObjectWrapperResultHandler<T> objectWrapperResultHandler = new ObjectWrapperResultHandler();
    private final CursorIterator cursorIterator = new CursorIterator();
    private boolean iteratorRetrieved;
    private CursorStatus status = CursorStatus.CREATED;
    private int indexWithRowBound = -1;

    public DefaultCursor(DefaultResultSetHandler resultSetHandler, ResultMap resultMap, ResultSetWrapper rsw, RowBounds rowBounds) {
        this.resultSetHandler = resultSetHandler;
        this.resultMap = resultMap;
        this.rsw = rsw;
        this.rowBounds = rowBounds;
    }

    @Override
    public boolean isOpen() {
        return this.status == CursorStatus.OPEN;
    }

    @Override
    public boolean isConsumed() {
        return this.status == CursorStatus.CONSUMED;
    }

    @Override
    public int getCurrentIndex() {
        return this.rowBounds.getOffset() + this.cursorIterator.iteratorIndex;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.iteratorRetrieved) {
            throw new IllegalStateException("Cannot open more than one iterator on a Cursor");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("A Cursor is already closed.");
        }
        this.iteratorRetrieved = true;
        return this.cursorIterator;
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        ResultSet rs = this.rsw.getResultSet();
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.status = CursorStatus.CLOSED;
        }
    }

    protected T fetchNextUsingRowBound() {
        T result2 = this.fetchNextObjectFromDatabase();
        while (this.objectWrapperResultHandler.fetched && this.indexWithRowBound < this.rowBounds.getOffset()) {
            result2 = this.fetchNextObjectFromDatabase();
        }
        return result2;
    }

    protected T fetchNextObjectFromDatabase() {
        if (this.isClosed()) {
            return null;
        }
        try {
            this.objectWrapperResultHandler.fetched = false;
            this.status = CursorStatus.OPEN;
            if (!this.rsw.getResultSet().isClosed()) {
                this.resultSetHandler.handleRowValues(this.rsw, this.resultMap, this.objectWrapperResultHandler, RowBounds.DEFAULT, null);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        Object next = this.objectWrapperResultHandler.result;
        if (this.objectWrapperResultHandler.fetched) {
            ++this.indexWithRowBound;
        }
        if (!this.objectWrapperResultHandler.fetched || this.getReadItemsCount() == this.rowBounds.getOffset() + this.rowBounds.getLimit()) {
            this.close();
            this.status = CursorStatus.CONSUMED;
        }
        this.objectWrapperResultHandler.result = null;
        return next;
    }

    private boolean isClosed() {
        return this.status == CursorStatus.CLOSED || this.status == CursorStatus.CONSUMED;
    }

    private int getReadItemsCount() {
        return this.indexWithRowBound + 1;
    }

    protected class CursorIterator
    implements Iterator<T> {
        T object;
        int iteratorIndex = -1;

        protected CursorIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!DefaultCursor.this.objectWrapperResultHandler.fetched) {
                this.object = DefaultCursor.this.fetchNextUsingRowBound();
            }
            return DefaultCursor.this.objectWrapperResultHandler.fetched;
        }

        @Override
        public T next() {
            Object next = this.object;
            if (!DefaultCursor.this.objectWrapperResultHandler.fetched) {
                next = DefaultCursor.this.fetchNextUsingRowBound();
            }
            if (DefaultCursor.this.objectWrapperResultHandler.fetched) {
                DefaultCursor.this.objectWrapperResultHandler.fetched = false;
                this.object = null;
                ++this.iteratorIndex;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove element from Cursor");
        }
    }

    protected static class ObjectWrapperResultHandler<T>
    implements ResultHandler<T> {
        protected T result;
        protected boolean fetched;

        protected ObjectWrapperResultHandler() {
        }

        @Override
        public void handleResult(ResultContext<? extends T> context2) {
            this.result = context2.getResultObject();
            context2.stop();
            this.fetched = true;
        }
    }

    private static enum CursorStatus {
        CREATED,
        OPEN,
        CLOSED,
        CONSUMED;

    }
}

