/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache.decorators;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.ibatis.cache.Cache;

public class WeakCache
implements Cache {
    private final Deque<Object> hardLinksToAvoidGarbageCollection;
    private final ReferenceQueue<Object> queueOfGarbageCollectedEntries;
    private final Cache delegate;
    private int numberOfHardLinks;

    public WeakCache(Cache delegate2) {
        this.delegate = delegate2;
        this.numberOfHardLinks = 256;
        this.hardLinksToAvoidGarbageCollection = new LinkedList<Object>();
        this.queueOfGarbageCollectedEntries = new ReferenceQueue();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        this.removeGarbageCollectedItems();
        return this.delegate.getSize();
    }

    public void setSize(int size2) {
        this.numberOfHardLinks = size2;
    }

    @Override
    public void putObject(Object key, Object value) {
        this.removeGarbageCollectedItems();
        this.delegate.putObject(key, new WeakEntry(key, value, this.queueOfGarbageCollectedEntries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(Object key) {
        Object result2 = null;
        WeakReference weakReference = (WeakReference)this.delegate.getObject(key);
        if (weakReference != null) {
            result2 = weakReference.get();
            if (result2 == null) {
                this.delegate.removeObject(key);
            } else {
                Deque<Object> deque = this.hardLinksToAvoidGarbageCollection;
                synchronized (deque) {
                    this.hardLinksToAvoidGarbageCollection.addFirst(result2);
                    if (this.hardLinksToAvoidGarbageCollection.size() > this.numberOfHardLinks) {
                        this.hardLinksToAvoidGarbageCollection.removeLast();
                    }
                }
            }
        }
        return result2;
    }

    @Override
    public Object removeObject(Object key) {
        this.removeGarbageCollectedItems();
        return this.delegate.removeObject(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Deque<Object> deque = this.hardLinksToAvoidGarbageCollection;
        synchronized (deque) {
            this.hardLinksToAvoidGarbageCollection.clear();
        }
        this.removeGarbageCollectedItems();
        this.delegate.clear();
    }

    private void removeGarbageCollectedItems() {
        WeakEntry sv;
        while ((sv = (WeakEntry)this.queueOfGarbageCollectedEntries.poll()) != null) {
            this.delegate.removeObject(sv.key);
        }
    }

    private static class WeakEntry
    extends WeakReference<Object> {
        private final Object key;

        private WeakEntry(Object key, Object value, ReferenceQueue<Object> garbageCollectionQueue) {
            super(value, garbageCollectionQueue);
            this.key = key;
        }
    }
}

