/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.decorators.TransactionalCache;
import org.apache.ibatis.util.MapUtil;

public class TransactionalCacheManager {
    private final Map<Cache, TransactionalCache> transactionalCaches = new HashMap<Cache, TransactionalCache>();

    public void clear(Cache cache2) {
        this.getTransactionalCache(cache2).clear();
    }

    public Object getObject(Cache cache2, CacheKey key) {
        return this.getTransactionalCache(cache2).getObject(key);
    }

    public void putObject(Cache cache2, CacheKey key, Object value) {
        this.getTransactionalCache(cache2).putObject(key, value);
    }

    public void commit() {
        for (TransactionalCache txCache : this.transactionalCaches.values()) {
            txCache.commit();
        }
    }

    public void rollback() {
        for (TransactionalCache txCache : this.transactionalCaches.values()) {
            txCache.rollback();
        }
    }

    private TransactionalCache getTransactionalCache(Cache cache2) {
        return MapUtil.computeIfAbsent(this.transactionalCaches, cache2, TransactionalCache::new);
    }
}

