/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.CacheRefResolver;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.ResultMapResolver;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.builder.xml.XMLStatementBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.xml.sax.EntityResolver;

public class XMLMapperBuilder
extends BaseBuilder {
    private final XPathParser parser;
    private final MapperBuilderAssistant builderAssistant;
    private final Map<String, XNode> sqlFragments;
    private final String resource;

    @Deprecated
    public XMLMapperBuilder(Reader reader, Configuration configuration, String resource, Map<String, XNode> sqlFragments, String namespace) {
        this(reader, configuration, resource, sqlFragments);
        this.builderAssistant.setCurrentNamespace(namespace);
    }

    @Deprecated
    public XMLMapperBuilder(Reader reader, Configuration configuration, String resource, Map<String, XNode> sqlFragments) {
        this(new XPathParser(reader, true, configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver()), configuration, resource, sqlFragments);
    }

    public XMLMapperBuilder(InputStream inputStream2, Configuration configuration, String resource, Map<String, XNode> sqlFragments, String namespace) {
        this(inputStream2, configuration, resource, sqlFragments);
        this.builderAssistant.setCurrentNamespace(namespace);
    }

    public XMLMapperBuilder(InputStream inputStream2, Configuration configuration, String resource, Map<String, XNode> sqlFragments) {
        this(new XPathParser(inputStream2, true, configuration.getVariables(), (EntityResolver)new XMLMapperEntityResolver()), configuration, resource, sqlFragments);
    }

    private XMLMapperBuilder(XPathParser parser, Configuration configuration, String resource, Map<String, XNode> sqlFragments) {
        super(configuration);
        this.builderAssistant = new MapperBuilderAssistant(configuration, resource);
        this.parser = parser;
        this.sqlFragments = sqlFragments;
        this.resource = resource;
    }

    public void parse() {
        if (!this.configuration.isResourceLoaded(this.resource)) {
            this.configurationElement(this.parser.evalNode("/mapper"));
            this.configuration.addLoadedResource(this.resource);
            this.bindMapperForNamespace();
        }
        this.parsePendingResultMaps();
        this.parsePendingCacheRefs();
        this.parsePendingStatements();
    }

    public XNode getSqlFragment(String refid) {
        return this.sqlFragments.get(refid);
    }

    private void configurationElement(XNode context2) {
        try {
            String namespace = context2.getStringAttribute("namespace");
            if (namespace == null || namespace.isEmpty()) {
                throw new BuilderException("Mapper's namespace cannot be empty");
            }
            this.builderAssistant.setCurrentNamespace(namespace);
            this.cacheRefElement(context2.evalNode("cache-ref"));
            this.cacheElement(context2.evalNode("cache"));
            this.parameterMapElement(context2.evalNodes("/mapper/parameterMap"));
            this.resultMapElements(context2.evalNodes("/mapper/resultMap"));
            this.sqlElement(context2.evalNodes("/mapper/sql"));
            this.buildStatementFromContext(context2.evalNodes("select|insert|update|delete"));
        }
        catch (Exception e) {
            throw new BuilderException("Error parsing Mapper XML. The XML location is '" + this.resource + "'. Cause: " + e, e);
        }
    }

    private void buildStatementFromContext(List<XNode> list) {
        if (this.configuration.getDatabaseId() != null) {
            this.buildStatementFromContext(list, this.configuration.getDatabaseId());
        }
        this.buildStatementFromContext(list, null);
    }

    private void buildStatementFromContext(List<XNode> list, String requiredDatabaseId) {
        for (XNode context2 : list) {
            XMLStatementBuilder statementParser = new XMLStatementBuilder(this.configuration, this.builderAssistant, context2, requiredDatabaseId);
            try {
                statementParser.parseStatementNode();
            }
            catch (IncompleteElementException e) {
                this.configuration.addIncompleteStatement(statementParser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingResultMaps() {
        Collection<ResultMapResolver> incompleteResultMaps;
        Collection<ResultMapResolver> collection = incompleteResultMaps = this.configuration.getIncompleteResultMaps();
        synchronized (collection) {
            Iterator<ResultMapResolver> iter = incompleteResultMaps.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().resolve();
                    iter.remove();
                }
                catch (IncompleteElementException incompleteElementException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingCacheRefs() {
        Collection<CacheRefResolver> incompleteCacheRefs;
        Collection<CacheRefResolver> collection = incompleteCacheRefs = this.configuration.getIncompleteCacheRefs();
        synchronized (collection) {
            Iterator<CacheRefResolver> iter = incompleteCacheRefs.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().resolveCacheRef();
                    iter.remove();
                }
                catch (IncompleteElementException incompleteElementException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingStatements() {
        Collection<XMLStatementBuilder> incompleteStatements;
        Collection<XMLStatementBuilder> collection = incompleteStatements = this.configuration.getIncompleteStatements();
        synchronized (collection) {
            Iterator<XMLStatementBuilder> iter = incompleteStatements.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().parseStatementNode();
                    iter.remove();
                }
                catch (IncompleteElementException incompleteElementException) {}
            }
        }
    }

    private void cacheRefElement(XNode context2) {
        if (context2 != null) {
            this.configuration.addCacheRef(this.builderAssistant.getCurrentNamespace(), context2.getStringAttribute("namespace"));
            CacheRefResolver cacheRefResolver = new CacheRefResolver(this.builderAssistant, context2.getStringAttribute("namespace"));
            try {
                cacheRefResolver.resolveCacheRef();
            }
            catch (IncompleteElementException e) {
                this.configuration.addIncompleteCacheRef(cacheRefResolver);
            }
        }
    }

    private void cacheElement(XNode context2) {
        if (context2 != null) {
            String type2 = context2.getStringAttribute("type", "PERPETUAL");
            Class typeClass = this.typeAliasRegistry.resolveAlias(type2);
            String eviction = context2.getStringAttribute("eviction", "LRU");
            Class evictionClass = this.typeAliasRegistry.resolveAlias(eviction);
            Long flushInterval = context2.getLongAttribute("flushInterval");
            Integer size2 = context2.getIntAttribute("size");
            boolean readWrite = context2.getBooleanAttribute("readOnly", false) == false;
            boolean blocking = context2.getBooleanAttribute("blocking", false);
            Properties props = context2.getChildrenAsProperties();
            this.builderAssistant.useNewCache(typeClass, evictionClass, flushInterval, size2, readWrite, blocking, props);
        }
    }

    private void parameterMapElement(List<XNode> list) {
        for (XNode parameterMapNode : list) {
            String id = parameterMapNode.getStringAttribute("id");
            String type2 = parameterMapNode.getStringAttribute("type");
            Class parameterClass = this.resolveClass(type2);
            List<XNode> parameterNodes = parameterMapNode.evalNodes("parameter");
            ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
            for (XNode parameterNode : parameterNodes) {
                String property2 = parameterNode.getStringAttribute("property");
                String javaType = parameterNode.getStringAttribute("javaType");
                String jdbcType = parameterNode.getStringAttribute("jdbcType");
                String resultMap = parameterNode.getStringAttribute("resultMap");
                String mode = parameterNode.getStringAttribute("mode");
                String typeHandler = parameterNode.getStringAttribute("typeHandler");
                Integer numericScale = parameterNode.getIntAttribute("numericScale");
                ParameterMode modeEnum = this.resolveParameterMode(mode);
                Class javaTypeClass = this.resolveClass(javaType);
                JdbcType jdbcTypeEnum = this.resolveJdbcType(jdbcType);
                Class typeHandlerClass = this.resolveClass(typeHandler);
                ParameterMapping parameterMapping = this.builderAssistant.buildParameterMapping(parameterClass, property2, javaTypeClass, jdbcTypeEnum, resultMap, modeEnum, typeHandlerClass, numericScale);
                parameterMappings.add(parameterMapping);
            }
            this.builderAssistant.addParameterMap(id, parameterClass, parameterMappings);
        }
    }

    private void resultMapElements(List<XNode> list) {
        for (XNode resultMapNode : list) {
            try {
                this.resultMapElement(resultMapNode);
            }
            catch (IncompleteElementException incompleteElementException) {}
        }
    }

    private ResultMap resultMapElement(XNode resultMapNode) {
        return this.resultMapElement(resultMapNode, Collections.emptyList(), null);
    }

    private ResultMap resultMapElement(XNode resultMapNode, List<ResultMapping> additionalResultMappings, Class<?> enclosingType) {
        ErrorContext.instance().activity("processing " + resultMapNode.getValueBasedIdentifier());
        String type2 = resultMapNode.getStringAttribute("type", resultMapNode.getStringAttribute("ofType", resultMapNode.getStringAttribute("resultType", resultMapNode.getStringAttribute("javaType"))));
        Class<Object> typeClass = this.resolveClass(type2);
        if (typeClass == null) {
            typeClass = this.inheritEnclosingType(resultMapNode, enclosingType);
        }
        Discriminator discriminator = null;
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>(additionalResultMappings);
        List<XNode> resultChildren = resultMapNode.getChildren();
        for (XNode resultChild : resultChildren) {
            if ("constructor".equals(resultChild.getName())) {
                this.processConstructorElement(resultChild, typeClass, resultMappings);
                continue;
            }
            if ("discriminator".equals(resultChild.getName())) {
                discriminator = this.processDiscriminatorElement(resultChild, typeClass, resultMappings);
                continue;
            }
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if ("id".equals(resultChild.getName())) {
                flags.add(ResultFlag.ID);
            }
            resultMappings.add(this.buildResultMappingFromContext(resultChild, typeClass, flags));
        }
        String id = resultMapNode.getStringAttribute("id", resultMapNode.getValueBasedIdentifier());
        String extend = resultMapNode.getStringAttribute("extends");
        Boolean autoMapping = resultMapNode.getBooleanAttribute("autoMapping");
        ResultMapResolver resultMapResolver = new ResultMapResolver(this.builderAssistant, id, typeClass, extend, discriminator, resultMappings, autoMapping);
        try {
            return resultMapResolver.resolve();
        }
        catch (IncompleteElementException e) {
            this.configuration.addIncompleteResultMap(resultMapResolver);
            throw e;
        }
    }

    protected Class<?> inheritEnclosingType(XNode resultMapNode, Class<?> enclosingType) {
        if ("association".equals(resultMapNode.getName()) && resultMapNode.getStringAttribute("resultMap") == null) {
            String property2 = resultMapNode.getStringAttribute("property");
            if (property2 != null && enclosingType != null) {
                MetaClass metaResultType = MetaClass.forClass(enclosingType, this.configuration.getReflectorFactory());
                return metaResultType.getSetterType(property2);
            }
        } else if ("case".equals(resultMapNode.getName()) && resultMapNode.getStringAttribute("resultMap") == null) {
            return enclosingType;
        }
        return null;
    }

    private void processConstructorElement(XNode resultChild, Class<?> resultType, List<ResultMapping> resultMappings) {
        List<XNode> argChildren = resultChild.getChildren();
        for (XNode argChild : argChildren) {
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            flags.add(ResultFlag.CONSTRUCTOR);
            if ("idArg".equals(argChild.getName())) {
                flags.add(ResultFlag.ID);
            }
            resultMappings.add(this.buildResultMappingFromContext(argChild, resultType, flags));
        }
    }

    private Discriminator processDiscriminatorElement(XNode context2, Class<?> resultType, List<ResultMapping> resultMappings) {
        String column2 = context2.getStringAttribute("column");
        String javaType = context2.getStringAttribute("javaType");
        String jdbcType = context2.getStringAttribute("jdbcType");
        String typeHandler = context2.getStringAttribute("typeHandler");
        Class javaTypeClass = this.resolveClass(javaType);
        Class typeHandlerClass = this.resolveClass(typeHandler);
        JdbcType jdbcTypeEnum = this.resolveJdbcType(jdbcType);
        HashMap<String, String> discriminatorMap = new HashMap<String, String>();
        for (XNode caseChild : context2.getChildren()) {
            String value = caseChild.getStringAttribute("value");
            String resultMap = caseChild.getStringAttribute("resultMap", this.processNestedResultMappings(caseChild, resultMappings, resultType));
            discriminatorMap.put(value, resultMap);
        }
        return this.builderAssistant.buildDiscriminator(resultType, column2, javaTypeClass, jdbcTypeEnum, typeHandlerClass, discriminatorMap);
    }

    private void sqlElement(List<XNode> list) {
        if (this.configuration.getDatabaseId() != null) {
            this.sqlElement(list, this.configuration.getDatabaseId());
        }
        this.sqlElement(list, null);
    }

    private void sqlElement(List<XNode> list, String requiredDatabaseId) {
        for (XNode context2 : list) {
            String databaseId = context2.getStringAttribute("databaseId");
            String id = context2.getStringAttribute("id");
            if (!this.databaseIdMatchesCurrent(id = this.builderAssistant.applyCurrentNamespace(id, false), databaseId, requiredDatabaseId)) continue;
            this.sqlFragments.put(id, context2);
        }
    }

    private boolean databaseIdMatchesCurrent(String id, String databaseId, String requiredDatabaseId) {
        if (requiredDatabaseId != null) {
            return requiredDatabaseId.equals(databaseId);
        }
        if (databaseId != null) {
            return false;
        }
        if (!this.sqlFragments.containsKey(id)) {
            return true;
        }
        XNode context2 = this.sqlFragments.get(id);
        return context2.getStringAttribute("databaseId") == null;
    }

    private ResultMapping buildResultMappingFromContext(XNode context2, Class<?> resultType, List<ResultFlag> flags) {
        String property2 = flags.contains((Object)ResultFlag.CONSTRUCTOR) ? context2.getStringAttribute("name") : context2.getStringAttribute("property");
        String column2 = context2.getStringAttribute("column");
        String javaType = context2.getStringAttribute("javaType");
        String jdbcType = context2.getStringAttribute("jdbcType");
        String nestedSelect = context2.getStringAttribute("select");
        String nestedResultMap = context2.getStringAttribute("resultMap", () -> this.processNestedResultMappings(context2, Collections.emptyList(), resultType));
        String notNullColumn = context2.getStringAttribute("notNullColumn");
        String columnPrefix = context2.getStringAttribute("columnPrefix");
        String typeHandler = context2.getStringAttribute("typeHandler");
        String resultSet = context2.getStringAttribute("resultSet");
        String foreignColumn = context2.getStringAttribute("foreignColumn");
        boolean lazy = "lazy".equals(context2.getStringAttribute("fetchType", this.configuration.isLazyLoadingEnabled() ? "lazy" : "eager"));
        Class javaTypeClass = this.resolveClass(javaType);
        Class typeHandlerClass = this.resolveClass(typeHandler);
        JdbcType jdbcTypeEnum = this.resolveJdbcType(jdbcType);
        return this.builderAssistant.buildResultMapping(resultType, property2, column2, javaTypeClass, jdbcTypeEnum, nestedSelect, nestedResultMap, notNullColumn, columnPrefix, typeHandlerClass, flags, resultSet, foreignColumn, lazy);
    }

    private String processNestedResultMappings(XNode context2, List<ResultMapping> resultMappings, Class<?> enclosingType) {
        if (Arrays.asList("association", "collection", "case").contains(context2.getName()) && context2.getStringAttribute("select") == null) {
            this.validateCollection(context2, enclosingType);
            ResultMap resultMap = this.resultMapElement(context2, resultMappings, enclosingType);
            return resultMap.getId();
        }
        return null;
    }

    protected void validateCollection(XNode context2, Class<?> enclosingType) {
        String property2;
        MetaClass metaResultType;
        if ("collection".equals(context2.getName()) && context2.getStringAttribute("resultMap") == null && context2.getStringAttribute("javaType") == null && !(metaResultType = MetaClass.forClass(enclosingType, this.configuration.getReflectorFactory())).hasSetter(property2 = context2.getStringAttribute("property"))) {
            throw new BuilderException("Ambiguous collection type for property '" + property2 + "'. You must specify 'javaType' or 'resultMap'.");
        }
    }

    private void bindMapperForNamespace() {
        String namespace = this.builderAssistant.getCurrentNamespace();
        if (namespace != null) {
            Class<?> boundType = null;
            try {
                boundType = Resources.classForName(namespace);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (boundType != null && !this.configuration.hasMapper(boundType)) {
                this.configuration.addLoadedResource("namespace:" + namespace);
                this.configuration.addMapper(boundType);
            }
        }
    }
}

