/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLIncludeTransformer {
    private final Configuration configuration;
    private final MapperBuilderAssistant builderAssistant;

    public XMLIncludeTransformer(Configuration configuration, MapperBuilderAssistant builderAssistant) {
        this.configuration = configuration;
        this.builderAssistant = builderAssistant;
    }

    public void applyIncludes(Node source) {
        Properties variablesContext = new Properties();
        Properties configurationVariables = this.configuration.getVariables();
        Optional.ofNullable(configurationVariables).ifPresent(variablesContext::putAll);
        this.applyIncludes(source, variablesContext, false);
    }

    private void applyIncludes(Node source, Properties variablesContext, boolean included) {
        if ("include".equals(source.getNodeName())) {
            Node toInclude = this.findSqlFragment(this.getStringAttribute(source, "refid"), variablesContext);
            Properties toIncludeContext = this.getVariablesContext(source, variablesContext);
            this.applyIncludes(toInclude, toIncludeContext, true);
            if (toInclude.getOwnerDocument() != source.getOwnerDocument()) {
                toInclude = source.getOwnerDocument().importNode(toInclude, true);
            }
            source.getParentNode().replaceChild(toInclude, source);
            while (toInclude.hasChildNodes()) {
                toInclude.getParentNode().insertBefore(toInclude.getFirstChild(), toInclude);
            }
            toInclude.getParentNode().removeChild(toInclude);
        } else if (source.getNodeType() == 1) {
            int i;
            if (included && !variablesContext.isEmpty()) {
                NamedNodeMap attributes2 = source.getAttributes();
                for (i = 0; i < attributes2.getLength(); ++i) {
                    Node attr = attributes2.item(i);
                    attr.setNodeValue(PropertyParser.parse(attr.getNodeValue(), variablesContext));
                }
            }
            NodeList children2 = source.getChildNodes();
            for (i = 0; i < children2.getLength(); ++i) {
                this.applyIncludes(children2.item(i), variablesContext, included);
            }
        } else if (included && (source.getNodeType() == 3 || source.getNodeType() == 4) && !variablesContext.isEmpty()) {
            source.setNodeValue(PropertyParser.parse(source.getNodeValue(), variablesContext));
        }
    }

    private Node findSqlFragment(String refid, Properties variables) {
        refid = PropertyParser.parse(refid, variables);
        refid = this.builderAssistant.applyCurrentNamespace(refid, true);
        try {
            XNode nodeToInclude = this.configuration.getSqlFragments().get(refid);
            return nodeToInclude.getNode().cloneNode(true);
        }
        catch (IllegalArgumentException e) {
            throw new IncompleteElementException("Could not find SQL statement to include with refid '" + refid + "'", e);
        }
    }

    private String getStringAttribute(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    private Properties getVariablesContext(Node node, Properties inheritedVariablesContext) {
        HashMap<String, String> declaredProperties2 = null;
        NodeList children2 = node.getChildNodes();
        for (int i = 0; i < children2.getLength(); ++i) {
            Node n = children2.item(i);
            if (n.getNodeType() != 1) continue;
            String name = this.getStringAttribute(n, "name");
            String value = PropertyParser.parse(this.getStringAttribute(n, "value"), inheritedVariablesContext);
            if (declaredProperties2 == null) {
                declaredProperties2 = new HashMap<String, String>();
            }
            if (declaredProperties2.put(name, value) == null) continue;
            throw new BuilderException("Variable " + name + " defined twice in the same include definition");
        }
        if (declaredProperties2 == null) {
            return inheritedVariablesContext;
        }
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)inheritedVariablesContext);
        newProperties.putAll((Map<?, ?>)declaredProperties2);
        return newProperties;
    }
}

