/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.CacheNamespace;
import org.apache.ibatis.annotations.CacheNamespaceRef;
import org.apache.ibatis.annotations.Case;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Lang;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Options;
import org.apache.ibatis.annotations.Property;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.SelectKey;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.TypeDiscriminator;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.CacheRefResolver;
import org.apache.ibatis.builder.IncompleteElementException;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.builder.annotation.MethodResolver;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Discriminator;
import org.apache.ibatis.mapping.FetchType;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.ResultSetType;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.UnknownTypeHandler;

public class MapperAnnotationBuilder {
    private static final Set<Class<? extends Annotation>> statementAnnotationTypes = Stream.of(Select.class, Update.class, Insert.class, Delete.class, SelectProvider.class, UpdateProvider.class, InsertProvider.class, DeleteProvider.class).collect(Collectors.toSet());
    private final Configuration configuration;
    private final MapperBuilderAssistant assistant;
    private final Class<?> type;

    public MapperAnnotationBuilder(Configuration configuration, Class<?> type2) {
        String resource = type2.getName().replace('.', '/') + ".java (best guess)";
        this.assistant = new MapperBuilderAssistant(configuration, resource);
        this.configuration = configuration;
        this.type = type2;
    }

    public void parse() {
        String resource = this.type.toString();
        if (!this.configuration.isResourceLoaded(resource)) {
            this.loadXmlResource();
            this.configuration.addLoadedResource(resource);
            this.assistant.setCurrentNamespace(this.type.getName());
            this.parseCache();
            this.parseCacheRef();
            for (Method method : this.type.getMethods()) {
                if (!this.canHaveStatement(method)) continue;
                if (this.getAnnotationWrapper(method, false, Select.class, SelectProvider.class).isPresent() && method.getAnnotation(ResultMap.class) == null) {
                    this.parseResultMap(method);
                }
                try {
                    this.parseStatement(method);
                }
                catch (IncompleteElementException e) {
                    this.configuration.addIncompleteMethod(new MethodResolver(this, method));
                }
            }
        }
        this.parsePendingMethods();
    }

    private boolean canHaveStatement(Method method) {
        return !method.isBridge() && !method.isDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePendingMethods() {
        Collection<MethodResolver> incompleteMethods;
        Collection<MethodResolver> collection = incompleteMethods = this.configuration.getIncompleteMethods();
        synchronized (collection) {
            Iterator<MethodResolver> iter = incompleteMethods.iterator();
            while (iter.hasNext()) {
                try {
                    iter.next().resolve();
                    iter.remove();
                }
                catch (IncompleteElementException incompleteElementException) {}
            }
        }
    }

    private void loadXmlResource() {
        if (!this.configuration.isResourceLoaded("namespace:" + this.type.getName())) {
            String xmlResource = this.type.getName().replace('.', '/') + ".xml";
            InputStream inputStream2 = this.type.getResourceAsStream("/" + xmlResource);
            if (inputStream2 == null) {
                try {
                    inputStream2 = Resources.getResourceAsStream(this.type.getClassLoader(), xmlResource);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (inputStream2 != null) {
                XMLMapperBuilder xmlParser = new XMLMapperBuilder(inputStream2, this.assistant.getConfiguration(), xmlResource, this.configuration.getSqlFragments(), this.type.getName());
                xmlParser.parse();
            }
        }
    }

    private void parseCache() {
        CacheNamespace cacheDomain = this.type.getAnnotation(CacheNamespace.class);
        if (cacheDomain != null) {
            Integer size2 = cacheDomain.size() == 0 ? null : Integer.valueOf(cacheDomain.size());
            Long flushInterval = cacheDomain.flushInterval() == 0L ? null : Long.valueOf(cacheDomain.flushInterval());
            Properties props = this.convertToProperties(cacheDomain.properties());
            this.assistant.useNewCache(cacheDomain.implementation(), cacheDomain.eviction(), flushInterval, size2, cacheDomain.readWrite(), cacheDomain.blocking(), props);
        }
    }

    private Properties convertToProperties(Property[] properties2) {
        if (properties2.length == 0) {
            return null;
        }
        Properties props = new Properties();
        for (Property property2 : properties2) {
            props.setProperty(property2.name(), PropertyParser.parse(property2.value(), this.configuration.getVariables()));
        }
        return props;
    }

    private void parseCacheRef() {
        CacheNamespaceRef cacheDomainRef = this.type.getAnnotation(CacheNamespaceRef.class);
        if (cacheDomainRef != null) {
            Class<?> refType = cacheDomainRef.value();
            String refName = cacheDomainRef.name();
            if (refType == Void.TYPE && refName.isEmpty()) {
                throw new BuilderException("Should be specified either value() or name() attribute in the @CacheNamespaceRef");
            }
            if (refType != Void.TYPE && !refName.isEmpty()) {
                throw new BuilderException("Cannot use both value() and name() attribute in the @CacheNamespaceRef");
            }
            String namespace = refType != Void.TYPE ? refType.getName() : refName;
            try {
                this.assistant.useCacheRef(namespace);
            }
            catch (IncompleteElementException e) {
                this.configuration.addIncompleteCacheRef(new CacheRefResolver(this.assistant, namespace));
            }
        }
    }

    private String parseResultMap(Method method) {
        Class<?> returnType = this.getReturnType(method);
        Arg[] args2 = (Arg[])method.getAnnotationsByType(Arg.class);
        Result[] results = (Result[])method.getAnnotationsByType(Result.class);
        TypeDiscriminator typeDiscriminator = method.getAnnotation(TypeDiscriminator.class);
        String resultMapId = this.generateResultMapName(method);
        this.applyResultMap(resultMapId, returnType, args2, results, typeDiscriminator);
        return resultMapId;
    }

    private String generateResultMapName(Method method) {
        Results results = method.getAnnotation(Results.class);
        if (results != null && !results.id().isEmpty()) {
            return this.type.getName() + "." + results.id();
        }
        StringBuilder suffix = new StringBuilder();
        for (Class<?> c : method.getParameterTypes()) {
            suffix.append("-");
            suffix.append(c.getSimpleName());
        }
        if (suffix.length() < 1) {
            suffix.append("-void");
        }
        return this.type.getName() + "." + method.getName() + suffix;
    }

    private void applyResultMap(String resultMapId, Class<?> returnType, Arg[] args2, Result[] results, TypeDiscriminator discriminator) {
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        this.applyConstructorArgs(args2, returnType, resultMappings);
        this.applyResults(results, returnType, resultMappings);
        Discriminator disc = this.applyDiscriminator(resultMapId, returnType, discriminator);
        this.assistant.addResultMap(resultMapId, returnType, null, disc, resultMappings, null);
        this.createDiscriminatorResultMaps(resultMapId, returnType, discriminator);
    }

    private void createDiscriminatorResultMaps(String resultMapId, Class<?> resultType, TypeDiscriminator discriminator) {
        if (discriminator != null) {
            for (Case c : discriminator.cases()) {
                String caseResultMapId = resultMapId + "-" + c.value();
                ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
                this.applyConstructorArgs(c.constructArgs(), resultType, resultMappings);
                this.applyResults(c.results(), resultType, resultMappings);
                this.assistant.addResultMap(caseResultMapId, c.type(), resultMapId, null, resultMappings, null);
            }
        }
    }

    private Discriminator applyDiscriminator(String resultMapId, Class<?> resultType, TypeDiscriminator discriminator) {
        if (discriminator != null) {
            String column2 = discriminator.column();
            Class javaType = discriminator.javaType() == Void.TYPE ? String.class : discriminator.javaType();
            JdbcType jdbcType = discriminator.jdbcType() == JdbcType.UNDEFINED ? null : discriminator.jdbcType();
            Class<? extends TypeHandler> typeHandler = discriminator.typeHandler() == UnknownTypeHandler.class ? null : discriminator.typeHandler();
            Case[] cases = discriminator.cases();
            HashMap<String, String> discriminatorMap = new HashMap<String, String>();
            for (Case c : cases) {
                String value = c.value();
                String caseResultMapId = resultMapId + "-" + value;
                discriminatorMap.put(value, caseResultMapId);
            }
            return this.assistant.buildDiscriminator(resultType, column2, javaType, jdbcType, typeHandler, discriminatorMap);
        }
        return null;
    }

    void parseStatement(Method method) {
        Class<?> parameterTypeClass = this.getParameterType(method);
        LanguageDriver languageDriver = this.getLanguageDriver(method);
        this.getAnnotationWrapper(method, true, statementAnnotationTypes).ifPresent(statementAnnotation -> {
            KeyGenerator keyGenerator;
            SqlSource sqlSource = this.buildSqlSource(statementAnnotation.getAnnotation(), parameterTypeClass, languageDriver, method);
            SqlCommandType sqlCommandType = statementAnnotation.getSqlCommandType();
            Options options2 = this.getAnnotationWrapper(method, false, Options.class).map(x -> (Options)x.getAnnotation()).orElse(null);
            String mappedStatementId = this.type.getName() + "." + method.getName();
            String keyProperty = null;
            String keyColumn = null;
            if (SqlCommandType.INSERT.equals((Object)sqlCommandType) || SqlCommandType.UPDATE.equals((Object)sqlCommandType)) {
                SelectKey selectKey = this.getAnnotationWrapper(method, false, SelectKey.class).map(x -> (SelectKey)x.getAnnotation()).orElse(null);
                if (selectKey != null) {
                    keyGenerator = this.handleSelectKeyAnnotation(selectKey, mappedStatementId, this.getParameterType(method), languageDriver);
                    keyProperty = selectKey.keyProperty();
                } else if (options2 == null) {
                    keyGenerator = this.configuration.isUseGeneratedKeys() ? Jdbc3KeyGenerator.INSTANCE : NoKeyGenerator.INSTANCE;
                } else {
                    keyGenerator = options2.useGeneratedKeys() ? Jdbc3KeyGenerator.INSTANCE : NoKeyGenerator.INSTANCE;
                    keyProperty = options2.keyProperty();
                    keyColumn = options2.keyColumn();
                }
            } else {
                keyGenerator = NoKeyGenerator.INSTANCE;
            }
            Integer fetchSize = null;
            Integer timeout2 = null;
            StatementType statementType = StatementType.PREPARED;
            ResultSetType resultSetType = this.configuration.getDefaultResultSetType();
            boolean isSelect = sqlCommandType == SqlCommandType.SELECT;
            boolean flushCache = !isSelect;
            boolean useCache = isSelect;
            if (options2 != null) {
                if (Options.FlushCachePolicy.TRUE.equals((Object)options2.flushCache())) {
                    flushCache = true;
                } else if (Options.FlushCachePolicy.FALSE.equals((Object)options2.flushCache())) {
                    flushCache = false;
                }
                useCache = options2.useCache();
                fetchSize = options2.fetchSize() > -1 || options2.fetchSize() == Integer.MIN_VALUE ? Integer.valueOf(options2.fetchSize()) : null;
                timeout2 = options2.timeout() > -1 ? Integer.valueOf(options2.timeout()) : null;
                statementType = options2.statementType();
                if (options2.resultSetType() != ResultSetType.DEFAULT) {
                    resultSetType = options2.resultSetType();
                }
            }
            String resultMapId = null;
            if (isSelect) {
                ResultMap resultMapAnnotation = method.getAnnotation(ResultMap.class);
                resultMapId = resultMapAnnotation != null ? String.join((CharSequence)",", resultMapAnnotation.value()) : this.generateResultMapName(method);
            }
            this.assistant.addMappedStatement(mappedStatementId, sqlSource, statementType, sqlCommandType, fetchSize, timeout2, null, parameterTypeClass, resultMapId, this.getReturnType(method), resultSetType, flushCache, useCache, false, keyGenerator, keyProperty, keyColumn, statementAnnotation.getDatabaseId(), languageDriver, options2 != null ? this.nullOrEmpty(options2.resultSets()) : null);
        });
    }

    private LanguageDriver getLanguageDriver(Method method) {
        Lang lang = method.getAnnotation(Lang.class);
        Class<? extends LanguageDriver> langClass = null;
        if (lang != null) {
            langClass = lang.value();
        }
        return this.configuration.getLanguageDriver(langClass);
    }

    private Class<?> getParameterType(Method method) {
        Class<?>[] parameterTypes;
        Class<Object> parameterType = null;
        for (Class<?> currentParameterType : parameterTypes = method.getParameterTypes()) {
            if (RowBounds.class.isAssignableFrom(currentParameterType) || ResultHandler.class.isAssignableFrom(currentParameterType)) continue;
            parameterType = parameterType == null ? currentParameterType : MapperMethod.ParamMap.class;
        }
        return parameterType;
    }

    private Class<?> getReturnType(Method method) {
        Class returnType = method.getReturnType();
        Type resolvedReturnType = TypeParameterResolver.resolveReturnType(method, this.type);
        if (resolvedReturnType instanceof Class) {
            ResultType rt;
            returnType = (Class)resolvedReturnType;
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
            }
            if (Void.TYPE.equals(returnType) && (rt = method.getAnnotation(ResultType.class)) != null) {
                returnType = rt.value();
            }
        } else if (resolvedReturnType instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            Type returnTypeParameter;
            ParameterizedType parameterizedType = (ParameterizedType)resolvedReturnType;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Collection.class.isAssignableFrom(rawType) || Cursor.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments2 = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments2 != null && actualTypeArguments2.length == 1) {
                    Type returnTypeParameter2 = actualTypeArguments2[0];
                    if (returnTypeParameter2 instanceof Class) {
                        returnType = (Class)returnTypeParameter2;
                    } else if (returnTypeParameter2 instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter2).getRawType();
                    } else if (returnTypeParameter2 instanceof GenericArrayType) {
                        Class componentType = (Class)((GenericArrayType)returnTypeParameter2).getGenericComponentType();
                        returnType = Array.newInstance(componentType, 0).getClass();
                    }
                }
            } else if (method.isAnnotationPresent(MapKey.class) && Map.class.isAssignableFrom(rawType)) {
                Type[] actualTypeArguments3 = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments3 != null && actualTypeArguments3.length == 2) {
                    Type returnTypeParameter3 = actualTypeArguments3[1];
                    if (returnTypeParameter3 instanceof Class) {
                        returnType = (Class)returnTypeParameter3;
                    } else if (returnTypeParameter3 instanceof ParameterizedType) {
                        returnType = (Class)((ParameterizedType)returnTypeParameter3).getRawType();
                    }
                }
            } else if (Optional.class.equals((Object)rawType) && (returnTypeParameter = (actualTypeArguments = parameterizedType.getActualTypeArguments())[0]) instanceof Class) {
                returnType = (Class)returnTypeParameter;
            }
        }
        return returnType;
    }

    private void applyResults(Result[] results, Class<?> resultType, List<ResultMapping> resultMappings) {
        for (Result result2 : results) {
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (result2.id()) {
                flags.add(ResultFlag.ID);
            }
            Class<? extends TypeHandler> typeHandler = result2.typeHandler() == UnknownTypeHandler.class ? null : result2.typeHandler();
            boolean hasNestedResultMap = this.hasNestedResultMap(result2);
            ResultMapping resultMapping = this.assistant.buildResultMapping(resultType, this.nullOrEmpty(result2.property()), this.nullOrEmpty(result2.column()), result2.javaType() == Void.TYPE ? null : result2.javaType(), result2.jdbcType() == JdbcType.UNDEFINED ? null : result2.jdbcType(), this.hasNestedSelect(result2) ? this.nestedSelectId(result2) : null, hasNestedResultMap ? this.nestedResultMapId(result2) : null, null, hasNestedResultMap ? this.findColumnPrefix(result2) : null, typeHandler, flags, null, null, this.isLazy(result2));
            resultMappings.add(resultMapping);
        }
    }

    private String findColumnPrefix(Result result2) {
        String columnPrefix = result2.one().columnPrefix();
        if (columnPrefix.length() < 1) {
            columnPrefix = result2.many().columnPrefix();
        }
        return columnPrefix;
    }

    private String nestedResultMapId(Result result2) {
        String resultMapId = result2.one().resultMap();
        if (resultMapId.length() < 1) {
            resultMapId = result2.many().resultMap();
        }
        if (!resultMapId.contains(".")) {
            resultMapId = this.type.getName() + "." + resultMapId;
        }
        return resultMapId;
    }

    private boolean hasNestedResultMap(Result result2) {
        if (result2.one().resultMap().length() > 0 && result2.many().resultMap().length() > 0) {
            throw new BuilderException("Cannot use both @One and @Many annotations in the same @Result");
        }
        return result2.one().resultMap().length() > 0 || result2.many().resultMap().length() > 0;
    }

    private String nestedSelectId(Result result2) {
        String nestedSelect = result2.one().select();
        if (nestedSelect.length() < 1) {
            nestedSelect = result2.many().select();
        }
        if (!nestedSelect.contains(".")) {
            nestedSelect = this.type.getName() + "." + nestedSelect;
        }
        return nestedSelect;
    }

    private boolean isLazy(Result result2) {
        boolean isLazy = this.configuration.isLazyLoadingEnabled();
        if (result2.one().select().length() > 0 && FetchType.DEFAULT != result2.one().fetchType()) {
            isLazy = result2.one().fetchType() == FetchType.LAZY;
        } else if (result2.many().select().length() > 0 && FetchType.DEFAULT != result2.many().fetchType()) {
            isLazy = result2.many().fetchType() == FetchType.LAZY;
        }
        return isLazy;
    }

    private boolean hasNestedSelect(Result result2) {
        if (result2.one().select().length() > 0 && result2.many().select().length() > 0) {
            throw new BuilderException("Cannot use both @One and @Many annotations in the same @Result");
        }
        return result2.one().select().length() > 0 || result2.many().select().length() > 0;
    }

    private void applyConstructorArgs(Arg[] args2, Class<?> resultType, List<ResultMapping> resultMappings) {
        for (Arg arg : args2) {
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            flags.add(ResultFlag.CONSTRUCTOR);
            if (arg.id()) {
                flags.add(ResultFlag.ID);
            }
            Class<? extends TypeHandler> typeHandler = arg.typeHandler() == UnknownTypeHandler.class ? null : arg.typeHandler();
            ResultMapping resultMapping = this.assistant.buildResultMapping(resultType, this.nullOrEmpty(arg.name()), this.nullOrEmpty(arg.column()), arg.javaType() == Void.TYPE ? null : arg.javaType(), arg.jdbcType() == JdbcType.UNDEFINED ? null : arg.jdbcType(), this.nullOrEmpty(arg.select()), this.nullOrEmpty(arg.resultMap()), null, this.nullOrEmpty(arg.columnPrefix()), typeHandler, flags, null, null, false);
            resultMappings.add(resultMapping);
        }
    }

    private String nullOrEmpty(String value) {
        return value == null || value.trim().length() == 0 ? null : value;
    }

    private KeyGenerator handleSelectKeyAnnotation(SelectKey selectKeyAnnotation, String baseStatementId, Class<?> parameterTypeClass, LanguageDriver languageDriver) {
        String id = baseStatementId + "!selectKey";
        Class<?> resultTypeClass = selectKeyAnnotation.resultType();
        StatementType statementType = selectKeyAnnotation.statementType();
        String keyProperty = selectKeyAnnotation.keyProperty();
        String keyColumn = selectKeyAnnotation.keyColumn();
        boolean executeBefore = selectKeyAnnotation.before();
        boolean useCache = false;
        NoKeyGenerator keyGenerator = NoKeyGenerator.INSTANCE;
        Integer fetchSize = null;
        Integer timeout2 = null;
        boolean flushCache = false;
        String parameterMap = null;
        String resultMap = null;
        ResultSetType resultSetTypeEnum = null;
        String databaseId = selectKeyAnnotation.databaseId().isEmpty() ? null : selectKeyAnnotation.databaseId();
        SqlSource sqlSource = this.buildSqlSource(selectKeyAnnotation, parameterTypeClass, languageDriver, null);
        SqlCommandType sqlCommandType = SqlCommandType.SELECT;
        this.assistant.addMappedStatement(id, sqlSource, statementType, sqlCommandType, fetchSize, timeout2, parameterMap, parameterTypeClass, resultMap, resultTypeClass, resultSetTypeEnum, flushCache, useCache, false, keyGenerator, keyProperty, keyColumn, databaseId, languageDriver, null);
        id = this.assistant.applyCurrentNamespace(id, false);
        MappedStatement keyStatement = this.configuration.getMappedStatement(id, false);
        SelectKeyGenerator answer = new SelectKeyGenerator(keyStatement, executeBefore);
        this.configuration.addKeyGenerator(id, answer);
        return answer;
    }

    private SqlSource buildSqlSource(Annotation annotation2, Class<?> parameterType, LanguageDriver languageDriver, Method method) {
        if (annotation2 instanceof Select) {
            return this.buildSqlSourceFromStrings(((Select)annotation2).value(), parameterType, languageDriver);
        }
        if (annotation2 instanceof Update) {
            return this.buildSqlSourceFromStrings(((Update)annotation2).value(), parameterType, languageDriver);
        }
        if (annotation2 instanceof Insert) {
            return this.buildSqlSourceFromStrings(((Insert)annotation2).value(), parameterType, languageDriver);
        }
        if (annotation2 instanceof Delete) {
            return this.buildSqlSourceFromStrings(((Delete)annotation2).value(), parameterType, languageDriver);
        }
        if (annotation2 instanceof SelectKey) {
            return this.buildSqlSourceFromStrings(((SelectKey)annotation2).statement(), parameterType, languageDriver);
        }
        return new ProviderSqlSource(this.assistant.getConfiguration(), annotation2, this.type, method);
    }

    private SqlSource buildSqlSourceFromStrings(String[] strings, Class<?> parameterTypeClass, LanguageDriver languageDriver) {
        return languageDriver.createSqlSource(this.configuration, String.join((CharSequence)" ", strings).trim(), parameterTypeClass);
    }

    @SafeVarargs
    private final Optional<AnnotationWrapper> getAnnotationWrapper(Method method, boolean errorIfNoMatch, Class<? extends Annotation> ... targetTypes) {
        return this.getAnnotationWrapper(method, errorIfNoMatch, Arrays.asList(targetTypes));
    }

    private Optional<AnnotationWrapper> getAnnotationWrapper(Method method, boolean errorIfNoMatch, Collection<Class<? extends Annotation>> targetTypes) {
        String databaseId = this.configuration.getDatabaseId();
        Map<String, AnnotationWrapper> statementAnnotations = targetTypes.stream().flatMap(x -> Arrays.stream(method.getAnnotationsByType((Class)x))).map(x$0 -> new AnnotationWrapper((Annotation)x$0)).collect(Collectors.toMap(AnnotationWrapper::getDatabaseId, x -> x, (existing, duplicate) -> {
            throw new BuilderException(String.format("Detected conflicting annotations '%s' and '%s' on '%s'.", existing.getAnnotation(), duplicate.getAnnotation(), method.getDeclaringClass().getName() + "." + method.getName()));
        }));
        AnnotationWrapper annotationWrapper = null;
        if (databaseId != null) {
            annotationWrapper = statementAnnotations.get(databaseId);
        }
        if (annotationWrapper == null) {
            annotationWrapper = statementAnnotations.get("");
        }
        if (errorIfNoMatch && annotationWrapper == null && !statementAnnotations.isEmpty()) {
            throw new BuilderException(String.format("Could not find a statement annotation that correspond a current database or default statement on method '%s.%s'. Current database id is [%s].", method.getDeclaringClass().getName(), method.getName(), databaseId));
        }
        return Optional.ofNullable(annotationWrapper);
    }

    private class AnnotationWrapper {
        private final Annotation annotation;
        private final String databaseId;
        private final SqlCommandType sqlCommandType;

        AnnotationWrapper(Annotation annotation2) {
            this.annotation = annotation2;
            if (annotation2 instanceof Select) {
                this.databaseId = ((Select)annotation2).databaseId();
                this.sqlCommandType = SqlCommandType.SELECT;
            } else if (annotation2 instanceof Update) {
                this.databaseId = ((Update)annotation2).databaseId();
                this.sqlCommandType = SqlCommandType.UPDATE;
            } else if (annotation2 instanceof Insert) {
                this.databaseId = ((Insert)annotation2).databaseId();
                this.sqlCommandType = SqlCommandType.INSERT;
            } else if (annotation2 instanceof Delete) {
                this.databaseId = ((Delete)annotation2).databaseId();
                this.sqlCommandType = SqlCommandType.DELETE;
            } else if (annotation2 instanceof SelectProvider) {
                this.databaseId = ((SelectProvider)annotation2).databaseId();
                this.sqlCommandType = SqlCommandType.SELECT;
            } else if (annotation2 instanceof UpdateProvider) {
                this.databaseId = ((UpdateProvider)annotation2).databaseId();
                this.sqlCommandType = SqlCommandType.UPDATE;
            } else if (annotation2 instanceof InsertProvider) {
                this.databaseId = ((InsertProvider)annotation2).databaseId();
                this.sqlCommandType = SqlCommandType.INSERT;
            } else if (annotation2 instanceof DeleteProvider) {
                this.databaseId = ((DeleteProvider)annotation2).databaseId();
                this.sqlCommandType = SqlCommandType.DELETE;
            } else {
                this.sqlCommandType = SqlCommandType.UNKNOWN;
                this.databaseId = annotation2 instanceof Options ? ((Options)annotation2).databaseId() : (annotation2 instanceof SelectKey ? ((SelectKey)annotation2).databaseId() : "");
            }
        }

        Annotation getAnnotation() {
            return this.annotation;
        }

        SqlCommandType getSqlCommandType() {
            return this.sqlCommandType;
        }

        String getDatabaseId() {
            return this.databaseId;
        }
    }
}

