/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.binding;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.binding.MapperProxyFactory;
import org.apache.ibatis.builder.annotation.MapperAnnotationBuilder;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

public class MapperRegistry {
    private final Configuration config;
    private final Map<Class<?>, MapperProxyFactory<?>> knownMappers = new HashMap();

    public MapperRegistry(Configuration config2) {
        this.config = config2;
    }

    public <T> T getMapper(Class<T> type2, SqlSession sqlSession) {
        MapperProxyFactory<?> mapperProxyFactory = this.knownMappers.get(type2);
        if (mapperProxyFactory == null) {
            throw new BindingException("Type " + type2 + " is not known to the MapperRegistry.");
        }
        try {
            return (T)mapperProxyFactory.newInstance(sqlSession);
        }
        catch (Exception e) {
            throw new BindingException("Error getting mapper instance. Cause: " + e, e);
        }
    }

    public <T> boolean hasMapper(Class<T> type2) {
        return this.knownMappers.containsKey(type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addMapper(Class<T> type2) {
        if (type2.isInterface()) {
            if (this.hasMapper(type2)) {
                throw new BindingException("Type " + type2 + " is already known to the MapperRegistry.");
            }
            boolean loadCompleted = false;
            try {
                this.knownMappers.put(type2, new MapperProxyFactory<T>(type2));
                MapperAnnotationBuilder parser = new MapperAnnotationBuilder(this.config, type2);
                parser.parse();
                loadCompleted = true;
            }
            finally {
                if (!loadCompleted) {
                    this.knownMappers.remove(type2);
                }
            }
        }
    }

    public Collection<Class<?>> getMappers() {
        return Collections.unmodifiableCollection(this.knownMappers.keySet());
    }

    public void addMappers(String packageName, Class<?> superType) {
        ResolverUtil resolverUtil = new ResolverUtil();
        resolverUtil.find(new ResolverUtil.IsA(superType), packageName);
        Set mapperSet = resolverUtil.getClasses();
        for (Class mapperClass : mapperSet) {
            this.addMapper(mapperClass);
        }
    }

    public void addMappers(String packageName) {
        this.addMappers(packageName, Object.class);
    }
}

