/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.unicode;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.RangeValueIterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.antlr.v4.runtime.misc.IntervalSet;

public abstract class UnicodeDataTemplateController {
    private static void addIntervalForCategory(Map<String, IntervalSet> categoryMap, String categoryName, int start2, int finish) {
        IntervalSet intervalSet = categoryMap.get(categoryName);
        if (intervalSet == null) {
            intervalSet = new IntervalSet(new int[0]);
            categoryMap.put(categoryName, intervalSet);
        }
        intervalSet.add(start2, finish);
    }

    private static void addPropertyAliases(Map<String, String> propertyAliases, String propertyName, int property2) {
        int nameChoice = 1;
        while (true) {
            String alias;
            try {
                alias = UCharacter.getPropertyName(property2, nameChoice);
            }
            catch (IllegalArgumentException e) {
                break;
            }
            assert (alias != null);
            UnicodeDataTemplateController.addPropertyAlias(propertyAliases, alias, propertyName);
            ++nameChoice;
        }
    }

    private static void addPropertyAlias(Map<String, String> propertyAliases, String alias, String propertyName) {
        propertyAliases.put(alias, propertyName);
    }

    public static Map<String, Object> getProperties() {
        LinkedHashMap<String, IntervalSet> propertyCodePointRanges = new LinkedHashMap<String, IntervalSet>();
        UnicodeDataTemplateController.addUnicodeCategoryCodesToCodePointRanges(propertyCodePointRanges);
        UnicodeDataTemplateController.addUnicodeBinaryPropertyCodesToCodePointRanges(propertyCodePointRanges);
        UnicodeDataTemplateController.addUnicodeIntPropertyCodesToCodePointRanges(propertyCodePointRanges);
        UnicodeDataTemplateController.addTR35ExtendedPictographicPropertyCodesToCodePointRanges(propertyCodePointRanges);
        UnicodeDataTemplateController.addEmojiPresentationPropertyCodesToCodePointRanges(propertyCodePointRanges);
        LinkedHashMap<String, String> propertyAliases = new LinkedHashMap<String, String>();
        UnicodeDataTemplateController.addUnicodeCategoryCodesToNames(propertyAliases);
        UnicodeDataTemplateController.addUnicodeBinaryPropertyCodesToNames(propertyAliases);
        UnicodeDataTemplateController.addUnicodeScriptCodesToNames(propertyAliases);
        UnicodeDataTemplateController.addUnicodeBlocksToNames(propertyAliases);
        UnicodeDataTemplateController.addUnicodeIntPropertyCodesToNames(propertyAliases);
        propertyAliases.put("EP", "Extended_Pictographic");
        LinkedHashMap<String, Object> properties2 = new LinkedHashMap<String, Object>();
        properties2.put("propertyCodePointRanges", propertyCodePointRanges);
        properties2.put("propertyAliases", propertyAliases);
        return properties2;
    }

    private static String getShortPropertyName(int property2) {
        String propertyName = UCharacter.getPropertyName(property2, 0);
        if (propertyName == null) {
            propertyName = UCharacter.getPropertyName(property2, 1);
        }
        return propertyName;
    }

    private static void addUnicodeCategoryCodesToCodePointRanges(Map<String, IntervalSet> propertyCodePointRanges) {
        RangeValueIterator iter = UCharacter.getTypeIterator();
        RangeValueIterator.Element element = new RangeValueIterator.Element();
        while (iter.next(element)) {
            String categoryName = UCharacter.getPropertyValueName(8192, 1 << element.value, 0);
            UnicodeDataTemplateController.addIntervalForCategory(propertyCodePointRanges, categoryName, element.start, element.limit - 1);
            String shortCategoryName = categoryName.substring(0, 1);
            UnicodeDataTemplateController.addIntervalForCategory(propertyCodePointRanges, shortCategoryName, element.start, element.limit - 1);
        }
    }

    private static void addUnicodeCategoryCodesToNames(Map<String, String> propertyAliases) {
        RangeValueIterator iter = UCharacter.getTypeIterator();
        RangeValueIterator.Element element = new RangeValueIterator.Element();
        block2: while (iter.next(element)) {
            int generalCategoryMask = 1 << element.value;
            String categoryName = UCharacter.getPropertyValueName(8192, generalCategoryMask, 0);
            int nameChoice = 1;
            while (true) {
                String alias;
                try {
                    alias = UCharacter.getPropertyValueName(8192, generalCategoryMask, nameChoice);
                }
                catch (IllegalArgumentException e) {
                    continue block2;
                }
                assert (alias != null);
                UnicodeDataTemplateController.addPropertyAlias(propertyAliases, alias, categoryName);
                ++nameChoice;
            }
        }
        UnicodeDataTemplateController.addPropertyAlias(propertyAliases, "Control", "C");
        UnicodeDataTemplateController.addPropertyAlias(propertyAliases, "Letter", "L");
        UnicodeDataTemplateController.addPropertyAlias(propertyAliases, "Number", "N");
        UnicodeDataTemplateController.addPropertyAlias(propertyAliases, "Mark", "M");
        UnicodeDataTemplateController.addPropertyAlias(propertyAliases, "Punctuation", "P");
        UnicodeDataTemplateController.addPropertyAlias(propertyAliases, "Symbol", "S");
        UnicodeDataTemplateController.addPropertyAlias(propertyAliases, "Space", "Z");
    }

    private static void addUnicodeBinaryPropertyCodesToCodePointRanges(Map<String, IntervalSet> propertyCodePointRanges) {
        for (int property2 = 0; property2 < 72; ++property2) {
            String propertyName = UnicodeDataTemplateController.getShortPropertyName(property2);
            IntervalSet intervalSet = new IntervalSet(new int[0]);
            UnicodeSet unicodeSet = new UnicodeSet();
            unicodeSet.applyIntPropertyValue(property2, 1);
            for (UnicodeSet.EntryRange range : unicodeSet.ranges()) {
                intervalSet.add(range.codepoint, range.codepointEnd);
            }
            propertyCodePointRanges.put(propertyName, intervalSet);
        }
    }

    private static void addUnicodeBinaryPropertyCodesToNames(Map<String, String> propertyAliases) {
        for (int property2 = 0; property2 < 72; ++property2) {
            String propertyName = UnicodeDataTemplateController.getShortPropertyName(property2);
            UnicodeDataTemplateController.addPropertyAliases(propertyAliases, propertyName, property2);
        }
    }

    private static void addIntPropertyRanges(int property2, String namePrefix, Map<String, IntervalSet> propertyCodePointRanges) {
        for (int propertyValue = UCharacter.getIntPropertyMinValue(property2); propertyValue <= UCharacter.getIntPropertyMaxValue(property2); ++propertyValue) {
            UnicodeSet set2 = new UnicodeSet();
            set2.applyIntPropertyValue(property2, propertyValue);
            String propertyName = namePrefix + UCharacter.getPropertyValueName(property2, propertyValue, 0);
            IntervalSet intervalSet = propertyCodePointRanges.get(propertyName);
            if (intervalSet == null) {
                intervalSet = new IntervalSet(new int[0]);
                propertyCodePointRanges.put(propertyName, intervalSet);
            }
            UnicodeDataTemplateController.addUnicodeSetToIntervalSet(set2, intervalSet);
        }
    }

    private static void addUnicodeSetToIntervalSet(UnicodeSet unicodeSet, IntervalSet intervalSet) {
        for (UnicodeSet.EntryRange range : unicodeSet.ranges()) {
            intervalSet.add(range.codepoint, range.codepointEnd);
        }
    }

    private static void addUnicodeIntPropertyCodesToCodePointRanges(Map<String, IntervalSet> propertyCodePointRanges) {
        for (int property2 = 4096; property2 < 4121; ++property2) {
            String propertyName = UnicodeDataTemplateController.getShortPropertyName(property2);
            UnicodeDataTemplateController.addIntPropertyRanges(property2, propertyName + "=", propertyCodePointRanges);
        }
    }

    private static void addTR35ExtendedPictographicPropertyCodesToCodePointRanges(Map<String, IntervalSet> propertyCodePointRanges) {
        IntervalSet set2 = new IntervalSet(new int[0]);
        set2.add(128884, 128895);
        set2.add(9984, 9985);
        set2.add(9987, 9988);
        set2.add(9998);
        set2.add(10000, 10001);
        set2.add(10085, 10087);
        set2.add(127024, 127123);
        set2.add(127124, 127135);
        set2.add(127245, 127247);
        set2.add(127279);
        set2.add(127340, 127343);
        set2.add(127405, 127461);
        set2.add(127584, 127589);
        set2.add(127491, 127503);
        set2.add(127548, 127551);
        set2.add(127561, 127567);
        set2.add(127570, 127583);
        set2.add(127590, 127743);
        set2.add(128981, 129023);
        set2.add(126976, 126979);
        set2.add(126981, 127019);
        set2.add(127020, 127023);
        set2.add(127778, 127779);
        set2.add(127892, 127893);
        set2.add(127896);
        set2.add(127900, 127901);
        set2.add(127985, 127986);
        set2.add(127990);
        set2.add(128254);
        set2.add(128318, 128328);
        set2.add(128335);
        set2.add(128360, 128366);
        set2.add(128369, 128370);
        set2.add(128379, 128390);
        set2.add(128392, 128393);
        set2.add(128398, 128399);
        set2.add(128401, 128404);
        set2.add(128407, 128419);
        set2.add(128422, 128423);
        set2.add(128425, 128432);
        set2.add(128435, 128443);
        set2.add(128445, 128449);
        set2.add(128453, 128464);
        set2.add(128468, 128475);
        set2.add(128479, 128480);
        set2.add(128482);
        set2.add(128484, 128487);
        set2.add(128489, 128494);
        set2.add(128496, 128498);
        set2.add(128500, 128505);
        set2.add(9733);
        set2.add(9735, 9741);
        set2.add(9743, 9744);
        set2.add(9746);
        set2.add(9750, 9751);
        set2.add(9753, 9756);
        set2.add(9758, 9759);
        set2.add(9761);
        set2.add(9764, 9765);
        set2.add(9767, 9769);
        set2.add(9771, 9773);
        set2.add(9776, 9783);
        set2.add(9787, 9799);
        set2.add(9812, 9823);
        set2.add(9825, 9826);
        set2.add(9828);
        set2.add(9831);
        set2.add(9833, 9850);
        set2.add(9852, 9854);
        set2.add(9856, 9873);
        set2.add(9877);
        set2.add(9880);
        set2.add(9882);
        set2.add(9885, 9887);
        set2.add(9890, 9897);
        set2.add(9900, 9903);
        set2.add(9906, 9916);
        set2.add(9919, 9923);
        set2.add(9926, 9927);
        set2.add(9929, 9933);
        set2.add(9936);
        set2.add(9938);
        set2.add(9941, 9960);
        set2.add(9963, 9967);
        set2.add(9974);
        set2.add(9979, 9980);
        set2.add(9982, 9983);
        set2.add(9096);
        set2.add(129536, 131069);
        set2.add(127136, 127150);
        set2.add(127153, 127167);
        set2.add(127169, 127183);
        set2.add(127185, 127221);
        set2.add(127151, 127152);
        set2.add(127168);
        set2.add(127184);
        set2.add(127222, 127231);
        set2.add(129036, 129039);
        set2.add(129096, 129103);
        set2.add(129114, 129119);
        set2.add(129160, 129167);
        set2.add(129198, 129279);
        set2.add(129280, 129291);
        set2.add(129311);
        set2.add(129320, 129327);
        set2.add(129329, 129330);
        set2.add(129356);
        set2.add(129375, 129387);
        set2.add(129426, 129431);
        set2.add(129488, 129510);
        set2.add(129292, 129295);
        set2.add(129343);
        set2.add(129357, 129359);
        set2.add(129388, 129407);
        set2.add(129432, 129471);
        set2.add(129473, 129487);
        set2.add(129511, 129535);
        set2.add(128710, 128714);
        set2.add(128723, 128724);
        set2.add(128742, 128744);
        set2.add(128746);
        set2.add(128753, 128754);
        set2.add(128759, 128760);
        set2.add(128725, 128735);
        set2.add(128749, 128751);
        set2.add(128761, 128767);
        propertyCodePointRanges.put("Extended_Pictographic", set2);
        UnicodeSet emojiRKUnicodeSet = new UnicodeSet("[\\p{GCB=Regional_Indicator}\\*#0-9\\u00a9\\u00ae\\u2122\\u3030\\u303d]");
        IntervalSet emojiRKIntervalSet = new IntervalSet(new int[0]);
        UnicodeDataTemplateController.addUnicodeSetToIntervalSet(emojiRKUnicodeSet, emojiRKIntervalSet);
        propertyCodePointRanges.put("EmojiRK", emojiRKIntervalSet);
        UnicodeSet emojiNRKUnicodeSet = new UnicodeSet("[\\p{Emoji=Yes}]");
        emojiNRKUnicodeSet.removeAll(emojiRKUnicodeSet);
        IntervalSet emojiNRKIntervalSet = new IntervalSet(new int[0]);
        UnicodeDataTemplateController.addUnicodeSetToIntervalSet(emojiNRKUnicodeSet, emojiNRKIntervalSet);
        propertyCodePointRanges.put("EmojiNRK", emojiNRKIntervalSet);
    }

    private static void addEmojiPresentationPropertyCodesToCodePointRanges(Map<String, IntervalSet> propertyCodePointRanges) {
        UnicodeSet emojiDefaultUnicodeSet = new UnicodeSet("[[\\p{Emoji=Yes}]&[\\p{Emoji_Presentation=Yes}]]");
        IntervalSet emojiDefaultIntervalSet = new IntervalSet(new int[0]);
        UnicodeDataTemplateController.addUnicodeSetToIntervalSet(emojiDefaultUnicodeSet, emojiDefaultIntervalSet);
        propertyCodePointRanges.put("EmojiPresentation=EmojiDefault", emojiDefaultIntervalSet);
        UnicodeSet textDefaultUnicodeSet = new UnicodeSet("[[\\p{Emoji=Yes}]&[\\p{Emoji_Presentation=No}]]");
        IntervalSet textDefaultIntervalSet = new IntervalSet(new int[0]);
        UnicodeDataTemplateController.addUnicodeSetToIntervalSet(textDefaultUnicodeSet, textDefaultIntervalSet);
        propertyCodePointRanges.put("EmojiPresentation=TextDefault", textDefaultIntervalSet);
        UnicodeSet textUnicodeSet = new UnicodeSet("[\\p{Emoji=No}]");
        IntervalSet textIntervalSet = new IntervalSet(new int[0]);
        UnicodeDataTemplateController.addUnicodeSetToIntervalSet(textUnicodeSet, textIntervalSet);
        propertyCodePointRanges.put("EmojiPresentation=Text", textIntervalSet);
    }

    private static void addIntPropertyAliases(int property2, String namePrefix, Map<String, String> propertyAliases) {
        String propertyName = UnicodeDataTemplateController.getShortPropertyName(property2);
        block2: for (int propertyValue = UCharacter.getIntPropertyMinValue(property2); propertyValue <= UCharacter.getIntPropertyMaxValue(property2); ++propertyValue) {
            String aliasTarget = propertyName + "=" + UCharacter.getPropertyValueName(property2, propertyValue, 0);
            int nameChoice = 0;
            while (true) {
                String alias;
                try {
                    alias = namePrefix + UCharacter.getPropertyValueName(property2, propertyValue, nameChoice);
                }
                catch (IllegalArgumentException e) {
                    continue block2;
                }
                assert (alias != null);
                UnicodeDataTemplateController.addPropertyAlias(propertyAliases, alias, aliasTarget);
                ++nameChoice;
            }
        }
    }

    private static void addUnicodeScriptCodesToNames(Map<String, String> propertyAliases) {
        UnicodeDataTemplateController.addIntPropertyAliases(4106, "", propertyAliases);
    }

    private static void addUnicodeBlocksToNames(Map<String, String> propertyAliases) {
        UnicodeDataTemplateController.addIntPropertyAliases(4097, "In", propertyAliases);
    }

    private static void addUnicodeIntPropertyCodesToNames(Map<String, String> propertyAliases) {
        block2: for (int property2 = 4096; property2 < 4121; ++property2) {
            int nameChoice = 1;
            while (true) {
                String propertyNameAlias;
                try {
                    propertyNameAlias = UCharacter.getPropertyName(property2, nameChoice);
                }
                catch (IllegalArgumentException e) {
                    continue block2;
                }
                UnicodeDataTemplateController.addIntPropertyAliases(property2, propertyNameAlias + "=", propertyAliases);
                ++nameChoice;
            }
        }
    }
}

