/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.tool;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.v4.Tool;
import org.antlr.v4.tool.ANTLRMessage;
import org.antlr.v4.tool.ErrorSeverity;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.GrammarSemanticsMessage;
import org.antlr.v4.tool.GrammarSyntaxMessage;
import org.antlr.v4.tool.LeftRecursionCyclesMessage;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ToolMessage;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.misc.ErrorBuffer;

public class ErrorManager {
    private static final Map<String, STGroupFile> loadedFormats = new HashMap<String, STGroupFile>();
    public static final String FORMATS_DIR = "org/antlr/v4/tool/templates/messages/formats/";
    public Tool tool;
    public int errors;
    public int warnings;
    public Set<ErrorType> errorTypes = EnumSet.noneOf(ErrorType.class);
    STGroup format;
    String formatName;
    ErrorBuffer initSTListener = new ErrorBuffer();

    public ErrorManager(Tool tool) {
        this.tool = tool;
    }

    public void resetErrorState() {
        this.errors = 0;
        this.warnings = 0;
    }

    public ST getMessageTemplate(ANTLRMessage msg) {
        ST messageST = msg.getMessageTemplate(this.tool.longMessages);
        ST locationST = this.getLocationFormat();
        ST reportST = this.getReportFormat(msg.getErrorType().severity);
        ST messageFormatST = this.getMessageFormat();
        boolean locationValid = false;
        if (msg.line != -1) {
            locationST.add("line", msg.line);
            locationValid = true;
        }
        if (msg.charPosition != -1) {
            locationST.add("column", msg.charPosition);
            locationValid = true;
        }
        if (msg.fileName != null) {
            File f;
            String displayFileName = msg.fileName;
            if (this.formatName.equals("antlr") && (f = new File(msg.fileName)).exists()) {
                displayFileName = f.getName();
            }
            locationST.add("file", displayFileName);
            locationValid = true;
        }
        messageFormatST.add("id", msg.getErrorType().code);
        messageFormatST.add("text", messageST);
        if (locationValid) {
            reportST.add("location", locationST);
        }
        reportST.add("message", messageFormatST);
        return reportST;
    }

    public ST getLocationFormat() {
        return this.format.getInstanceOf("location");
    }

    public ST getReportFormat(ErrorSeverity severity) {
        ST st = this.format.getInstanceOf("report");
        st.add("type", severity.getText());
        return st;
    }

    public ST getMessageFormat() {
        return this.format.getInstanceOf("message");
    }

    public boolean formatWantsSingleLineMessage() {
        return this.format.getInstanceOf("wantsSingleLineMessage").render().equals("true");
    }

    public void info(String msg) {
        this.tool.info(msg);
    }

    public void syntaxError(ErrorType etype, String fileName, Token token2, RecognitionException antlrException, Object ... args2) {
        GrammarSyntaxMessage msg = new GrammarSyntaxMessage(etype, fileName, token2, antlrException, args2);
        this.emit(etype, msg);
    }

    public static void fatalInternalError(String error, Throwable e) {
        ErrorManager.internalError(error, e);
        throw new RuntimeException(error, e);
    }

    public static void internalError(String error, Throwable e) {
        StackTraceElement location = ErrorManager.getLastNonErrorManagerCodeLocation(e);
        ErrorManager.internalError("Exception " + e + "@" + location + ": " + error);
    }

    public static void internalError(String error) {
        StackTraceElement location = ErrorManager.getLastNonErrorManagerCodeLocation(new Exception());
        String msg = location + ": " + error;
        System.err.println("internal error: " + msg);
    }

    public void toolError(ErrorType errorType, Object ... args2) {
        this.toolError(errorType, null, args2);
    }

    public void toolError(ErrorType errorType, Throwable e, Object ... args2) {
        ToolMessage msg = new ToolMessage(errorType, e, args2);
        this.emit(errorType, msg);
    }

    public void grammarError(ErrorType etype, String fileName, Token token2, Object ... args2) {
        GrammarSemanticsMessage msg = new GrammarSemanticsMessage(etype, fileName, token2, args2);
        this.emit(etype, msg);
    }

    public void leftRecursionCycles(String fileName, Collection<? extends Collection<Rule>> cycles) {
        ++this.errors;
        LeftRecursionCyclesMessage msg = new LeftRecursionCyclesMessage(fileName, cycles);
        this.tool.error(msg);
    }

    public int getNumErrors() {
        return this.errors;
    }

    private static StackTraceElement getLastNonErrorManagerCodeLocation(Throwable e) {
        StackTraceElement t;
        int i;
        StackTraceElement[] stack = e.getStackTrace();
        for (i = 0; i < stack.length && (t = stack[i]).toString().contains("ErrorManager"); ++i) {
        }
        StackTraceElement location = stack[i];
        return location;
    }

    public void emit(ErrorType etype, ANTLRMessage msg) {
        switch (etype.severity) {
            case WARNING_ONE_OFF: {
                if (this.errorTypes.contains((Object)etype)) break;
            }
            case WARNING: {
                ++this.warnings;
                this.tool.warning(msg);
                break;
            }
            case ERROR_ONE_OFF: {
                if (this.errorTypes.contains((Object)etype)) break;
            }
            case ERROR: {
                ++this.errors;
                this.tool.error(msg);
                break;
            }
        }
        this.errorTypes.add(etype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormat(String formatName) {
        boolean formatOK;
        STGroupFile loadedFormat;
        Map<String, STGroupFile> map2 = loadedFormats;
        synchronized (map2) {
            loadedFormat = loadedFormats.get(formatName);
            if (loadedFormat == null) {
                String fileName = FORMATS_DIR + formatName + STGroup.GROUP_FILE_EXTENSION;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                URL url2 = cl.getResource(fileName);
                if (url2 == null) {
                    cl = ErrorManager.class.getClassLoader();
                    url2 = cl.getResource(fileName);
                }
                if (url2 == null && formatName.equals("antlr")) {
                    ErrorManager.rawError("ANTLR installation corrupted; cannot find ANTLR messages format file " + fileName);
                    ErrorManager.panic();
                } else if (url2 == null) {
                    ErrorManager.rawError("no such message format file " + fileName + " retrying with default ANTLR format");
                    this.setFormat("antlr");
                    return;
                }
                loadedFormat = new STGroupFile(url2, "UTF-8", '<', '>');
                loadedFormat.load();
                loadedFormats.put(formatName, loadedFormat);
            }
        }
        this.formatName = formatName;
        this.format = loadedFormat;
        if (!this.initSTListener.errors.isEmpty()) {
            ErrorManager.rawError("ANTLR installation corrupted; can't load messages format file:\n" + this.initSTListener.toString());
            ErrorManager.panic();
        }
        if (!(formatOK = this.verifyFormat()) && formatName.equals("antlr")) {
            ErrorManager.rawError("ANTLR installation corrupted; ANTLR messages format file " + formatName + ".stg incomplete");
            ErrorManager.panic();
        } else if (!formatOK) {
            this.setFormat("antlr");
        }
    }

    protected boolean verifyFormat() {
        boolean ok = true;
        if (!this.format.isDefined("location")) {
            System.err.println("Format template 'location' not found in " + this.formatName);
            ok = false;
        }
        if (!this.format.isDefined("message")) {
            System.err.println("Format template 'message' not found in " + this.formatName);
            ok = false;
        }
        if (!this.format.isDefined("report")) {
            System.err.println("Format template 'report' not found in " + this.formatName);
            ok = false;
        }
        return ok;
    }

    static void rawError(String msg) {
        System.err.println(msg);
    }

    static void rawError(String msg, Throwable e) {
        ErrorManager.rawError(msg);
        e.printStackTrace(System.err);
    }

    public void panic(ErrorType errorType, Object ... args2) {
        ToolMessage msg = new ToolMessage(errorType, args2);
        ST msgST = this.getMessageTemplate(msg);
        String outputMsg = msgST.render();
        if (this.formatWantsSingleLineMessage()) {
            outputMsg = outputMsg.replace('\n', ' ');
        }
        ErrorManager.panic(outputMsg);
    }

    public static void panic(String msg) {
        ErrorManager.rawError(msg);
        ErrorManager.panic();
    }

    public static void panic() {
        throw new Error("ANTLR ErrorManager panic");
    }
}

