/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.semantics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.parse.GrammarTreeVisitor;
import org.antlr.v4.semantics.RuleCollector;
import org.antlr.v4.tool.ErrorManager;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.ActionAST;
import org.antlr.v4.tool.ast.AltAST;
import org.antlr.v4.tool.ast.BlockAST;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.GrammarASTWithOptions;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.antlr.v4.tool.ast.RuleAST;
import org.antlr.v4.tool.ast.RuleRefAST;
import org.antlr.v4.tool.ast.TerminalAST;
import org.stringtemplate.v4.misc.MultiMap;

public class BasicSemanticChecks
extends GrammarTreeVisitor {
    public static final MultiMap<Integer, Integer> validImportTypes = new MultiMap<Integer, Integer>(){
        {
            this.map(31, 31);
            this.map(31, 72);
            this.map(44, 44);
            this.map(44, 72);
            this.map(72, 72);
        }
    };
    public Grammar g;
    public RuleCollector ruleCollector;
    public ErrorManager errMgr;
    public boolean checkAssocElementOption = true;
    protected int nonFragmentRuleCount;
    private boolean inFragmentRule;
    private boolean grammarCaseInsensitive = false;

    public BasicSemanticChecks(Grammar g, RuleCollector ruleCollector) {
        this.g = g;
        this.ruleCollector = ruleCollector;
        this.errMgr = g.tool.errMgr;
    }

    @Override
    public ErrorManager getErrorManager() {
        return this.errMgr;
    }

    public void process() {
        this.visitGrammar(this.g.ast);
    }

    @Override
    public void discoverGrammar(GrammarRootAST root, GrammarAST ID2) {
        this.checkGrammarName(ID2.token);
    }

    @Override
    public void finishPrequels(GrammarAST firstPrequel) {
        if (firstPrequel == null) {
            return;
        }
        GrammarAST parent = (GrammarAST)firstPrequel.parent;
        List<GrammarAST> options2 = parent.getAllChildrenWithType(42);
        List<GrammarAST> imports = parent.getAllChildrenWithType(29);
        List<GrammarAST> tokens = parent.getAllChildrenWithType(61);
        this.checkNumPrequels(options2, imports, tokens);
    }

    @Override
    public void importGrammar(GrammarAST label, GrammarAST ID2) {
        this.checkImport(ID2.token);
    }

    @Override
    public void discoverRules(GrammarAST rules) {
        this.checkNumRules(rules);
    }

    @Override
    protected void enterMode(GrammarAST tree) {
        this.nonFragmentRuleCount = 0;
    }

    @Override
    protected void exitMode(GrammarAST tree) {
        if (this.nonFragmentRuleCount == 0) {
            Token token2 = tree.getToken();
            String name = "?";
            if (tree.getChildCount() > 0) {
                name = tree.getChild(0).getText();
                if (name == null || name.isEmpty()) {
                    name = "?";
                }
                token2 = ((GrammarAST)tree.getChild(0)).getToken();
            }
            this.g.tool.errMgr.grammarError(ErrorType.MODE_WITHOUT_RULES, this.g.fileName, token2, name, this.g);
        }
    }

    @Override
    public void modeDef(GrammarAST m, GrammarAST ID2) {
        if (!this.g.isLexer()) {
            this.g.tool.errMgr.grammarError(ErrorType.MODE_NOT_IN_LEXER, this.g.fileName, ID2.token, ID2.token.getText(), this.g);
        }
    }

    @Override
    public void discoverRule(RuleAST rule, GrammarAST ID2, List<GrammarAST> modifiers, ActionAST arg, ActionAST returns, GrammarAST thrws, GrammarAST options2, ActionAST locals, List<GrammarAST> actions, GrammarAST block2) {
        this.checkInvalidRuleDef(ID2.token);
    }

    @Override
    public void discoverLexerRule(RuleAST rule, GrammarAST ID2, List<GrammarAST> modifiers, GrammarAST options2, GrammarAST block2) {
        this.checkInvalidRuleDef(ID2.token);
        if (modifiers != null) {
            for (GrammarAST tree : modifiers) {
                if (tree.getType() != 24) continue;
                this.inFragmentRule = true;
            }
        }
        if (!this.inFragmentRule) {
            ++this.nonFragmentRuleCount;
        }
    }

    @Override
    protected void exitLexerRule(GrammarAST tree) {
        this.inFragmentRule = false;
    }

    @Override
    public void ruleRef(GrammarAST ref, ActionAST arg) {
        this.checkInvalidRuleRef(ref.token);
    }

    @Override
    public void grammarOption(GrammarAST ID2, GrammarAST valueAST) {
        this.checkOptions(this.g.ast, ID2.token, valueAST);
    }

    @Override
    public void ruleOption(GrammarAST ID2, GrammarAST valueAST) {
        this.checkOptions((GrammarAST)ID2.getAncestor(79), ID2.token, valueAST);
    }

    @Override
    public void blockOption(GrammarAST ID2, GrammarAST valueAST) {
        this.checkOptions((GrammarAST)ID2.getAncestor(70), ID2.token, valueAST);
    }

    @Override
    public void defineToken(GrammarAST ID2) {
        this.checkTokenDefinition(ID2.token);
    }

    @Override
    protected void enterChannelsSpec(GrammarAST tree) {
        ErrorType errorType;
        ErrorType errorType2 = this.g.isParser() ? ErrorType.CHANNELS_BLOCK_IN_PARSER_GRAMMAR : (errorType = this.g.isCombined() ? ErrorType.CHANNELS_BLOCK_IN_COMBINED_GRAMMAR : null);
        if (errorType != null) {
            this.g.tool.errMgr.grammarError(errorType, this.g.fileName, tree.token, new Object[0]);
        }
    }

    @Override
    public void defineChannel(GrammarAST ID2) {
        this.checkChannelDefinition(ID2.token);
    }

    @Override
    public void elementOption(GrammarASTWithOptions elem, GrammarAST ID2, GrammarAST valueAST) {
        this.checkElementOptions(elem, ID2, valueAST);
    }

    @Override
    public void finishRule(RuleAST rule, GrammarAST ID2, GrammarAST block2) {
        if (rule.isLexerRule()) {
            return;
        }
        BlockAST blk = (BlockAST)rule.getFirstChildWithType(70);
        int nalts = blk.getChildCount();
        GrammarAST idAST = (GrammarAST)rule.getChild(0);
        for (int i = 0; i < nalts; ++i) {
            String prevRuleForLabel;
            AltAST altAST = (AltAST)blk.getChild(i);
            if (altAST.altLabel == null) continue;
            String altLabel = altAST.altLabel.getText();
            Rule r = (Rule)this.ruleCollector.rules.get(Utils.decapitalize(altLabel));
            if (r != null) {
                this.g.tool.errMgr.grammarError(ErrorType.ALT_LABEL_CONFLICTS_WITH_RULE, this.g.fileName, altAST.altLabel.token, altLabel, r.name);
            }
            if ((prevRuleForLabel = this.ruleCollector.altLabelToRuleName.get(altLabel)) == null || prevRuleForLabel.equals(rule.getRuleName())) continue;
            this.g.tool.errMgr.grammarError(ErrorType.ALT_LABEL_REDEF, this.g.fileName, altAST.altLabel.token, altLabel, rule.getRuleName(), prevRuleForLabel);
        }
        List altLabels = (List)this.ruleCollector.ruleToAltLabels.get(rule.getRuleName());
        int numAltLabels = 0;
        if (altLabels != null) {
            numAltLabels = altLabels.size();
        }
        if (numAltLabels > 0 && nalts != numAltLabels) {
            this.g.tool.errMgr.grammarError(ErrorType.RULE_WITH_TOO_FEW_ALT_LABELS, this.g.fileName, idAST.token, rule.getRuleName());
        }
    }

    void checkGrammarName(Token nameToken) {
        String fullyQualifiedName = nameToken.getInputStream().getSourceName();
        if (fullyQualifiedName == null) {
            return;
        }
        File f = new File(fullyQualifiedName);
        String fileName = f.getName();
        if (this.g.originalGrammar != null) {
            return;
        }
        if (!Utils.stripFileExtension(fileName).equals(nameToken.getText()) && !fileName.equals("<string>")) {
            this.g.tool.errMgr.grammarError(ErrorType.FILE_AND_GRAMMAR_NAME_DIFFER, fileName, nameToken, nameToken.getText(), fileName);
        }
    }

    void checkNumRules(GrammarAST rulesNode) {
        if (rulesNode.getChildCount() == 0) {
            GrammarAST root = (GrammarAST)rulesNode.getParent();
            GrammarAST IDNode = (GrammarAST)root.getChild(0);
            this.g.tool.errMgr.grammarError(ErrorType.NO_RULES, this.g.fileName, null, IDNode.getText(), this.g);
        }
    }

    void checkNumPrequels(List<GrammarAST> options2, List<GrammarAST> imports, List<GrammarAST> tokens) {
        ArrayList<Token> secondOptionTokens = new ArrayList<Token>();
        if (options2 != null && options2.size() > 1) {
            secondOptionTokens.add(options2.get((int)1).token);
        }
        if (imports != null && imports.size() > 1) {
            secondOptionTokens.add(imports.get((int)1).token);
        }
        if (tokens != null && tokens.size() > 1) {
            secondOptionTokens.add(tokens.get((int)1).token);
        }
        for (Token t : secondOptionTokens) {
            String fileName = t.getInputStream().getSourceName();
            this.g.tool.errMgr.grammarError(ErrorType.REPEATED_PREQUEL, fileName, t, new Object[0]);
        }
    }

    void checkInvalidRuleDef(Token ruleID) {
        String fileName = null;
        if (ruleID.getInputStream() != null) {
            fileName = ruleID.getInputStream().getSourceName();
        }
        if (this.g.isLexer() && Character.isLowerCase(ruleID.getText().charAt(0))) {
            this.g.tool.errMgr.grammarError(ErrorType.PARSER_RULES_NOT_ALLOWED, fileName, ruleID, ruleID.getText());
        }
        if (this.g.isParser() && Grammar.isTokenName(ruleID.getText())) {
            this.g.tool.errMgr.grammarError(ErrorType.LEXER_RULES_NOT_ALLOWED, fileName, ruleID, ruleID.getText());
        }
    }

    void checkInvalidRuleRef(Token ruleID) {
        String fileName = ruleID.getInputStream().getSourceName();
        if (this.g.isLexer() && Character.isLowerCase(ruleID.getText().charAt(0))) {
            this.g.tool.errMgr.grammarError(ErrorType.PARSER_RULE_REF_IN_LEXER_RULE, fileName, ruleID, ruleID.getText(), this.currentRuleName);
        }
    }

    void checkTokenDefinition(Token tokenID) {
        String fileName = tokenID.getInputStream().getSourceName();
        if (!Grammar.isTokenName(tokenID.getText())) {
            this.g.tool.errMgr.grammarError(ErrorType.TOKEN_NAMES_MUST_START_UPPER, fileName, tokenID, tokenID.getText());
        }
    }

    void checkChannelDefinition(Token tokenID) {
    }

    @Override
    protected void enterLexerElement(GrammarAST tree) {
    }

    @Override
    protected void enterLexerCommand(GrammarAST tree) {
        this.checkElementIsOuterMostInSingleAlt(tree);
        if (this.inFragmentRule) {
            String fileName = tree.token.getInputStream().getSourceName();
            String ruleName = this.currentRuleName;
            this.g.tool.errMgr.grammarError(ErrorType.FRAGMENT_ACTION_IGNORED, fileName, tree.token, ruleName);
        }
    }

    @Override
    public void actionInAlt(ActionAST action) {
        if (this.inFragmentRule) {
            String fileName = action.token.getInputStream().getSourceName();
            String ruleName = this.currentRuleName;
            this.g.tool.errMgr.grammarError(ErrorType.FRAGMENT_ACTION_IGNORED, fileName, action.token, ruleName);
        }
    }

    protected void checkElementIsOuterMostInSingleAlt(GrammarAST tree) {
        CommonTree alt = tree.parent;
        CommonTree blk = alt.parent;
        boolean outerMostAlt = blk.parent.getType() == 79;
        Tree rule = tree.getAncestor(79);
        String fileName = tree.getToken().getInputStream().getSourceName();
        if (!outerMostAlt || blk.getChildCount() > 1) {
            ErrorType e = ErrorType.LEXER_COMMAND_PLACEMENT_ISSUE;
            this.g.tool.errMgr.grammarError(e, fileName, tree.getToken(), rule.getChild(0).getText());
        }
    }

    @Override
    public void label(GrammarAST op, GrammarAST ID2, GrammarAST element) {
        switch (element.getType()) {
            case 39: 
            case 49: 
            case 54: 
            case 59: 
            case 62: 
            case 82: 
            case 83: {
                return;
            }
        }
        String fileName = ID2.token.getInputStream().getSourceName();
        this.g.tool.errMgr.grammarError(ErrorType.LABEL_BLOCK_NOT_A_SET, fileName, ID2.token, ID2.getText());
    }

    @Override
    protected void enterTerminal(GrammarAST tree) {
        String text = tree.getText();
        if (text.equals("''")) {
            this.g.tool.errMgr.grammarError(ErrorType.EMPTY_STRINGS_AND_SETS_NOT_ALLOWED, this.g.fileName, tree.token, "''");
        }
    }

    void checkOptions(GrammarAST parent, Token optionID, GrammarAST valueAST) {
        Set<String> optionsToCheck = null;
        int parentType = parent.getType();
        switch (parentType) {
            case 70: {
                optionsToCheck = this.g.isLexer() ? Grammar.lexerBlockOptions : Grammar.parserBlockOptions;
                break;
            }
            case 79: {
                optionsToCheck = this.g.isLexer() ? Grammar.lexerRuleOptions : Grammar.parseRuleOptions;
                break;
            }
            case 25: {
                optionsToCheck = this.g.getType() == 31 ? Grammar.lexerOptions : Grammar.parserOptions;
            }
        }
        String optionName = optionID.getText();
        if (optionsToCheck != null && !optionsToCheck.contains(optionName)) {
            this.g.tool.errMgr.grammarError(ErrorType.ILLEGAL_OPTION, this.g.fileName, optionID, optionName);
        } else {
            this.checkCaseInsensitiveOption(optionID, valueAST, parentType);
        }
    }

    private void checkCaseInsensitiveOption(Token optionID, GrammarAST valueAST, int parentType) {
        String optionName = optionID.getText();
        if (optionName.equals("caseInsensitive")) {
            String valueText = valueAST.getText();
            if (valueText.equals("true") || valueText.equals("false")) {
                boolean currentValue = Boolean.parseBoolean(valueText);
                if (parentType == 25) {
                    this.grammarCaseInsensitive = currentValue;
                } else if (this.grammarCaseInsensitive == currentValue) {
                    this.g.tool.errMgr.grammarError(ErrorType.REDUNDANT_CASE_INSENSITIVE_LEXER_RULE_OPTION, this.g.fileName, optionID, currentValue);
                }
            } else {
                this.g.tool.errMgr.grammarError(ErrorType.ILLEGAL_OPTION_VALUE, this.g.fileName, valueAST.getToken(), optionName, valueText);
            }
        }
    }

    boolean checkElementOptions(GrammarASTWithOptions elem, GrammarAST ID2, GrammarAST valueAST) {
        String fileName;
        Token optionID;
        if (this.checkAssocElementOption && ID2 != null && "assoc".equals(ID2.getText()) && elem.getType() != 69) {
            optionID = ID2.token;
            fileName = optionID.getInputStream().getSourceName();
            this.g.tool.errMgr.grammarError(ErrorType.UNRECOGNIZED_ASSOC_OPTION, fileName, optionID, this.currentRuleName);
        }
        if (elem instanceof RuleRefAST) {
            return this.checkRuleRefOptions((RuleRefAST)elem, ID2, valueAST);
        }
        if (elem instanceof TerminalAST) {
            return this.checkTokenOptions((TerminalAST)elem, ID2, valueAST);
        }
        if (elem.getType() == 4) {
            return false;
        }
        if (elem.getType() == 56) {
            optionID = ID2.token;
            fileName = optionID.getInputStream().getSourceName();
            if (valueAST != null && !Grammar.semPredOptions.contains(optionID.getText())) {
                this.g.tool.errMgr.grammarError(ErrorType.ILLEGAL_OPTION, fileName, optionID, optionID.getText());
                return false;
            }
        }
        return false;
    }

    boolean checkRuleRefOptions(RuleRefAST elem, GrammarAST ID2, GrammarAST valueAST) {
        Token optionID = ID2.token;
        String fileName = optionID.getInputStream().getSourceName();
        if (valueAST != null && !Grammar.ruleRefOptions.contains(optionID.getText())) {
            this.g.tool.errMgr.grammarError(ErrorType.ILLEGAL_OPTION, fileName, optionID, optionID.getText());
            return false;
        }
        return true;
    }

    boolean checkTokenOptions(TerminalAST elem, GrammarAST ID2, GrammarAST valueAST) {
        Token optionID = ID2.token;
        String fileName = optionID.getInputStream().getSourceName();
        if (valueAST != null && !Grammar.tokenOptions.contains(optionID.getText())) {
            this.g.tool.errMgr.grammarError(ErrorType.ILLEGAL_OPTION, fileName, optionID, optionID.getText());
            return false;
        }
        return true;
    }

    void checkImport(Token importID) {
        Grammar delegate2 = this.g.getImportedGrammar(importID.getText());
        if (delegate2 == null) {
            return;
        }
        List validDelegators = (List)validImportTypes.get(delegate2.getType());
        if (validDelegators != null && !validDelegators.contains(this.g.getType())) {
            this.g.tool.errMgr.grammarError(ErrorType.INVALID_IMPORT, this.g.fileName, importID, this.g, delegate2);
        }
        if (this.g.isCombined() && (delegate2.name.equals(this.g.name + Grammar.getGrammarTypeToFileNameSuffix(31)) || delegate2.name.equals(this.g.name + Grammar.getGrammarTypeToFileNameSuffix(44)))) {
            this.g.tool.errMgr.grammarError(ErrorType.IMPORT_NAME_CLASH, this.g.fileName, importID, this.g, delegate2);
        }
    }
}

