/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.v4.codegen.OutputModelFactory;
import org.antlr.v4.codegen.model.Action;
import org.antlr.v4.codegen.model.CodeBlockForOuterMostAlt;
import org.antlr.v4.codegen.model.ElementFrequenciesVisitor;
import org.antlr.v4.codegen.model.ExceptionClause;
import org.antlr.v4.codegen.model.ModelElement;
import org.antlr.v4.codegen.model.OutputModelObject;
import org.antlr.v4.codegen.model.SrcOp;
import org.antlr.v4.codegen.model.decl.AltLabelStructDecl;
import org.antlr.v4.codegen.model.decl.AttributeDecl;
import org.antlr.v4.codegen.model.decl.ContextRuleGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextRuleListGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextRuleListIndexedGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextTokenGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextTokenListGetterDecl;
import org.antlr.v4.codegen.model.decl.ContextTokenListIndexedGetterDecl;
import org.antlr.v4.codegen.model.decl.Decl;
import org.antlr.v4.codegen.model.decl.StructDecl;
import org.antlr.v4.misc.FrequencySet;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.parse.GrammarASTAdaptor;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.misc.OrderedHashSet;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.tool.Attribute;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.ActionAST;
import org.antlr.v4.tool.ast.AltAST;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.PredAST;

public class RuleFunction
extends OutputModelObject {
    public final String name;
    public final String escapedName;
    public final List<String> modifiers;
    public String ctxType;
    public final Collection<String> ruleLabels;
    public final Collection<String> tokenLabels;
    public final ATNState startState;
    public final int index;
    public final Rule rule;
    public final AltLabelStructDecl[] altToContext;
    public boolean hasLookaheadBlock;
    @ModelElement
    public List<SrcOp> code;
    @ModelElement
    public OrderedHashSet<Decl> locals;
    @ModelElement
    public Collection<AttributeDecl> args = null;
    @ModelElement
    public StructDecl ruleCtx;
    @ModelElement
    public Map<String, AltLabelStructDecl> altLabelCtxs;
    @ModelElement
    public Map<String, Action> namedActions;
    @ModelElement
    public Action finallyAction;
    @ModelElement
    public List<ExceptionClause> exceptions;
    @ModelElement
    public List<SrcOp> postamble;

    public RuleFunction(OutputModelFactory factory, Rule r) {
        super(factory);
        Collection<Attribute> decls;
        this.name = r.name;
        this.escapedName = factory.getGenerator().getTarget().escapeIfNeeded(r.name);
        this.rule = r;
        this.modifiers = Utils.nodesToStrings(r.modifiers);
        this.index = r.index;
        this.ruleCtx = new StructDecl(factory, r);
        this.altToContext = new AltLabelStructDecl[r.getOriginalNumberOfAlts() + 1];
        this.addContextGetters(factory, r);
        if (r.args != null && (decls = r.args.attributes.values()).size() > 0) {
            this.args = new ArrayList<AttributeDecl>();
            this.ruleCtx.addDecls(decls);
            for (Attribute a : decls) {
                this.args.add(new AttributeDecl(factory, a));
            }
            this.ruleCtx.ctorAttrs = this.args;
        }
        if (r.retvals != null) {
            this.ruleCtx.addDecls(r.retvals.attributes.values());
        }
        if (r.locals != null) {
            this.ruleCtx.addDecls(r.locals.attributes.values());
        }
        this.ruleLabels = r.getElementLabelNames();
        this.tokenLabels = r.getTokenRefs();
        if (r.exceptions != null) {
            this.exceptions = new ArrayList<ExceptionClause>();
            for (GrammarAST e : r.exceptions) {
                ActionAST catchArg = (ActionAST)e.getChild(0);
                ActionAST catchAction = (ActionAST)e.getChild(1);
                this.exceptions.add(new ExceptionClause(factory, catchArg, catchAction));
            }
        }
        this.startState = factory.getGrammar().atn.ruleToStartState[r.index];
    }

    public void addContextGetters(OutputModelFactory factory, Rule r) {
        List<AltAST> altsNoLabels = r.getUnlabeledAltASTs();
        if (altsNoLabels != null) {
            Set<Decl> decls = this.getDeclsForAllElements(altsNoLabels);
            for (Decl decl : decls) {
                this.ruleCtx.addDecl(decl);
            }
        }
        this.altLabelCtxs = new HashMap<String, AltLabelStructDecl>();
        Map<String, List<Pair<Integer, AltAST>>> labels = r.getAltLabels();
        if (labels != null) {
            for (Map.Entry entry : labels.entrySet()) {
                String label = (String)entry.getKey();
                ArrayList<AltAST> alts = new ArrayList<AltAST>();
                for (Pair pair2 : (List)entry.getValue()) {
                    alts.add((AltAST)pair2.b);
                }
                Set<Decl> decls = this.getDeclsForAllElements(alts);
                for (Pair pair3 : (List)entry.getValue()) {
                    Integer altNum = (Integer)pair3.a;
                    this.altToContext[altNum.intValue()] = new AltLabelStructDecl(factory, r, altNum, label);
                    if (!this.altLabelCtxs.containsKey(label)) {
                        this.altLabelCtxs.put(label, this.altToContext[altNum]);
                    }
                    for (Decl d : decls) {
                        this.altToContext[altNum].addDecl(d);
                    }
                }
            }
        }
    }

    public void fillNamedActions(OutputModelFactory factory, Rule r) {
        if (r.finallyAction != null) {
            this.finallyAction = new Action(factory, r.finallyAction);
        }
        this.namedActions = new HashMap<String, Action>();
        for (String name : r.namedActions.keySet()) {
            ActionAST ast = r.namedActions.get(name);
            this.namedActions.put(name, new Action(factory, ast));
        }
    }

    public Set<Decl> getDeclsForAllElements(List<AltAST> altASTs) {
        HashSet<String> needsList = new HashSet<String>();
        HashSet<String> nonOptional = new HashSet<String>();
        ArrayList<GrammarAST> allRefs = new ArrayList<GrammarAST>();
        boolean firstAlt = true;
        IntervalSet reftypes = new IntervalSet(54, 62, 59);
        for (AltAST ast : altASTs) {
            List<GrammarAST> refs = this.getRuleTokens(ast.getNodesWithType(reftypes));
            allRefs.addAll(refs);
            Pair<FrequencySet<String>, FrequencySet<String>> minAndAltFreq = this.getElementFrequenciesForAlt(ast);
            FrequencySet minFreq = (FrequencySet)minAndAltFreq.a;
            FrequencySet altFreq = (FrequencySet)minAndAltFreq.b;
            for (GrammarAST t : refs) {
                String refLabelName = this.getName(t);
                if (refLabelName == null) continue;
                if (altFreq.count(refLabelName) > 1) {
                    needsList.add(refLabelName);
                }
                if (!firstAlt || minFreq.count(refLabelName) == 0) continue;
                nonOptional.add(refLabelName);
            }
            for (String ref : nonOptional.toArray(new String[0])) {
                if (minFreq.count(ref) != 0) continue;
                nonOptional.remove(ref);
            }
            firstAlt = false;
        }
        LinkedHashSet<Decl> decls = new LinkedHashSet<Decl>();
        for (GrammarAST t : allRefs) {
            String refLabelName = this.getName(t);
            if (refLabelName == null) continue;
            List<Decl> d = this.getDeclForAltElement(t, refLabelName, needsList.contains(refLabelName), !nonOptional.contains(refLabelName));
            decls.addAll(d);
        }
        return decls;
    }

    private List<GrammarAST> getRuleTokens(List<GrammarAST> refs) {
        ArrayList<GrammarAST> result2 = new ArrayList<GrammarAST>(refs.size());
        Iterator<GrammarAST> iterator2 = refs.iterator();
        while (iterator2.hasNext()) {
            GrammarAST ref;
            CommonTree r = ref = iterator2.next();
            boolean ignore = false;
            while (r != null) {
                if (r instanceof PredAST) {
                    ignore = true;
                    break;
                }
                r = r.parent;
            }
            if (ignore) continue;
            result2.add(ref);
        }
        return result2;
    }

    private String getName(GrammarAST token2) {
        String tokenText = token2.getText();
        String tokenName = token2.getType() != 59 ? tokenText : token2.g.getTokenName(tokenText);
        return tokenName == null || tokenName.startsWith("T__") ? null : tokenName;
    }

    protected Pair<FrequencySet<String>, FrequencySet<String>> getElementFrequenciesForAlt(AltAST ast) {
        try {
            ElementFrequenciesVisitor visitor2 = new ElementFrequenciesVisitor(new CommonTreeNodeStream(new GrammarASTAdaptor(), ast));
            visitor2.outerAlternative();
            if (visitor2.frequencies.size() != 1) {
                this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, new Object[0]);
                return new Pair<FrequencySet<String>, FrequencySet<String>>(new FrequencySet(), new FrequencySet());
            }
            return new Pair<FrequencySet<String>, FrequencySet<String>>(visitor2.getMinFrequencies(), visitor2.frequencies.peek());
        }
        catch (RecognitionException ex) {
            this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, ex, new Object[0]);
            return new Pair<FrequencySet<String>, FrequencySet<String>>(new FrequencySet(), new FrequencySet());
        }
    }

    public List<Decl> getDeclForAltElement(GrammarAST t, String refLabelName, boolean needList, boolean optional2) {
        ArrayList<Decl> decls = new ArrayList<Decl>();
        if (t.getType() == 54) {
            Rule rref = this.factory.getGrammar().getRule(t.getText());
            String ctxName = this.factory.getGenerator().getTarget().getRuleFunctionContextStructName(rref);
            if (needList) {
                if (this.factory.getGenerator().getTarget().supportsOverloadedMethods()) {
                    decls.add(new ContextRuleListGetterDecl(this.factory, refLabelName, ctxName));
                }
                decls.add(new ContextRuleListIndexedGetterDecl(this.factory, refLabelName, ctxName));
            } else {
                decls.add(new ContextRuleGetterDecl(this.factory, refLabelName, ctxName, optional2));
            }
        } else if (needList) {
            if (this.factory.getGenerator().getTarget().supportsOverloadedMethods()) {
                decls.add(new ContextTokenListGetterDecl(this.factory, refLabelName));
            }
            decls.add(new ContextTokenListIndexedGetterDecl(this.factory, refLabelName));
        } else {
            decls.add(new ContextTokenGetterDecl(this.factory, refLabelName, optional2));
        }
        return decls;
    }

    public void addLocalDecl(Decl d) {
        if (this.locals == null) {
            this.locals = new OrderedHashSet();
        }
        this.locals.add(d);
        d.isLocal = true;
    }

    public void addContextDecl(String altLabel, Decl d) {
        AltLabelStructDecl altCtx;
        CodeBlockForOuterMostAlt alt = d.getOuterMostAltCodeBlock();
        if (alt != null && this.altLabelCtxs != null && (altCtx = this.altLabelCtxs.get(altLabel)) != null) {
            altCtx.addDecl(d);
            return;
        }
        this.ruleCtx.addDecl(d);
    }
}

