/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import ognl.BooleanExpression;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.enhance.ExpressionCompiler;
import ognl.enhance.UnsupportedCompilationException;

public class ASTOr
extends BooleanExpression {
    public ASTOr(int id) {
        super(id);
    }

    public ASTOr(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    public void jjtClose() {
        this.flattenTree();
    }

    @Override
    protected Object getValueBody(OgnlContext context2, Object source) throws OgnlException {
        Object result2 = null;
        int last2 = this._children.length - 1;
        for (int i = 0; i <= last2; ++i) {
            result2 = this._children[i].getValue(context2, source);
            if (i != last2 && OgnlOps.booleanValue(result2)) break;
        }
        return result2;
    }

    @Override
    protected void setValueBody(OgnlContext context2, Object target, Object value) throws OgnlException {
        int last2 = this._children.length - 1;
        for (int i = 0; i < last2; ++i) {
            Object v = this._children[i].getValue(context2, target);
            if (!OgnlOps.booleanValue(v)) continue;
            return;
        }
        this._children[last2].setValue(context2, target, value);
    }

    @Override
    public String getExpressionOperator(int index) {
        return "||";
    }

    @Override
    public Class getGetterClass() {
        return null;
    }

    @Override
    public String toGetSourceString(OgnlContext context2, Object target) {
        if (this._children.length != 2) {
            throw new UnsupportedCompilationException("Can only compile boolean expressions with two children.");
        }
        String result2 = "(";
        try {
            String first2 = OgnlRuntime.getChildSource(context2, target, this._children[0]);
            if (!OgnlRuntime.isBoolean(first2)) {
                first2 = OgnlRuntime.getCompiler().createLocalReference(context2, first2, context2.getCurrentType());
            }
            Class firstType = context2.getCurrentType();
            String second2 = OgnlRuntime.getChildSource(context2, target, this._children[1]);
            if (!OgnlRuntime.isBoolean(second2)) {
                second2 = OgnlRuntime.getCompiler().createLocalReference(context2, second2, context2.getCurrentType());
            }
            Class secondType = context2.getCurrentType();
            boolean mismatched = firstType.isPrimitive() && !secondType.isPrimitive() || !firstType.isPrimitive() && secondType.isPrimitive();
            result2 = result2 + "ognl.OgnlOps.booleanValue(" + first2 + ")";
            result2 = result2 + " ? ";
            result2 = result2 + (mismatched ? " ($w) " : "") + first2;
            result2 = result2 + " : ";
            result2 = result2 + (mismatched ? " ($w) " : "") + second2;
            result2 = result2 + ")";
            context2.setCurrentObject(target);
            context2.setCurrentType(Boolean.TYPE);
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return result2;
    }

    @Override
    public String toSetSourceString(OgnlContext context2, Object target) {
        if (this._children.length != 2) {
            throw new UnsupportedCompilationException("Can only compile boolean expressions with two children.");
        }
        String pre = (String)context2.get("_currentChain");
        if (pre == null) {
            pre = "";
        }
        String result2 = "";
        try {
            this._children[0].getValue(context2, target);
            String first2 = ExpressionCompiler.getRootExpression(this._children[0], context2.getRoot(), context2) + pre + this._children[0].toGetSourceString(context2, target);
            if (!OgnlRuntime.isBoolean(first2)) {
                first2 = OgnlRuntime.getCompiler().createLocalReference(context2, first2, Object.class);
            }
            this._children[1].getValue(context2, target);
            String second2 = ExpressionCompiler.getRootExpression(this._children[1], context2.getRoot(), context2) + pre + this._children[1].toSetSourceString(context2, target);
            if (!OgnlRuntime.isBoolean(second2)) {
                second2 = OgnlRuntime.getCompiler().createLocalReference(context2, second2, context2.getCurrentType());
            }
            result2 = result2 + "ognl.OgnlOps.booleanValue(" + first2 + ")";
            result2 = result2 + " ? ";
            result2 = result2 + first2;
            result2 = result2 + " : ";
            result2 = result2 + second2;
            context2.setCurrentObject(target);
            context2.setCurrentType(Boolean.TYPE);
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return result2;
    }
}

