/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Array;
import ognl.ASTAnd;
import ognl.ASTConst;
import ognl.ASTCtor;
import ognl.ASTOr;
import ognl.ASTProperty;
import ognl.ASTSequence;
import ognl.ASTStaticField;
import ognl.ASTVarRef;
import ognl.DynamicSubscript;
import ognl.NodeType;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.enhance.OrderedReturn;
import ognl.enhance.UnsupportedCompilationException;

public class ASTChain
extends SimpleNode
implements NodeType,
OrderedReturn {
    private Class _getterClass;
    private Class _setterClass;
    private String _lastExpression;
    private String _coreExpression;

    public ASTChain(int id) {
        super(id);
    }

    public ASTChain(OgnlParser p, int id) {
        super(p, id);
    }

    @Override
    public String getLastExpression() {
        return this._lastExpression;
    }

    @Override
    public String getCoreExpression() {
        return this._coreExpression;
    }

    @Override
    public void jjtClose() {
        this.flattenTree();
    }

    @Override
    protected Object getValueBody(OgnlContext context2, Object source) throws OgnlException {
        Object result2 = source;
        int ilast = this._children.length - 1;
        for (int i = 0; i <= ilast; ++i) {
            ASTProperty indexNode;
            ASTProperty propertyNode;
            int indexType;
            boolean handled = false;
            if (i < ilast && this._children[i] instanceof ASTProperty && (indexType = (propertyNode = (ASTProperty)this._children[i]).getIndexedPropertyType(context2, result2)) != OgnlRuntime.INDEXED_PROPERTY_NONE && this._children[i + 1] instanceof ASTProperty && (indexNode = (ASTProperty)this._children[i + 1]).isIndexedAccess()) {
                Object index = indexNode.getProperty(context2, result2);
                if (index instanceof DynamicSubscript) {
                    if (indexType == OgnlRuntime.INDEXED_PROPERTY_INT) {
                        Object array = propertyNode.getValue(context2, result2);
                        int len = Array.getLength(array);
                        switch (((DynamicSubscript)index).getFlag()) {
                            case 3: {
                                result2 = Array.newInstance(array.getClass().getComponentType(), len);
                                System.arraycopy(array, 0, result2, 0, len);
                                handled = true;
                                ++i;
                                break;
                            }
                            case 0: {
                                index = new Integer(len > 0 ? 0 : -1);
                                break;
                            }
                            case 1: {
                                index = new Integer(len > 0 ? len / 2 : -1);
                                break;
                            }
                            case 2: {
                                index = new Integer(len > 0 ? len - 1 : -1);
                            }
                        }
                    } else if (indexType == OgnlRuntime.INDEXED_PROPERTY_OBJECT) {
                        throw new OgnlException("DynamicSubscript '" + indexNode + "' not allowed for object indexed property '" + propertyNode + "'");
                    }
                }
                if (!handled) {
                    result2 = OgnlRuntime.getIndexedProperty(context2, result2, propertyNode.getProperty(context2, result2).toString(), index);
                    handled = true;
                    ++i;
                }
            }
            if (handled) continue;
            result2 = this._children[i].getValue(context2, result2);
        }
        return result2;
    }

    @Override
    protected void setValueBody(OgnlContext context2, Object target, Object value) throws OgnlException {
        boolean handled = false;
        int ilast = this._children.length - 2;
        for (int i = 0; i <= ilast; ++i) {
            ASTProperty indexNode;
            ASTProperty propertyNode;
            int indexType;
            if (i <= ilast && this._children[i] instanceof ASTProperty && (indexType = (propertyNode = (ASTProperty)this._children[i]).getIndexedPropertyType(context2, target)) != OgnlRuntime.INDEXED_PROPERTY_NONE && this._children[i + 1] instanceof ASTProperty && (indexNode = (ASTProperty)this._children[i + 1]).isIndexedAccess()) {
                Object index = indexNode.getProperty(context2, target);
                if (index instanceof DynamicSubscript) {
                    if (indexType == OgnlRuntime.INDEXED_PROPERTY_INT) {
                        Object array = propertyNode.getValue(context2, target);
                        int len = Array.getLength(array);
                        switch (((DynamicSubscript)index).getFlag()) {
                            case 3: {
                                System.arraycopy(target, 0, value, 0, len);
                                handled = true;
                                ++i;
                                break;
                            }
                            case 0: {
                                index = new Integer(len > 0 ? 0 : -1);
                                break;
                            }
                            case 1: {
                                index = new Integer(len > 0 ? len / 2 : -1);
                                break;
                            }
                            case 2: {
                                index = new Integer(len > 0 ? len - 1 : -1);
                            }
                        }
                    } else if (indexType == OgnlRuntime.INDEXED_PROPERTY_OBJECT) {
                        throw new OgnlException("DynamicSubscript '" + indexNode + "' not allowed for object indexed property '" + propertyNode + "'");
                    }
                }
                if (!handled && i == ilast) {
                    OgnlRuntime.setIndexedProperty(context2, target, propertyNode.getProperty(context2, target).toString(), index, value);
                    handled = true;
                    ++i;
                } else if (!handled) {
                    target = OgnlRuntime.getIndexedProperty(context2, target, propertyNode.getProperty(context2, target).toString(), index);
                    ++i;
                    continue;
                }
            }
            if (handled) continue;
            target = this._children[i].getValue(context2, target);
        }
        if (!handled) {
            this._children[this._children.length - 1].setValue(context2, target, value);
        }
    }

    @Override
    public boolean isSimpleNavigationChain(OgnlContext context2) throws OgnlException {
        boolean result2 = false;
        if (this._children != null && this._children.length > 0) {
            result2 = true;
            for (int i = 0; result2 && i < this._children.length; ++i) {
                result2 = this._children[i] instanceof SimpleNode ? ((SimpleNode)this._children[i]).isSimpleProperty(context2) : false;
            }
        }
        return result2;
    }

    @Override
    public Class getGetterClass() {
        return this._getterClass;
    }

    @Override
    public Class getSetterClass() {
        return this._setterClass;
    }

    @Override
    public String toString() {
        String result2 = "";
        if (this._children != null && this._children.length > 0) {
            for (int i = 0; i < this._children.length; ++i) {
                if (!(i <= 0 || this._children[i] instanceof ASTProperty && ((ASTProperty)this._children[i]).isIndexedAccess())) {
                    result2 = result2 + ".";
                }
                result2 = result2 + this._children[i].toString();
            }
        }
        return result2;
    }

    @Override
    public String toGetSourceString(OgnlContext context2, Object target) {
        String prevChain = (String)context2.get("_currentChain");
        if (target != null) {
            context2.setCurrentObject(target);
            context2.setCurrentType(target.getClass());
        }
        String result2 = "";
        NodeType _lastType = null;
        boolean ordered = false;
        boolean constructor = false;
        try {
            if (this._children != null && this._children.length > 0) {
                for (int i = 0; i < this._children.length; ++i) {
                    String value = this._children[i].toGetSourceString(context2, context2.getCurrentObject());
                    if (ASTCtor.class.isInstance(this._children[i])) {
                        constructor = true;
                    }
                    if (NodeType.class.isInstance(this._children[i]) && ((NodeType)((Object)this._children[i])).getGetterClass() != null) {
                        _lastType = (NodeType)((Object)this._children[i]);
                    }
                    if (!(ASTVarRef.class.isInstance(this._children[i]) || constructor || OrderedReturn.class.isInstance(this._children[i]) && ((OrderedReturn)((Object)this._children[i])).getLastExpression() != null || this._parent != null && ASTSequence.class.isInstance(this._parent))) {
                        value = OgnlRuntime.getCompiler().castExpression(context2, this._children[i], value);
                    }
                    if (OrderedReturn.class.isInstance(this._children[i]) && ((OrderedReturn)((Object)this._children[i])).getLastExpression() != null) {
                        ordered = true;
                        OrderedReturn or = (OrderedReturn)((Object)this._children[i]);
                        result2 = or.getCoreExpression() == null || or.getCoreExpression().trim().length() <= 0 ? "" : result2 + or.getCoreExpression();
                        this._lastExpression = or.getLastExpression();
                        if (context2.get("_preCast") != null) {
                            this._lastExpression = context2.remove("_preCast") + this._lastExpression;
                        }
                    } else if (ASTOr.class.isInstance(this._children[i]) || ASTAnd.class.isInstance(this._children[i]) || ASTCtor.class.isInstance(this._children[i]) || ASTStaticField.class.isInstance(this._children[i]) && this._parent == null) {
                        context2.put("_noRoot", "true");
                        result2 = value;
                    } else {
                        result2 = result2 + value;
                    }
                    context2.put("_currentChain", result2);
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        if (_lastType != null) {
            this._getterClass = _lastType.getGetterClass();
            this._setterClass = _lastType.getSetterClass();
        }
        if (ordered) {
            this._coreExpression = result2;
        }
        context2.put("_currentChain", prevChain);
        return result2;
    }

    @Override
    public String toSetSourceString(OgnlContext context2, Object target) {
        String prevChain = (String)context2.get("_currentChain");
        String prevChild = (String)context2.get("_lastChild");
        if (prevChain != null) {
            throw new UnsupportedCompilationException("Can't compile nested chain expressions.");
        }
        if (target != null) {
            context2.setCurrentObject(target);
            context2.setCurrentType(target.getClass());
        }
        String result2 = "";
        NodeType _lastType = null;
        boolean constructor = false;
        try {
            if (this._children != null && this._children.length > 0) {
                if (ASTConst.class.isInstance(this._children[0])) {
                    throw new UnsupportedCompilationException("Can't modify constant values.");
                }
                for (int i = 0; i < this._children.length; ++i) {
                    if (i == this._children.length - 1) {
                        context2.put("_lastChild", "true");
                    }
                    String value = this._children[i].toSetSourceString(context2, context2.getCurrentObject());
                    if (ASTCtor.class.isInstance(this._children[i])) {
                        constructor = true;
                    }
                    if (NodeType.class.isInstance(this._children[i]) && ((NodeType)((Object)this._children[i])).getGetterClass() != null) {
                        _lastType = (NodeType)((Object)this._children[i]);
                    }
                    if (!(ASTVarRef.class.isInstance(this._children[i]) || constructor || OrderedReturn.class.isInstance(this._children[i]) && ((OrderedReturn)((Object)this._children[i])).getLastExpression() != null || this._parent != null && ASTSequence.class.isInstance(this._parent))) {
                        value = OgnlRuntime.getCompiler().castExpression(context2, this._children[i], value);
                    }
                    if (ASTOr.class.isInstance(this._children[i]) || ASTAnd.class.isInstance(this._children[i]) || ASTCtor.class.isInstance(this._children[i]) || ASTStaticField.class.isInstance(this._children[i])) {
                        context2.put("_noRoot", "true");
                        result2 = value;
                    } else {
                        result2 = result2 + value;
                    }
                    context2.put("_currentChain", result2);
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        context2.put("_lastChild", prevChild);
        context2.put("_currentChain", prevChain);
        if (_lastType != null) {
            this._setterClass = _lastType.getSetterClass();
        }
        return result2;
    }

    @Override
    public boolean isChain(OgnlContext context2) {
        return true;
    }
}

