/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class UpsertValidator
extends AbstractValidator<Upsert> {
    @Override
    public void validate(Upsert upsert) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.upsert);
        }
        this.validateOptionalFromItem(upsert.getTable());
        this.validateOptionalExpressions(upsert.getColumns());
        this.validateOptionalItemsList(upsert.getItemsList());
        this.validateOptionalSelect(upsert.getSelect());
        if (upsert.isUseDuplicate()) {
            this.validateDuplicate(upsert);
        }
    }

    private void validateOptionalSelect(Select select2) {
        if (select2 != null) {
            SelectValidator v = this.getValidator(SelectValidator.class);
            if (this.isNotEmpty(select2.getWithItemsList())) {
                select2.getWithItemsList().forEach(with -> with.accept(v));
            }
            select2.getSelectBody().accept(v);
        }
    }

    private void validateDuplicate(Upsert upsert) {
        this.validateOptionalExpressions(upsert.getDuplicateUpdateColumns());
        this.validateOptionalExpressions(upsert.getDuplicateUpdateExpressionList());
    }
}

