/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.Block;
import net.sf.jsqlparser.statement.Commit;
import net.sf.jsqlparser.statement.CreateFunctionalStatement;
import net.sf.jsqlparser.statement.DeclareStatement;
import net.sf.jsqlparser.statement.DescribeStatement;
import net.sf.jsqlparser.statement.ExplainStatement;
import net.sf.jsqlparser.statement.IfElseStatement;
import net.sf.jsqlparser.statement.PurgeStatement;
import net.sf.jsqlparser.statement.ResetStatement;
import net.sf.jsqlparser.statement.RollbackStatement;
import net.sf.jsqlparser.statement.SavepointStatement;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.ShowColumnsStatement;
import net.sf.jsqlparser.statement.ShowStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.statement.UnsupportedStatement;
import net.sf.jsqlparser.statement.UseStatement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterSession;
import net.sf.jsqlparser.statement.alter.AlterSystemStatement;
import net.sf.jsqlparser.statement.alter.RenameTableStatement;
import net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import net.sf.jsqlparser.statement.analyze.Analyze;
import net.sf.jsqlparser.statement.comment.Comment;
import net.sf.jsqlparser.statement.create.function.CreateFunction;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.procedure.CreateProcedure;
import net.sf.jsqlparser.statement.create.schema.CreateSchema;
import net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import net.sf.jsqlparser.statement.create.synonym.CreateSynonym;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.view.AlterView;
import net.sf.jsqlparser.statement.create.view.CreateView;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.grant.Grant;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.replace.Replace;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.show.ShowTablesStatement;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;
import net.sf.jsqlparser.statement.values.ValuesStatement;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import net.sf.jsqlparser.util.validation.validator.AlterSequenceValidator;
import net.sf.jsqlparser.util.validation.validator.AlterValidator;
import net.sf.jsqlparser.util.validation.validator.AlterViewValidator;
import net.sf.jsqlparser.util.validation.validator.AnalyzeValidator;
import net.sf.jsqlparser.util.validation.validator.CreateIndexValidator;
import net.sf.jsqlparser.util.validation.validator.CreateSequenceValidator;
import net.sf.jsqlparser.util.validation.validator.CreateSynonymValidator;
import net.sf.jsqlparser.util.validation.validator.CreateTableValidator;
import net.sf.jsqlparser.util.validation.validator.CreateViewValidator;
import net.sf.jsqlparser.util.validation.validator.DeclareStatementValidator;
import net.sf.jsqlparser.util.validation.validator.DeleteValidator;
import net.sf.jsqlparser.util.validation.validator.DropValidator;
import net.sf.jsqlparser.util.validation.validator.ExecuteValidator;
import net.sf.jsqlparser.util.validation.validator.GrantValidator;
import net.sf.jsqlparser.util.validation.validator.InsertValidator;
import net.sf.jsqlparser.util.validation.validator.MergeValidator;
import net.sf.jsqlparser.util.validation.validator.ReplaceValidator;
import net.sf.jsqlparser.util.validation.validator.ResetStatementValidator;
import net.sf.jsqlparser.util.validation.validator.SelectValidator;
import net.sf.jsqlparser.util.validation.validator.SetStatementValidator;
import net.sf.jsqlparser.util.validation.validator.ShowColumnsStatementValidator;
import net.sf.jsqlparser.util.validation.validator.ShowStatementValidator;
import net.sf.jsqlparser.util.validation.validator.ShowTablesStatementValidator;
import net.sf.jsqlparser.util.validation.validator.UpdateValidator;
import net.sf.jsqlparser.util.validation.validator.UpsertValidator;
import net.sf.jsqlparser.util.validation.validator.UseStatementValidator;
import net.sf.jsqlparser.util.validation.validator.ValuesStatementValidator;

public class StatementValidator
extends AbstractValidator<Statement>
implements StatementVisitor {
    @Override
    public void visit(CreateIndex createIndex) {
        this.getValidator(CreateIndexValidator.class).validate(createIndex);
    }

    @Override
    public void visit(CreateTable createTable) {
        this.getValidator(CreateTableValidator.class).validate(createTable);
    }

    @Override
    public void visit(CreateView createView) {
        this.getValidator(CreateViewValidator.class).validate(createView);
    }

    @Override
    public void visit(AlterView alterView) {
        this.getValidator(AlterViewValidator.class).validate(alterView);
    }

    @Override
    public void visit(Delete delete2) {
        this.getValidator(DeleteValidator.class).validate(delete2);
    }

    @Override
    public void visit(Drop drop2) {
        this.getValidator(DropValidator.class).validate(drop2);
    }

    @Override
    public void visit(Insert insert) {
        this.getValidator(InsertValidator.class).validate(insert);
    }

    @Override
    public void visit(Replace replace) {
        this.getValidator(ReplaceValidator.class).validate(replace);
    }

    @Override
    public void visit(Select select2) {
        this.validateFeature(Feature.select);
        SelectValidator selectValidator = this.getValidator(SelectValidator.class);
        if (select2.getWithItemsList() != null) {
            select2.getWithItemsList().forEach(wi -> wi.accept(selectValidator));
        }
        select2.getSelectBody().accept(selectValidator);
    }

    @Override
    public void visit(Truncate truncate) {
        this.validateFeature(Feature.truncate);
        this.validateOptionalFromItem(truncate.getTable());
    }

    @Override
    public void visit(Update update) {
        this.getValidator(UpdateValidator.class).validate(update);
    }

    @Override
    public void visit(Alter alter) {
        this.getValidator(AlterValidator.class).validate(alter);
    }

    @Override
    public void visit(Statements stmts) {
        stmts.getStatements().forEach(s -> s.accept(this));
    }

    @Override
    public void visit(Execute execute2) {
        this.getValidator(ExecuteValidator.class).validate(execute2);
    }

    @Override
    public void visit(SetStatement set2) {
        this.getValidator(SetStatementValidator.class).validate(set2);
    }

    @Override
    public void visit(ResetStatement reset) {
        this.getValidator(ResetStatementValidator.class).validate(reset);
    }

    @Override
    public void visit(Merge merge) {
        this.getValidator(MergeValidator.class).validate(merge);
    }

    @Override
    public void visit(Commit commit) {
        this.validateFeature(Feature.commit);
    }

    @Override
    public void visit(Upsert upsert) {
        this.getValidator(UpsertValidator.class).validate(upsert);
    }

    @Override
    public void visit(UseStatement use) {
        this.getValidator(UseStatementValidator.class).validate(use);
    }

    @Override
    public void visit(ShowStatement show) {
        this.getValidator(ShowStatementValidator.class).validate(show);
    }

    @Override
    public void visit(ShowColumnsStatement show) {
        this.getValidator(ShowColumnsStatementValidator.class).validate(show);
    }

    @Override
    public void visit(ShowTablesStatement showTables) {
        this.getValidator(ShowTablesStatementValidator.class).validate(showTables);
    }

    @Override
    public void visit(Block block2) {
        this.validateFeature(Feature.block);
        block2.getStatements().accept(this);
    }

    @Override
    public void visit(Comment comment) {
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.comment);
            this.validateOptionalFeature(c, comment.getTable(), Feature.commentOnTable);
            this.validateOptionalFeature(c, comment.getColumn(), Feature.commentOnColumn);
            this.validateOptionalFeature(c, comment.getView(), Feature.commentOnView);
        }
    }

    @Override
    public void visit(ValuesStatement values2) {
        this.getValidator(ValuesStatementValidator.class).validate(values2);
    }

    @Override
    public void visit(DescribeStatement describe) {
        this.validateFeature(Feature.describe);
        this.validateOptionalFromItem(describe.getTable());
    }

    @Override
    public void visit(ExplainStatement explain) {
        this.validateFeature(Feature.explain);
        explain.getStatement().accept(this);
    }

    @Override
    public void visit(DeclareStatement declare) {
        this.getValidator(DeclareStatementValidator.class).validate(declare);
    }

    @Override
    public void visit(Grant grant) {
        this.getValidator(GrantValidator.class).validate(grant);
    }

    @Override
    public void visit(CreateSchema aThis) {
        this.validateFeatureAndName(Feature.createSchema, NamedObject.schema, aThis.getSchemaName());
        aThis.getStatements().forEach(s -> s.accept(this));
    }

    @Override
    public void visit(CreateSequence createSequence) {
        this.getValidator(CreateSequenceValidator.class).validate(createSequence);
    }

    @Override
    public void visit(AlterSequence alterSequence) {
        this.getValidator(AlterSequenceValidator.class).validate(alterSequence);
    }

    @Override
    public void visit(CreateFunctionalStatement createFunctionalStatement) {
        this.validateFeature(Feature.functionalStatement);
        if (createFunctionalStatement instanceof CreateFunction) {
            this.validateFeature(Feature.createFunction);
        } else if (createFunctionalStatement instanceof CreateProcedure) {
            this.validateFeature(Feature.createProcedure);
        }
    }

    @Override
    public void validate(Statement statement2) {
        statement2.accept(this);
    }

    @Override
    public void visit(CreateSynonym createSynonym) {
        this.getValidator(CreateSynonymValidator.class).validate(createSynonym);
    }

    @Override
    public void visit(Analyze analyze) {
        this.getValidator(AnalyzeValidator.class).validate(analyze);
    }

    @Override
    public void visit(SavepointStatement savepointStatement) {
    }

    @Override
    public void visit(RollbackStatement rollbackStatement) {
    }

    @Override
    public void visit(AlterSession alterSession) {
    }

    @Override
    public void visit(IfElseStatement ifElseStatement) {
        ifElseStatement.getIfStatement().accept(this);
        if (ifElseStatement.getElseStatement() != null) {
            ifElseStatement.getElseStatement().accept(this);
        }
    }

    @Override
    public void visit(RenameTableStatement renameTableStatement) {
    }

    @Override
    public void visit(PurgeStatement purgeStatement) {
    }

    @Override
    public void visit(AlterSystemStatement alterSystemStatement) {
    }

    @Override
    public void visit(UnsupportedStatement unsupportedStatement) {
    }
}

