/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation.validator;

import java.util.Arrays;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.metadata.NamedObject;
import net.sf.jsqlparser.util.validation.validator.AbstractValidator;

public class DropValidator
extends AbstractValidator<Drop> {
    @Override
    public void validate(Drop drop2) {
        String type2 = drop2.getType();
        for (ValidationCapability c : this.getCapabilities()) {
            this.validateFeature(c, Feature.drop);
            this.validateFeature(c, NamedObject.table.name().equalsIgnoreCase(type2), Feature.dropTable);
            this.validateFeature(c, NamedObject.index.equalsIgnoreCase(type2), Feature.dropIndex);
            this.validateFeature(c, NamedObject.view.equalsIgnoreCase(type2), Feature.dropView);
            this.validateFeature(c, NamedObject.schema.equalsIgnoreCase(type2), Feature.dropSchema);
            this.validateFeature(c, NamedObject.sequence.equalsIgnoreCase(type2), Feature.dropSequence);
            this.validateFeature(c, drop2.isIfExists() && NamedObject.table.name().equalsIgnoreCase(type2), Feature.dropTableIfExists);
            this.validateFeature(c, drop2.isIfExists() && NamedObject.index.equalsIgnoreCase(type2), Feature.dropIndexIfExists);
            this.validateFeature(c, drop2.isIfExists() && NamedObject.view.equalsIgnoreCase(type2), Feature.dropViewIfExists);
            this.validateFeature(c, drop2.isIfExists() && NamedObject.schema.equalsIgnoreCase(type2), Feature.dropSchemaIfExists);
            this.validateFeature(c, drop2.isIfExists() && NamedObject.sequence.equalsIgnoreCase(type2), Feature.dropSequenceIfExists);
        }
        NamedObject named = NamedObject.forName(type2);
        if (Arrays.asList(NamedObject.table, NamedObject.view).contains((Object)named)) {
            this.validateName(named, drop2.getName().getFullyQualifiedName());
        }
    }
}

