/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jsqlparser.parser.feature.Feature;
import net.sf.jsqlparser.parser.feature.FeatureConfiguration;
import net.sf.jsqlparser.util.validation.ContextKey;
import net.sf.jsqlparser.util.validation.ValidationCapability;

public class ValidationContext {
    private Collection<ValidationCapability> capabilities;
    private FeatureConfiguration configuration = new FeatureConfiguration();
    private Map<ContextKey, Object> contextMap = new HashMap<ContextKey, Object>();

    public ValidationContext put(ContextKey key, Object value) {
        this.contextMap.put(key, value);
        return this;
    }

    public <T> T get(ContextKey key, Class<T> type2) {
        T t = this.getOptional(key, type2);
        if (t == null) {
            throw new IllegalStateException(key + ": value missing");
        }
        return t;
    }

    public <T> T getOptional(ContextKey key, Class<T> type2) {
        return type2.cast(this.contextMap.get(key));
    }

    public ValidationContext reinit(boolean reInit) {
        if (reInit) {
            this.contextMap.clear();
        }
        return this;
    }

    public ValidationContext setConfiguration(FeatureConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public FeatureConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean getAsBoolean(Feature f) {
        return this.getConfiguration().getAsBoolean(f);
    }

    public String getAsString(Feature f) {
        return this.getConfiguration().getAsString(f);
    }

    public Collection<ValidationCapability> getCapabilities() {
        return this.capabilities;
    }

    public ValidationContext setCapabilities(Collection<ValidationCapability> capabilities2) {
        this.capabilities = capabilities2;
        return this;
    }
}

