/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.parser.feature.FeatureConfiguration;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.Statements;
import net.sf.jsqlparser.util.validation.ParseCapability;
import net.sf.jsqlparser.util.validation.ValidationCapability;
import net.sf.jsqlparser.util.validation.ValidationContext;
import net.sf.jsqlparser.util.validation.ValidationError;
import net.sf.jsqlparser.util.validation.ValidationException;
import net.sf.jsqlparser.util.validation.validator.StatementValidator;

public class Validation {
    private FeatureConfiguration featureConfiguration;
    private Collection<? extends ValidationCapability> capabilities;
    private List<String> statementsList;
    private List<ValidationError> errors;
    private Statements parsedStatements;

    public Validation(Collection<? extends ValidationCapability> capabilities2, String ... statements) {
        this(new FeatureConfiguration(), capabilities2, statements);
    }

    public Validation(FeatureConfiguration featureConfiguration, Collection<? extends ValidationCapability> capabilities2, String ... statements) {
        this.featureConfiguration = featureConfiguration;
        this.capabilities = capabilities2;
        this.statementsList = Arrays.asList(statements);
    }

    public List<ValidationError> validate() {
        this.errors = new ArrayList<ValidationError>();
        ValidationContext context2 = Validation.createValidationContext(this.featureConfiguration, this.capabilities);
        for (String statements : this.statementsList) {
            ParseCapability parse2 = new ParseCapability(statements);
            parse2.validate(context2, e -> this.errors.add(new ValidationError(statements).withCapability(parse2).addError((ValidationException)e)));
            this.parsedStatements = parse2.getParsedStatements();
            if (this.parsedStatements == null || this.parsedStatements.getStatements() == null || this.capabilities.isEmpty()) continue;
            for (Statement parsedStatement : this.parsedStatements.getStatements()) {
                Map<ValidationCapability, Set<ValidationException>> errorMap = Validation.validate(parsedStatement, context2);
                this.errors.addAll(Validation.toValidationErrors(statements, parsedStatement, errorMap));
            }
        }
        return this.errors;
    }

    public FeatureConfiguration getFeatureConfiguration() {
        return this.featureConfiguration;
    }

    public Collection<? extends ValidationCapability> getCapabilities() {
        return this.capabilities;
    }

    public List<String> getStatements() {
        return this.statementsList;
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public Statements getParsedStatements() {
        return this.parsedStatements;
    }

    public static List<ValidationError> validate(Collection<? extends ValidationCapability> capabilities2, String ... statements) {
        return new Validation(capabilities2, statements).validate();
    }

    public static ValidationContext createValidationContext(FeatureConfiguration config2, Collection<? extends ValidationCapability> capabilities2) {
        ValidationContext context2 = new ValidationContext();
        context2.setCapabilities(new ArrayList<ValidationCapability>(capabilities2));
        context2.setConfiguration(config2);
        return context2;
    }

    public static List<ValidationError> toValidationErrors(String statements, Statement parsedStatement, Map<ValidationCapability, Set<ValidationException>> errorMap) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        for (Map.Entry<ValidationCapability, Set<ValidationException>> e : errorMap.entrySet()) {
            errors.add(new ValidationError(statements).withParsedStatement(parsedStatement).withCapability(e.getKey()).addErrors((Collection<ValidationException>)e.getValue()));
        }
        return errors;
    }

    public static Map<ValidationCapability, Set<ValidationException>> validate(Statement statement2, ValidationContext context2) {
        StatementValidator validator = new StatementValidator();
        validator.setContext(context2);
        validator.validate(statement2);
        return validator.getValidationErrors();
    }
}

