/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class SetStatementDeParser
extends AbstractDeParser<SetStatement> {
    private ExpressionVisitor expressionVisitor;

    public SetStatementDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(SetStatement set2) {
        this.buffer.append("SET ");
        if (set2.getEffectParameter() != null) {
            this.buffer.append(set2.getEffectParameter()).append(" ");
        }
        for (int i = 0; i < set2.getCount(); ++i) {
            if (i > 0) {
                this.buffer.append(", ");
            }
            this.buffer.append(set2.getName(i));
            if (set2.isUseEqual(i)) {
                this.buffer.append(" =");
            }
            this.buffer.append(" ");
            List<Expression> expressions = set2.getExpressions(i);
            for (int j = 0; j < expressions.size(); ++j) {
                if (j > 0) {
                    this.buffer.append(", ");
                }
                expressions.get(j).accept(this.expressionVisitor);
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor2) {
        this.expressionVisitor = visitor2;
    }
}

