/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.LimitDeparser;
import net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class DeleteDeParser
extends AbstractDeParser<Delete> {
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();

    public DeleteDeParser() {
        super(new StringBuilder());
    }

    public DeleteDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Delete delete2) {
        if (delete2.getWithItemsList() != null && !delete2.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = delete2.getWithItemsList().iterator();
            while (iter.hasNext()) {
                WithItem withItem = iter.next();
                this.buffer.append(withItem);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("DELETE");
        if (delete2.getModifierPriority() != null) {
            this.buffer.append(" ").append((Object)delete2.getModifierPriority());
        }
        if (delete2.isModifierQuick()) {
            this.buffer.append(" QUICK");
        }
        if (delete2.isModifierIgnore()) {
            this.buffer.append(" IGNORE");
        }
        if (delete2.getTables() != null && !delete2.getTables().isEmpty()) {
            this.buffer.append(delete2.getTables().stream().map(Table::getFullyQualifiedName).collect(Collectors.joining(", ", " ", "")));
        }
        if (delete2.getOutputClause() != null) {
            delete2.getOutputClause().appendTo(this.buffer);
        }
        if (delete2.isHasFrom()) {
            this.buffer.append(" FROM");
        }
        this.buffer.append(" ").append(delete2.getTable().toString());
        if (delete2.getUsingList() != null && !delete2.getUsingList().isEmpty()) {
            this.buffer.append(" USING").append(delete2.getUsingList().stream().map(Table::toString).collect(Collectors.joining(", ", " ", "")));
        }
        if (delete2.getJoins() != null) {
            for (Join join : delete2.getJoins()) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        if (delete2.getWhere() != null) {
            this.buffer.append(" WHERE ");
            delete2.getWhere().accept(this.expressionVisitor);
        }
        if (delete2.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(delete2.getOrderByElements());
        }
        if (delete2.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(delete2.getLimit());
        }
        if (delete2.getReturningExpressionList() != null) {
            this.buffer.append(" RETURNING ").append(PlainSelect.getStringList(delete2.getReturningExpressionList(), true, false));
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor2) {
        this.expressionVisitor = visitor2;
    }
}

