/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.DeclareStatement;
import net.sf.jsqlparser.statement.DeclareType;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class DeclareStatementDeParser
extends AbstractDeParser<DeclareStatement> {
    private ExpressionVisitor expressionVisitor;

    public DeclareStatementDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(DeclareStatement declare) {
        this.buffer.append("DECLARE ");
        if (declare.getUserVariable() != null) {
            declare.getUserVariable().accept(this.expressionVisitor);
        }
        if (declare.getType() == DeclareType.AS) {
            this.buffer.append(" AS ");
            this.buffer.append(declare.getTypeName());
            return;
        }
        if (declare.getType() == DeclareType.TABLE) {
            this.buffer.append(" TABLE (");
            for (int i = 0; i < declare.getColumnDefinitions().size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                this.buffer.append(declare.getColumnDefinitions().get(i).toString());
            }
            this.buffer.append(")");
        } else if (declare.getTypeDefinitions() != null) {
            for (int i = 0; i < declare.getTypeDefinitions().size(); ++i) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                DeclareStatement.TypeDefExpr type2 = declare.getTypeDefinitions().get(i);
                if (type2.userVariable != null) {
                    type2.userVariable.accept(this.expressionVisitor);
                    this.buffer.append(" ");
                }
                this.buffer.append(type2.colDataType.toString());
                if (type2.defaultExpr == null) continue;
                this.buffer.append(" = ");
                type2.defaultExpr.accept(this.expressionVisitor);
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor2) {
        this.expressionVisitor = visitor2;
    }
}

