/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;
import net.sf.jsqlparser.util.deparser.StatementDeParser;

public class CreateTableDeParser
extends AbstractDeParser<CreateTable> {
    private StatementDeParser statementDeParser;

    public CreateTableDeParser(StringBuilder buffer) {
        super(buffer);
    }

    public CreateTableDeParser(StatementDeParser statementDeParser, StringBuilder buffer) {
        super(buffer);
        this.statementDeParser = statementDeParser;
    }

    @Override
    public void deParse(CreateTable createTable) {
        String params2;
        this.buffer.append("CREATE ");
        if (createTable.isOrReplace()) {
            this.buffer.append("OR REPLACE ");
        }
        if (createTable.isUnlogged()) {
            this.buffer.append("UNLOGGED ");
        }
        if (!"".equals(params2 = PlainSelect.getStringList(createTable.getCreateOptionsStrings(), false, false))) {
            this.buffer.append(params2).append(' ');
        }
        this.buffer.append("TABLE ");
        if (createTable.isIfNotExists()) {
            this.buffer.append("IF NOT EXISTS ");
        }
        this.buffer.append(createTable.getTable().getFullyQualifiedName());
        if (createTable.getColumns() != null && !createTable.getColumns().isEmpty()) {
            this.buffer.append(" (");
            Iterator<String> columnIterator = createTable.getColumns().iterator();
            this.buffer.append(columnIterator.next());
            while (columnIterator.hasNext()) {
                this.buffer.append(", ").append(columnIterator.next());
            }
            this.buffer.append(")");
        }
        if (createTable.getColumnDefinitions() != null) {
            this.buffer.append(" (");
            Iterator<Object> iter = createTable.getColumnDefinitions().iterator();
            while (iter.hasNext()) {
                ColumnDefinition columnDefinition = iter.next();
                this.buffer.append(columnDefinition.getColumnName());
                this.buffer.append(" ");
                this.buffer.append(columnDefinition.getColDataType().toString());
                if (columnDefinition.getColumnSpecs() != null) {
                    for (String s : columnDefinition.getColumnSpecs()) {
                        this.buffer.append(" ");
                        this.buffer.append(s);
                    }
                }
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
            if (createTable.getIndexes() != null) {
                for (Index index : createTable.getIndexes()) {
                    this.buffer.append(", ");
                    this.buffer.append(index.toString());
                }
            }
            this.buffer.append(")");
        }
        if (!"".equals(params2 = PlainSelect.getStringList(createTable.getTableOptionsStrings(), false, false))) {
            this.buffer.append(' ').append(params2);
        }
        if (createTable.getRowMovement() != null) {
            this.buffer.append(' ').append(createTable.getRowMovement().getMode().toString()).append(" ROW MOVEMENT");
        }
        if (createTable.getSelect() != null) {
            this.buffer.append(" AS ");
            if (createTable.isSelectParenthesis()) {
                this.buffer.append("(");
            }
            Select sel = createTable.getSelect();
            sel.accept(this.statementDeParser);
            if (createTable.isSelectParenthesis()) {
                this.buffer.append(")");
            }
        }
        if (createTable.getLikeTable() != null) {
            this.buffer.append(" LIKE ");
            if (createTable.isSelectParenthesis()) {
                this.buffer.append("(");
            }
            Table table = createTable.getLikeTable();
            this.buffer.append(table.getFullyQualifiedName());
            if (createTable.isSelectParenthesis()) {
                this.buffer.append(")");
            }
        }
    }
}

