/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.update;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.schema.Column;

public class UpdateSet {
    protected boolean usingBracketsForColumns = false;
    protected boolean usingBracketsForValues = false;
    protected ArrayList<Column> columns = new ArrayList();
    protected ArrayList<Expression> expressions = new ArrayList();

    public UpdateSet() {
    }

    public UpdateSet(Column column2) {
        this.columns.add(column2);
    }

    public UpdateSet(Column column2, Expression expression) {
        this.columns.add(column2);
        this.expressions.add(expression);
    }

    public boolean isUsingBracketsForValues() {
        return this.usingBracketsForValues;
    }

    public void setUsingBracketsForValues(boolean usingBracketsForValues) {
        this.usingBracketsForValues = usingBracketsForValues;
    }

    public boolean isUsingBracketsForColumns() {
        return this.usingBracketsForColumns;
    }

    public void setUsingBracketsForColumns(boolean usingBracketsForColumns) {
        this.usingBracketsForColumns = usingBracketsForColumns;
    }

    public ArrayList<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(ArrayList<Column> columns) {
        this.columns = Objects.requireNonNull(columns);
    }

    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(ArrayList<Expression> expressions) {
        this.expressions = Objects.requireNonNull(expressions);
    }

    public void add(Column column2, Expression expression) {
        this.columns.add(column2);
        this.expressions.add(expression);
    }

    public void add(Column column2) {
        this.columns.add(column2);
    }

    public void add(Expression expression) {
        this.expressions.add(expression);
    }

    public void add(ExpressionList expressionList) {
        this.expressions.addAll(expressionList.getExpressions());
    }

    public static final StringBuilder appendUpdateSetsTo(StringBuilder builder2, Collection<UpdateSet> updateSets) {
        builder2.append(" SET ");
        int j = 0;
        for (UpdateSet updateSet : updateSets) {
            updateSet.appendTo(builder2, j);
            ++j;
        }
        return builder2;
    }

    StringBuilder appendTo(StringBuilder builder2, int j) {
        int i;
        if (j > 0) {
            builder2.append(", ");
        }
        if (this.usingBracketsForColumns) {
            builder2.append("(");
        }
        for (i = 0; i < this.columns.size(); ++i) {
            if (i > 0) {
                builder2.append(", ");
            }
            builder2.append(this.columns.get(i));
        }
        if (this.usingBracketsForColumns) {
            builder2.append(")");
        }
        builder2.append(" = ");
        if (this.usingBracketsForValues) {
            builder2.append("(");
        }
        for (i = 0; i < this.expressions.size(); ++i) {
            if (i > 0) {
                builder2.append(", ");
            }
            builder2.append(this.expressions.get(i));
        }
        if (this.usingBracketsForValues) {
            builder2.append(")");
        }
        return builder2;
    }
}

