/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubSelect;

public class WithItem
implements SelectBody {
    private String name;
    private List<SelectItem> withItemList;
    private ItemsList itemsList;
    private boolean useValues = true;
    private boolean useBracketsForValues = false;
    private SubSelect subSelect;
    private boolean recursive;

    public ItemsList getItemsList() {
        return this.itemsList;
    }

    public void setItemsList(ItemsList list) {
        this.itemsList = list;
    }

    public boolean isUseValues() {
        return this.useValues;
    }

    public void setUseValues(boolean useValues) {
        this.useValues = useValues;
    }

    public WithItem withItemsList(ItemsList itemsList) {
        this.setItemsList(itemsList);
        return this;
    }

    public WithItem withUseValues(boolean useValues) {
        this.setUseValues(useValues);
        return this;
    }

    public boolean isUsingBracketsForValues() {
        return this.useBracketsForValues;
    }

    public void setUseBracketsForValues(boolean useBracketsForValues) {
        this.useBracketsForValues = useBracketsForValues;
    }

    public WithItem withUseBracketsForValues(boolean useBracketsForValues) {
        this.setUseBracketsForValues(useBracketsForValues);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public SubSelect getSubSelect() {
        return this.subSelect;
    }

    public void setSubSelect(SubSelect subSelect) {
        this.subSelect = subSelect.withUseBrackets(false);
    }

    public List<SelectItem> getWithItemList() {
        return this.withItemList;
    }

    public void setWithItemList(List<SelectItem> withItemList) {
        this.withItemList = withItemList;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(this.recursive ? "RECURSIVE " : "");
        builder2.append(this.name);
        builder2.append(this.withItemList != null ? " " + PlainSelect.getStringList(this.withItemList, true, true) : "");
        builder2.append(" AS ");
        if (this.useValues) {
            builder2.append("(VALUES ");
            ExpressionList expressionList = (ExpressionList)this.itemsList;
            builder2.append(PlainSelect.getStringList(expressionList.getExpressions(), true, this.useBracketsForValues));
            builder2.append(")");
        } else {
            builder2.append(this.subSelect.isUseBrackets() ? "" : "(");
            builder2.append(this.subSelect);
            builder2.append(this.subSelect.isUseBrackets() ? "" : ")");
        }
        return builder2.toString();
    }

    @Override
    public void accept(SelectVisitor visitor2) {
        visitor2.visit(this);
    }

    public WithItem withName(String name) {
        this.setName(name);
        return this;
    }

    public WithItem withWithItemList(List<SelectItem> withItemList) {
        this.setWithItemList(withItemList);
        return this;
    }

    public WithItem withSubSelect(SubSelect subSelect) {
        this.setSubSelect(subSelect);
        return this;
    }

    public WithItem withRecursive(boolean recursive) {
        this.setRecursive(recursive);
        return this;
    }

    public WithItem addWithItemList(SelectItem ... withItemList) {
        List collection = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        Collections.addAll(collection, withItemList);
        return this.withWithItemList(collection);
    }

    public WithItem addWithItemList(Collection<? extends SelectItem> withItemList) {
        List collection = Optional.ofNullable(this.getWithItemList()).orElseGet(ArrayList::new);
        collection.addAll(withItemList);
        return this.withWithItemList(collection);
    }
}

