/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.statement.select.Fetch;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperation;
import net.sf.jsqlparser.statement.select.WithIsolation;

public class SetOperationList
implements SelectBody {
    private List<SelectBody> selects;
    private List<Boolean> brackets;
    private List<SetOperation> operations;
    private List<OrderByElement> orderByElements;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;
    private WithIsolation withIsolation;

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public List<SelectBody> getSelects() {
        return this.selects;
    }

    public void setSelects(List<SelectBody> selects) {
        this.selects = selects;
    }

    public void setOperations(List<SetOperation> operations) {
        this.operations = operations;
    }

    public List<SetOperation> getOperations() {
        return this.operations;
    }

    public List<Boolean> getBrackets() {
        return this.brackets;
    }

    public void setBrackets(List<Boolean> brackets) {
        this.brackets = brackets;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public void setBracketsOpsAndSelects(List<Boolean> brackets, List<SelectBody> select2, List<SetOperation> ops) {
        this.selects = select2;
        this.operations = ops;
        this.brackets = brackets;
        if (select2.size() - 1 != ops.size() || select2.size() != brackets.size()) {
            throw new IllegalArgumentException("list sizes are not valid");
        }
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch2) {
        this.fetch = fetch2;
    }

    public WithIsolation getWithIsolation() {
        return this.withIsolation;
    }

    public void setWithIsolation(WithIsolation withIsolation) {
        this.withIsolation = withIsolation;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.selects.size(); ++i) {
            if (i != 0) {
                buffer.append(" ").append(this.operations.get(i - 1).toString()).append(" ");
            }
            if (this.brackets == null || this.brackets.get(i).booleanValue()) {
                buffer.append("(").append(this.selects.get(i).toString()).append(")");
                continue;
            }
            buffer.append(this.selects.get(i).toString());
        }
        if (this.orderByElements != null) {
            buffer.append(PlainSelect.orderByToString(this.orderByElements));
        }
        if (this.limit != null) {
            buffer.append(this.limit.toString());
        }
        if (this.offset != null) {
            buffer.append(this.offset.toString());
        }
        if (this.fetch != null) {
            buffer.append(this.fetch.toString());
        }
        if (this.withIsolation != null) {
            buffer.append(this.withIsolation.toString());
        }
        return buffer.toString();
    }

    public SetOperationList withOperations(List<SetOperation> operationList) {
        this.setOperations(operationList);
        return this;
    }

    public SetOperationList withSelects(List<SelectBody> selects) {
        this.setSelects(selects);
        return this;
    }

    public SetOperationList withBrackets(List<Boolean> brackets) {
        this.setBrackets(brackets);
        return this;
    }

    public SetOperationList withOrderByElements(List<OrderByElement> orderByElements) {
        this.setOrderByElements(orderByElements);
        return this;
    }

    public SetOperationList withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public SetOperationList withOffset(Offset offset) {
        this.setOffset(offset);
        return this;
    }

    public SetOperationList withFetch(Fetch fetch2) {
        this.setFetch(fetch2);
        return this;
    }

    public SetOperationList addSelects(SelectBody ... selects) {
        List collection = Optional.ofNullable(this.getSelects()).orElseGet(ArrayList::new);
        Collections.addAll(collection, selects);
        return this.withSelects(collection);
    }

    public SetOperationList addSelects(Collection<? extends SelectBody> selects) {
        List collection = Optional.ofNullable(this.getSelects()).orElseGet(ArrayList::new);
        collection.addAll(selects);
        return this.withSelects(collection);
    }

    public SetOperationList addOperations(SetOperation ... operationList) {
        List collection = Optional.ofNullable(this.getOperations()).orElseGet(ArrayList::new);
        Collections.addAll(collection, operationList);
        return this.withOperations(collection);
    }

    public SetOperationList addOperations(Collection<? extends SetOperation> operationList) {
        List collection = Optional.ofNullable(this.getOperations()).orElseGet(ArrayList::new);
        collection.addAll(operationList);
        return this.withOperations(collection);
    }

    public SetOperationList addBrackets(Boolean ... brackets) {
        List collection = Optional.ofNullable(this.getBrackets()).orElseGet(ArrayList::new);
        Collections.addAll(collection, brackets);
        return this.withBrackets(collection);
    }

    public SetOperationList addBrackets(Collection<Boolean> brackets) {
        List collection = Optional.ofNullable(this.getBrackets()).orElseGet(ArrayList::new);
        collection.addAll(brackets);
        return this.withBrackets(collection);
    }

    public SetOperationList addOrderByElements(OrderByElement ... orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(collection, orderByElements);
        return this.withOrderByElements(collection);
    }

    public SetOperationList addOrderByElements(Collection<? extends OrderByElement> orderByElements) {
        List collection = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        collection.addAll(orderByElements);
        return this.withOrderByElements(collection);
    }

    public static enum SetOperationType {
        INTERSECT,
        EXCEPT,
        MINUS,
        UNION;

    }
}

