/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.insert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.insert.ConflictActionType;
import net.sf.jsqlparser.statement.update.UpdateSet;

public class InsertConflictAction {
    ConflictActionType conflictActionType;
    private final ArrayList<UpdateSet> updateSets = new ArrayList();
    Expression whereExpression;

    public InsertConflictAction(ConflictActionType conflictActionType) {
        this.conflictActionType = Objects.requireNonNull(conflictActionType, "The Conflict Action Type is mandatory and must not be Null.");
    }

    public ConflictActionType getConflictActionType() {
        return this.conflictActionType;
    }

    public void setConflictActionType(ConflictActionType conflictActionType) {
        this.conflictActionType = Objects.requireNonNull(conflictActionType, "The Conflict Action Type is mandatory and must not be Null.");
    }

    public InsertConflictAction withConflictActionType(ConflictActionType conflictActionType) {
        this.setConflictActionType(conflictActionType);
        return this;
    }

    public InsertConflictAction addUpdateSet(Column column2, Expression expression) {
        this.updateSets.add(new UpdateSet(column2, expression));
        return this;
    }

    public InsertConflictAction addUpdateSet(UpdateSet updateSet) {
        this.updateSets.add(updateSet);
        return this;
    }

    public InsertConflictAction withUpdateSets(Collection<UpdateSet> updateSets) {
        this.updateSets.clear();
        this.updateSets.addAll(updateSets);
        return this;
    }

    public Expression getWhereExpression() {
        return this.whereExpression;
    }

    public void setWhereExpression(Expression whereExpression) {
        this.whereExpression = whereExpression;
    }

    public InsertConflictAction withWhereExpression(Expression whereExpression) {
        this.setWhereExpression(whereExpression);
        return this;
    }

    public StringBuilder appendTo(StringBuilder builder2) {
        switch (this.conflictActionType) {
            case DO_NOTHING: {
                builder2.append(" DO NOTHING");
                break;
            }
            case DO_UPDATE: {
                builder2.append(" DO UPDATE ");
                UpdateSet.appendUpdateSetsTo(builder2, this.updateSets);
                if (this.whereExpression == null) break;
                builder2.append(" WHERE ").append(this.whereExpression);
            }
        }
        return builder2;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

