/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.drop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Drop
implements Statement {
    private String type;
    private Table name;
    private List<String> parameters;
    private Map<String, List<String>> typeToParameters = new HashMap<String, List<String>>();
    private boolean ifExists = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public Table getName() {
        return this.name;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getType() {
        return this.type;
    }

    public void setName(Table string) {
        this.name = string;
    }

    public void setParameters(List<String> list) {
        this.parameters = list;
    }

    public void setType(String string) {
        this.type = string;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    public Map<String, List<String>> getTypeToParameters() {
        return this.typeToParameters;
    }

    public void setTypeToParameters(Map<String, List<String>> typeToParameters) {
        this.typeToParameters = typeToParameters;
    }

    public String toString() {
        String sql = "DROP " + this.type + " " + (this.ifExists ? "IF EXISTS " : "") + this.name.toString();
        if (this.type.equals("FUNCTION")) {
            sql = sql + Drop.formatFuncParams(this.getParamsByType("FUNCTION"));
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            sql = sql + " " + PlainSelect.getStringList(this.parameters);
        }
        return sql;
    }

    public static String formatFuncParams(List<String> params2) {
        if (params2 == null) {
            return "";
        }
        return params2.isEmpty() ? "()" : PlainSelect.getStringList(params2, true, true);
    }

    public List<String> getParamsByType(String type2) {
        return this.typeToParameters.get(type2);
    }

    public Drop withIfExists(boolean ifExists) {
        this.setIfExists(ifExists);
        return this;
    }

    public Drop withType(String type2) {
        this.setType(type2);
        return this;
    }

    public Drop withName(Table name) {
        this.setName(name);
        return this;
    }

    public Drop withParameters(List<String> parameters2) {
        this.setParameters(parameters2);
        return this;
    }

    public Drop addParameters(String ... parameters2) {
        List collection = Optional.ofNullable(this.getParameters()).orElseGet(ArrayList::new);
        Collections.addAll(collection, parameters2);
        return this.withParameters(collection);
    }

    public Drop addParameters(Collection<String> parameters2) {
        List collection = Optional.ofNullable(this.getParameters()).orElseGet(ArrayList::new);
        collection.addAll(parameters2);
        return this.withParameters(collection);
    }
}

