/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.alter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;

public class RenameTableStatement
implements Statement {
    private final LinkedHashMap<Table, Table> tableNames = new LinkedHashMap();
    private boolean usingTableKeyword = false;
    private boolean usingIfExistsKeyword = false;
    private String waitDirective = "";

    public RenameTableStatement(Table oldName, Table newName) {
        this.tableNames.put(Objects.requireNonNull(oldName, "The OLD NAME of the Rename Statement must not be null."), Objects.requireNonNull(newName, "The NEW NAME of the Rename Statement must not be null."));
    }

    public RenameTableStatement(Table oldName, Table newName, boolean usingTableKeyword, boolean usingIfExistsKeyword, String waitDirective) {
        this.tableNames.put(Objects.requireNonNull(oldName, "The OLD NAME of the Rename Statement must not be null."), Objects.requireNonNull(newName, "The NEW NAME of the Rename Statement must not be null."));
        this.usingTableKeyword = usingTableKeyword;
        this.usingIfExistsKeyword = usingIfExistsKeyword;
        this.waitDirective = waitDirective;
    }

    public void addTableNames(Table oldName, Table newName) {
        this.tableNames.put(Objects.requireNonNull(oldName, "The OLD NAME of the Rename Statement must not be null."), Objects.requireNonNull(newName, "The NEW NAME of the Rename Statement must not be null."));
    }

    public boolean isUsingTableKeyword() {
        return this.usingTableKeyword;
    }

    public void setUsingTableKeyword(boolean usingTableKeyword) {
        this.usingTableKeyword = usingTableKeyword;
    }

    public RenameTableStatement withUsingTableKeyword(boolean usingTableKeyword) {
        this.usingTableKeyword = usingTableKeyword;
        return this;
    }

    public boolean isUsingIfExistsKeyword() {
        return this.usingIfExistsKeyword;
    }

    public void setUsingIfExistsKeyword(boolean usingIfExistsKeyword) {
        this.usingIfExistsKeyword = usingIfExistsKeyword;
    }

    public RenameTableStatement withUsingIfExistsKeyword(boolean usingIfExistsKeyword) {
        this.usingIfExistsKeyword = usingIfExistsKeyword;
        return this;
    }

    public String getWaitDirective() {
        return this.waitDirective;
    }

    public void setWaitDirective(String waitDirective) {
        this.waitDirective = waitDirective;
    }

    public RenameTableStatement withWaitDirective(String waitDirective) {
        this.waitDirective = waitDirective;
        return this;
    }

    public int getTableNamesSize() {
        return this.tableNames.size();
    }

    public boolean isTableNamesEmpty() {
        return this.tableNames.isEmpty();
    }

    public Set<Map.Entry<Table, Table>> getTableNames() {
        return this.tableNames.entrySet();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public StringBuilder appendTo(StringBuilder builder2) {
        int i = 0;
        for (Map.Entry<Table, Table> e : this.tableNames.entrySet()) {
            if (i == 0) {
                builder2.append("RENAME").append(this.usingTableKeyword ? " TABLE " : " ").append(this.usingIfExistsKeyword ? " IF EXISTS " : " ").append(e.getKey()).append(this.waitDirective != null && this.waitDirective.length() > 0 ? " " + this.waitDirective : "").append(" TO ").append(e.getValue());
            } else {
                builder2.append(", ").append(e.getKey()).append(" TO ").append(e.getValue());
            }
            ++i;
        }
        return builder2;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

