/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.alter;

import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.alter.AlterSystemOperation;

public class AlterSystemStatement
implements Statement {
    private final AlterSystemOperation operation;
    private final List<String> parameters;

    public AlterSystemStatement(AlterSystemOperation operation, List<String> parameters2) {
        this.operation = Objects.requireNonNull(operation, "The ALTER SYSTEM Operation must not be Null");
        this.parameters = Objects.requireNonNull(parameters2, "The PARAMETERS List must not be null although it can be empty.");
    }

    public AlterSystemOperation getOperation() {
        return this.operation;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    private static void appendParameters(StringBuilder builder2, List<String> parameters2) {
        for (String s : parameters2) {
            builder2.append(" ").append(s);
        }
    }

    public StringBuilder appendTo(StringBuilder builder2) {
        builder2.append("ALTER SYSTEM ").append((Object)this.operation);
        AlterSystemStatement.appendParameters(builder2, this.parameters);
        return builder2;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

