/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.alter;

import java.util.List;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.alter.AlterSessionOperation;

public class AlterSession
implements Statement {
    private AlterSessionOperation operation;
    private List<String> parameters;

    public AlterSession(AlterSessionOperation operation, List<String> parameters2) {
        this.operation = operation;
        this.parameters = parameters2;
    }

    public AlterSessionOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AlterSessionOperation operation) {
        this.operation = operation;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters2) {
        this.parameters = parameters2;
    }

    private static void appendParamaters(StringBuilder builder2, List<String> parameters2) {
        for (String s : parameters2) {
            builder2.append(" ").append(s);
        }
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("ALTER SESSION ");
        switch (this.operation) {
            case ADVISE_COMMIT: {
                builder2.append("ADVISE COMMIT");
                break;
            }
            case ADVISE_ROLLBACK: {
                builder2.append("ADVISE ROLLBACK");
                break;
            }
            case ADVISE_NOTHING: {
                builder2.append("ADVISE NOTHING");
                break;
            }
            case CLOSE_DATABASE_LINK: {
                builder2.append("CLOSE DATABASE LINK ");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
            case ENABLE_COMMIT_IN_PROCEDURE: {
                builder2.append("ENABLE COMMIT IN PROCEDURE");
                break;
            }
            case DISABLE_COMMIT_IN_PROCEDURE: {
                builder2.append("DISABLE COMMIT IN PROCEDURE");
                break;
            }
            case ENABLE_GUARD: {
                builder2.append("ENABLE GUARD");
                break;
            }
            case DISABLE_GUARD: {
                builder2.append("DISABLE GUARD");
                break;
            }
            case ENABLE_PARALLEL_DML: {
                builder2.append("ENABLE PARALLEL DML");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
            case DISABLE_PARALLEL_DML: {
                builder2.append("DISABLE PARALLEL DML");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
            case FORCE_PARALLEL_DML: {
                builder2.append("FORCE PARALLEL DML");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
            case ENABLE_PARALLEL_DDL: {
                builder2.append("ENABLE PARALLEL DDL");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
            case DISABLE_PARALLEL_DDL: {
                builder2.append("DISABLE PARALLEL DDL");
                break;
            }
            case FORCE_PARALLEL_DDL: {
                builder2.append("FORCE PARALLEL DDL");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
            case ENABLE_PARALLEL_QUERY: {
                builder2.append("ENABLE PARALLEL QUERY");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
            case DISABLE_PARALLEL_QUERY: {
                builder2.append("DISABLE PARALLEL QUERY");
                break;
            }
            case FORCE_PARALLEL_QUERY: {
                builder2.append("FORCE PARALLEL QUERY");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
            case ENABLE_RESUMABLE: {
                builder2.append("ENABLE RESUMABLE");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
            case DISABLE_RESUMABLE: {
                builder2.append("DISABLE RESUMABLE");
                break;
            }
            case SET: {
                builder2.append("SET");
                AlterSession.appendParamaters(builder2, this.parameters);
                break;
            }
        }
        return builder2.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }
}

