/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement;

import java.util.Objects;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.PurgeObjectType;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.create.table.Index;

public class PurgeStatement
implements Statement {
    private final PurgeObjectType purgeObjectType;
    private final Object object;
    private String userName;

    public PurgeStatement(Table table) {
        this.purgeObjectType = PurgeObjectType.TABLE;
        this.object = Objects.requireNonNull(table, "The TABLE of the PURGE TABLE statement must not be null.");
    }

    public PurgeStatement(Index index) {
        this.purgeObjectType = PurgeObjectType.INDEX;
        this.object = Objects.requireNonNull(index, "The INDEX of the PURGE INDEX statement must not be null.");
    }

    public PurgeStatement(PurgeObjectType purgeObjectType) {
        this.purgeObjectType = purgeObjectType;
        this.object = null;
    }

    public PurgeStatement(PurgeObjectType purgeObjectType, String tableSpaceName, String userName) {
        this.purgeObjectType = purgeObjectType;
        this.object = Objects.requireNonNull(tableSpaceName, "The TABLESPACE NAME of the PURGE TABLESPACE statement must not be null.");
        this.userName = userName;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public StringBuilder appendTo(StringBuilder builder2) {
        builder2.append("PURGE ");
        switch (this.purgeObjectType) {
            case RECYCLEBIN: 
            case DBA_RECYCLEBIN: {
                builder2.append((Object)this.purgeObjectType);
                break;
            }
            case TABLE: 
            case INDEX: {
                builder2.append((Object)this.purgeObjectType);
                if (this.object == null) break;
                builder2.append(" ").append(this.object);
                break;
            }
            case TABLESPACE: {
                builder2.append((Object)this.purgeObjectType);
                if (this.object != null) {
                    builder2.append(" ").append(this.object);
                }
                if (this.userName == null || this.userName.length() <= 0) break;
                builder2.append(" USER ").append(this.userName);
            }
        }
        return builder2;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public PurgeObjectType getPurgeObjectType() {
        return this.purgeObjectType;
    }

    public Object getObject() {
        return this.object;
    }
}

